/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.client.patchouli.processor;

import com.google.common.collect.ImmutableList;
import vazkii.botania.api.recipe.ElvenTradeRecipe;
import vazkii.botania.client.patchouli.PatchouliUtils;
import vazkii.botania.common.crafting.BotaniaRecipeTypes;
import vazkii.patchouli.api.IComponentProcessor;
import vazkii.patchouli.api.IVariable;
import vazkii.patchouli.api.IVariableProvider;

import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1937;
import net.minecraft.class_2960;

public class ElvenTradeProcessor implements IComponentProcessor {
	private List<ElvenTradeRecipe> recipes;
	private int longestIngredientSize, mostInputs, mostOutputs;

	@Override
	public void setup(class_1937 level, IVariableProvider variables) {
		ImmutableList.Builder<ElvenTradeRecipe> builder = ImmutableList.builder();
		for (IVariable s : variables.get("recipes").asListOrSingleton()) {
			ElvenTradeRecipe recipe = PatchouliUtils.getRecipe(level, BotaniaRecipeTypes.ELVEN_TRADE_TYPE, new class_2960(s.asString()));
			if (recipe != null) {
				builder.add(recipe);
			}
		}
		recipes = builder.build();
		for (ElvenTradeRecipe recipe : recipes) {
			List<class_1856> inputs = recipe.method_8117();
			for (class_1856 ingredient : inputs) {
				int length = ingredient.method_8105().length;
				if (length > longestIngredientSize) {
					longestIngredientSize = length;
				}
			}
			if (inputs.size() > mostInputs) {
				mostInputs = inputs.size();
			}
			if (recipe.getOutputs().size() > mostOutputs) {
				mostOutputs = recipe.getOutputs().size();
			}
		}
	}

	@Override
	public IVariable process(class_1937 level, String key) {
		if (recipes.isEmpty()) {
			return null;
		}
		if (key.equals("heading")) {
			return IVariable.from(recipes.get(0).getOutputs().get(0).method_7964());
		} else if (key.startsWith("input")) {
			int index = Integer.parseInt(key.substring(5)) - 1;
			if (index < mostInputs) {
				return interweaveIngredients(index);
			} else {
				return null;
			}
		}
		if (key.startsWith("output")) {
			int index = Integer.parseInt(key.substring(6)) - 1;
			if (index < mostOutputs) {
				return IVariable.wrapList(recipes.stream().map(ElvenTradeRecipe::getOutputs)
						.map(l -> index < l.size() ? l.get(index) : class_1799.field_8037)
						.map(IVariable::from)
						.collect(Collectors.toList()));
			}
		}
		return null;
	}

	private IVariable interweaveIngredients(int inputIndex) {
		List<class_1856> recipes = this.recipes.stream().map(ElvenTradeRecipe::method_8117).map(ingredients -> {
			if (inputIndex < ingredients.size()) {
				return ingredients.get(inputIndex);
			} else {
				return class_1856.field_9017;
			}
		}).collect(Collectors.toList());
		return PatchouliUtils.interweaveIngredients(recipes, longestIngredientSize);
	}

}
