package vazkii.botania.client.integration.emi;

import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.WidgetHolder;
import vazkii.botania.api.recipe.PetalApothecaryRecipe;
import vazkii.botania.common.block.BotaniaBlocks;

import java.util.List;
import java.util.stream.Stream;
import net.minecraft.class_1802;
import net.minecraft.class_3612;
import net.minecraft.class_5455;

public class PetalApothecaryEmiRecipe extends BotaniaEmiRecipe {
	private static final EmiStack APOTHECARY = EmiStack.of(BotaniaBlocks.defaultAltar);
	private static final EmiStack WATER_BUCKET = EmiStack.of(class_1802.field_8705);
	private static final EmiStack WATER = EmiStack.of(class_3612.field_15910);

	private final List<EmiIngredient> ingredients;
	private final EmiIngredient reagent;

	public PetalApothecaryEmiRecipe(PetalApothecaryRecipe recipe) {
		super(BotaniaEmiPlugin.PETAL_APOTHECARY, recipe);
		this.ingredients = recipe.method_8117().stream().map(EmiIngredient::of).toList();
		this.reagent = EmiIngredient.of(recipe.getReagent());
		this.input = Stream.concat(ingredients.stream(), Stream.of(WATER, reagent)).toList();
		// TODO 1.19.4 figure out the proper way to get a registry access
		this.output = List.of(EmiStack.of(recipe.method_8110(class_5455.field_40585)));
	}

	@Override
	public int getDisplayHeight() {
		return 107;
	}

	@Override
	public int getDisplayWidth() {
		return 106;
	}

	@Override
	public void addWidgets(WidgetHolder widgets) {
		RunicAltarEmiRecipe.addRunicAltarWidgets(widgets, this, ingredients, APOTHECARY, output.get(0), reagent, WATER_BUCKET);
	}
}
