/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.network.clientbound;

import vazkii.botania.network.BotaniaPacket;
import vazkii.botania.xplat.XplatAbstractions;

import static vazkii.botania.common.lib.ResourceLocationHelper.prefix;

import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_310;

public record ItemAgePacket(int entityId, int timeCounter) implements BotaniaPacket {

	public static final class_2960 ID = prefix("ia");

	@Override
	public void encode(class_2540 buf) {
		buf.method_10804(entityId());
		buf.method_10804(timeCounter());
	}

	@Override
	public class_2960 getFabricId() {
		return ID;
	}

	public static ItemAgePacket decode(class_2540 buf) {
		return new ItemAgePacket(buf.method_10816(), buf.method_10816());
	}

	public static class Handler {
		public static void handle(ItemAgePacket packet) {
			int entityId = packet.entityId();
			int counter = packet.timeCounter();
			class_310.method_1551().execute(() -> {
				class_1297 e = class_310.method_1551().field_1687.method_8469(entityId);
				if (e instanceof class_1542 item) {
					XplatAbstractions.INSTANCE.itemFlagsComponent(item).timeCounter = counter;
				}
			});
		}
	}

}
