/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import vazkii.botania.api.block_entity.FunctionalFlowerBlockEntity;
import vazkii.botania.api.block_entity.SpecialFlowerBlockEntity;
import vazkii.botania.common.block.decor.FloatingFlowerBlock;

import java.util.function.Supplier;
import net.minecraft.class_1309;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2390;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_5558;
import net.minecraft.class_5819;

public class FloatingSpecialFlowerBlock extends FloatingFlowerBlock {
	private final Supplier<class_2591<? extends SpecialFlowerBlockEntity>> blockEntityType;
	private final boolean hasComparatorOutput;

	public FloatingSpecialFlowerBlock(class_2251 props,
			Supplier<class_2591<? extends SpecialFlowerBlockEntity>> blockEntityType) {
		this(props, blockEntityType, false);
	}

	public FloatingSpecialFlowerBlock(class_2251 props,
			Supplier<class_2591<? extends SpecialFlowerBlockEntity>> blockEntityType,
			boolean hasComparatorOutput) {
		super(class_1767.field_7952, props);
		this.blockEntityType = blockEntityType;
		this.hasComparatorOutput = hasComparatorOutput;
	}

	@Override
	public void method_9496(class_2680 state, class_1937 world, class_2338 pos, class_5819 rand) {
		redstoneParticlesIfPowered(state, world, pos, rand);
	}

	public static void redstoneParticlesIfPowered(class_2680 state, class_1937 world, class_2338 pos, class_5819 rand) {
		class_2586 te = world.method_8321(pos);
		if (te instanceof FunctionalFlowerBlockEntity flower && rand.method_43056()) {
			if (flower.acceptsRedstone() && flower.redstoneSignal > 0) {
				class_265 shape = state.method_26218(world, pos);
				if (!shape.method_1110()) {
					class_238 localBox = shape.method_1107();
					double x = pos.method_10263() + localBox.field_1323 + rand.method_43058() * (localBox.field_1320 - localBox.field_1323);
					double y = pos.method_10264() + localBox.field_1322 + rand.method_43058() * (localBox.field_1325 - localBox.field_1322);
					double z = pos.method_10260() + localBox.field_1321 + rand.method_43058() * (localBox.field_1324 - localBox.field_1321);
					world.method_8406(class_2390.field_11188, x, y, z, 0, 0, 0);
				}
			}
		}
	}

	@Override
	public void method_9567(class_1937 world, class_2338 pos, class_2680 state, @Nullable class_1309 entity, class_1799 stack) {
		((SpecialFlowerBlockEntity) world.method_8321(pos)).setPlacedBy(world, pos, state, entity, stack);
	}

	@Override
	public void method_9536(class_2680 state, class_1937 level, class_2338 pos, class_2680 newState, boolean movedByPiston) {
		if (hasComparatorOutput && !newState.method_26221()) {
			level.method_8455(pos, newState.method_26204());
		}
		super.method_9536(state, level, pos, newState, movedByPiston);
	}

	@NotNull
	@Override
	public class_2586 method_10123(@NotNull class_2338 pos, @NotNull class_2680 state) {
		SpecialFlowerBlockEntity te = blockEntityType.get().method_11032(pos, state);
		te.setFloating(true);
		return te;
	}

	@Nullable
	@Override
	public <T extends class_2586> class_5558<T> method_31645(class_1937 level, class_2680 blockState, class_2591<T> type) {
		return createTickerHelper(type, blockEntityType.get(), SpecialFlowerBlockEntity::commonTick);
	}

	@Override
	public boolean method_9498(class_2680 bs) {
		return hasComparatorOutput;
	}

	@Override
	public int method_9572(class_2680 bs, class_1937 level, class_2338 pos) {
		if (level.method_8321(pos) instanceof SpecialFlowerBlockEntity flower) {
			return flower.getComparatorSignal();
		}
		return 0;
	}
}
