/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.test.item;

import net.minecraft.class_1268;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1430;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2741;
import net.minecraft.class_3417;
import net.minecraft.class_4516;
import net.minecraft.class_6302;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.block.block_entity.BotaniaBlockEntities;
import vazkii.botania.common.block.block_entity.CacophoniumBlockEntity;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.item.CacophoniumItem;
import vazkii.botania.test.TestingUtil;

// https://github.com/williewillus/botania-fabric-issues/issues/92
public class CacophoniumTest {
	@class_6302(method_35936 = "botania:block/cacophonium")
	public void testCacophonium(class_4516 helper) {
		class_2338 cowPos = new class_2338(1, 2, 1);
		class_2338 noteBlockPos = new class_2338(1, 2, 3);
		helper.method_35972(class_2246.field_10179, noteBlockPos);

		class_1657 player = helper.method_36021();
		class_1430 cow = helper.method_36009(class_1299.field_6085, cowPos);

		//Give a cacophonium to the player.
		player.method_5673(class_1304.field_6173, new class_1799(BotaniaItems.cacophonium));

		//Use the cacophonium on the cow.
		player.method_7287(cow, class_1268.field_5808);
		TestingUtil.assertEquals(CacophoniumItem.getSound(player.method_6047()), class_3417.field_14780);

		//Use the cacophonium on the note block.
		TestingUtil.useItemOn(helper, player, class_1268.field_5808, noteBlockPos);
		helper.method_35972(BotaniaBlocks.cacophonium, noteBlockPos);

		CacophoniumBlockEntity cacophoniumBlock = TestingUtil.assertBlockEntity(helper, noteBlockPos, BotaniaBlockEntities.CACOPHONIUM);
		TestingUtil.assertEqualsAt(helper, noteBlockPos, CacophoniumItem.getSound(cacophoniumBlock.stack), class_3417.field_14780);

		//Moo.
		helper.method_35984(noteBlockPos.method_10072(), class_2246.field_10002);
		helper.method_35987(noteBlockPos, class_2741.field_12484, true);

		helper.method_36036();
	}
}
