package vazkii.botania.fabric.data;

import net.fabricmc.fabric.api.tag.convention.v1.ConventionalItemTags;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_2444;
import net.minecraft.class_2447;
import net.minecraft.class_2450;
import net.minecraft.class_7784;
import net.minecraft.class_7800;
import org.apache.commons.lang3.mutable.MutableObject;

import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.lib.BotaniaTags;
import vazkii.botania.data.recipes.BotaniaRecipeProvider;
import vazkii.botania.data.recipes.GogAlternationResult;

import java.util.function.Consumer;

import static vazkii.botania.data.recipes.CraftingRecipeProvider.*;

public class FabricRecipeProvider extends BotaniaRecipeProvider {
	public FabricRecipeProvider(class_7784 packOutput) {
		super(packOutput);
	}

	@Override
	protected void buildRecipes(Consumer<class_2444> consumer) {
		// Quartz tag
		class_2450.method_10447(class_7800.field_40634, BotaniaBlocks.azulejo0)
				.method_10454(class_1802.field_8345)
				.method_10446(FabricItemTagProvider.QUARTZ_BLOCKS)
				.method_10442("has_item", conditionsFromItem(class_1802.field_8345))
				.method_10431(consumer);

		// Chest tag
		class_2447.method_10437(class_7800.field_40638, BotaniaItems.baubleBox)
				.method_10433('C', FabricItemTagProvider.WOODEN_CHESTS)
				.method_10434('G', class_1802.field_8695)
				.method_10433('M', BotaniaTags.Items.INGOTS_MANASTEEL)
				.method_10439(" M ")
				.method_10439("MCM")
				.method_10439(" G ")
				.method_10429("has_item", conditionsFromTag(BotaniaTags.Items.INGOTS_MANASTEEL))
				.method_10431(consumer);

		// uses colorless glass tags on Forge
		class_2447.method_10437(class_7800.field_40638, BotaniaItems.glassPick)
				.method_10434('T', BotaniaItems.livingwoodTwig)
				.method_10434('G', class_1802.field_8280)
				.method_10433('I', BotaniaTags.Items.INGOTS_MANASTEEL)
				.method_10439("GIG")
				.method_10439(" T ")
				.method_10439(" T ")
				.method_10429("has_item", conditionsFromTag(BotaniaTags.Items.INGOTS_MANASTEEL))
				.method_10431(consumer);
		class_2447.method_10437(class_7800.field_40642, BotaniaItems.lensNormal)
				.method_10433('S', BotaniaTags.Items.INGOTS_MANASTEEL)
				.method_10428('G', class_1856.method_8091(class_1802.field_8280, class_1802.field_8141))
				.method_10439(" S ")
				.method_10439("SGS")
				.method_10439(" S ")
				.method_10429("has_item", conditionsFromTag(BotaniaTags.Items.INGOTS_MANASTEEL))
				.method_10431(consumer);
		class_2447.method_10437(class_7800.field_40635, BotaniaBlocks.prism)
				.method_10434('P', class_1802.field_8434)
				.method_10434('S', BotaniaBlocks.spectralPlatform)
				.method_10434('G', class_1802.field_8280)
				.method_10439("GPG")
				.method_10439("GSG")
				.method_10439("GPG")
				.method_10429("has_item", conditionsFromItem(class_1802.field_8434))
				.method_10429("has_alt_item", conditionsFromItem(BotaniaBlocks.spectralPlatform))
				.method_10431(consumer);

		registerRedStringBlock(consumer, BotaniaBlocks.redStringContainer, class_1856.method_8106(FabricItemTagProvider.WOODEN_CHESTS), conditionsFromTag(FabricItemTagProvider.WOODEN_CHESTS));
		class_2450.method_10447(class_7800.field_40636, BotaniaBlocks.corporeaRetainer)
				.method_10446(FabricItemTagProvider.WOODEN_CHESTS)
				.method_10454(BotaniaItems.corporeaSpark)
				.method_10442("has_item", conditionsFromItem(BotaniaItems.corporeaSpark))
				.method_10431(consumer);
		class_2450.method_10448(class_7800.field_40642, BotaniaItems.phantomInk, 4)
				.method_10454(BotaniaItems.manaPearl)
				.method_10446(ConventionalItemTags.DYES)
				.method_10446(ConventionalItemTags.GLASS_BLOCKS)
				.method_10449(class_1802.field_8469, 4)
				.method_10442("has_item", conditionsFromItem(BotaniaItems.manaPearl))
				.method_10431(consumer);

		MutableObject<class_2444> base = new MutableObject<>();
		MutableObject<class_2444> gog = new MutableObject<>();
		class_2450.method_10447(class_7800.field_40642, BotaniaItems.fertilizer)
				.method_10454(class_1802.field_8324)
				.method_10453(class_1856.method_8106(ConventionalItemTags.DYES), 4)
				.method_10442("has_item", conditionsFromTag(ConventionalItemTags.DYES))
				.method_36443(base::setValue, "botania:fertilizer_dye");
		class_2450.method_10448(class_7800.field_40642, BotaniaItems.fertilizer, 3)
				.method_10454(class_1802.field_8324)
				.method_10453(class_1856.method_8106(ConventionalItemTags.DYES), 4)
				.method_10442("has_item", conditionsFromTag(ConventionalItemTags.DYES))
				.method_36443(gog::setValue, "botania:fertilizer_dye");
		consumer.accept(new GogAlternationResult(gog.getValue(), base.getValue()));
	}

	@Override
	public String method_10321() {
		return "Botania recipes (Fabric-specific)";
	}
}
