/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.lens;

import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_239;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_3532;
import net.minecraft.class_5250;
import net.minecraft.class_5251;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.api.internal.ManaBurst;
import vazkii.botania.api.mana.BasicLensItem;
import vazkii.botania.api.mana.BurstProperties;
import vazkii.botania.api.mana.CompositableLensItem;
import vazkii.botania.api.mana.ControlLensItem;
import vazkii.botania.api.mana.ManaReceiver;
import vazkii.botania.api.mana.ManaSpreader;
import vazkii.botania.api.mana.TinyPlanetExcempt;
import vazkii.botania.common.helper.ColorHelper;
import vazkii.botania.common.helper.ItemNBTHelper;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.item.lens.Lens;
import vazkii.botania.common.item.lens.StormLens;

public class LensItem
extends class_1792
implements ControlLensItem,
CompositableLensItem,
TinyPlanetExcempt {
    public static final int PROP_NONE = 0;
    public static final int PROP_POWER = 1;
    public static final int PROP_ORIENTATION = 2;
    public static final int PROP_TOUCH = 4;
    public static final int PROP_INTERACTION = 8;
    public static final int PROP_DAMAGE = 16;
    public static final int PROP_CONTROL = 32;
    private static final String TAG_COLOR = "color";
    private static final String TAG_COMPOSITE_LENS = "compositeLens";
    private final Lens lens;
    private final int props;

    public LensItem(class_1792.class_1793 builder, Lens lens, int props) {
        super(builder);
        this.lens = lens;
        this.props = props;
    }

    public void method_7851(class_1799 stack, class_1937 world, List<class_2561> stacks, class_1836 flags) {
        int storedColor = LensItem.getStoredColor(stack);
        if (storedColor != -1) {
            class_5250 colorName = class_2561.method_43471((String)(storedColor == 16 ? "botania.color.rainbow" : "color.minecraft." + class_1767.method_7791((int)storedColor)));
            class_5251 realColor = class_5251.method_27717((int)this.getLensColor(stack, world));
            stacks.add((class_2561)class_2561.method_43469((String)"botaniamisc.color", (Object[])new Object[]{colorName}).method_27694(s -> s.method_27703(realColor)));
        }
        if (this.lens instanceof StormLens) {
            stacks.add((class_2561)class_2561.method_43471((String)"botaniamisc.creative").method_27692(class_124.field_1080));
        }
    }

    @NotNull
    public class_2561 method_7864(@NotNull class_1799 stack) {
        class_1799 compositeLens = this.getCompositeLens(stack);
        if (compositeLens.method_7960()) {
            return super.method_7864(stack);
        }
        String shortKeyA = stack.method_7922() + ".short";
        String shortKeyB = compositeLens.method_7922() + ".short";
        return class_2561.method_43469((String)"item.botania.composite_lens", (Object[])new Object[]{class_2561.method_43471((String)shortKeyA), class_2561.method_43471((String)shortKeyB)});
    }

    @Override
    public void apply(class_1799 stack, BurstProperties props, class_1937 level) {
        class_1792 class_17922;
        int storedColor = LensItem.getStoredColor(stack);
        if (storedColor != -1) {
            props.color = this.getLensColor(stack, level);
        }
        LensItem.getLens(stack).apply(stack, props);
        class_1799 compositeLens = this.getCompositeLens(stack);
        if (!compositeLens.method_7960() && (class_17922 = compositeLens.method_7909()) instanceof BasicLensItem) {
            BasicLensItem lens = (BasicLensItem)class_17922;
            lens.apply(compositeLens, props, level);
        }
    }

    @Override
    public boolean collideBurst(ManaBurst burst, class_239 pos, boolean isManaBlock, boolean shouldKill, class_1799 stack) {
        class_1792 class_17922;
        shouldKill = LensItem.getLens(stack).collideBurst(burst, pos, isManaBlock, shouldKill, stack);
        class_1799 compositeLens = this.getCompositeLens(stack);
        if (!compositeLens.method_7960() && (class_17922 = compositeLens.method_7909()) instanceof BasicLensItem) {
            BasicLensItem lens = (BasicLensItem)class_17922;
            shouldKill = lens.collideBurst(burst, pos, isManaBlock, shouldKill, compositeLens);
        }
        return shouldKill;
    }

    @Override
    public void updateBurst(ManaBurst burst, class_1799 stack) {
        class_1792 class_17922;
        int storedColor = LensItem.getStoredColor(stack);
        if (storedColor == 16 && burst.entity().method_37908().field_9236) {
            burst.setColor(this.getLensColor(stack, burst.entity().method_37908()));
        }
        LensItem.getLens(stack).updateBurst(burst, stack);
        class_1799 compositeLens = this.getCompositeLens(stack);
        if (!compositeLens.method_7960() && (class_17922 = compositeLens.method_7909()) instanceof BasicLensItem) {
            BasicLensItem lens = (BasicLensItem)class_17922;
            lens.updateBurst(burst, compositeLens);
        }
    }

    @Override
    public int getLensColor(class_1799 stack, class_1937 level) {
        int storedColor = LensItem.getStoredColor(stack);
        if (storedColor == -1) {
            return 0xFFFFFF;
        }
        if (storedColor == 16) {
            if (level == null) {
                return 0xFFFFFF;
            }
            return class_3532.method_15369((float)((float)(level.method_8510() * 2L % 360L) / 360.0f), (float)1.0f, (float)1.0f);
        }
        return ColorHelper.getColorValue(class_1767.method_7791((int)storedColor));
    }

    public static int getStoredColor(class_1799 stack) {
        return ItemNBTHelper.getInt(stack, TAG_COLOR, -1);
    }

    public static void setLensColor(class_1799 stack, int color) {
        ItemNBTHelper.setInt(stack, TAG_COLOR, color);
    }

    @Override
    public boolean doParticles(ManaBurst burst, class_1799 stack) {
        return true;
    }

    public static boolean isBlacklisted(class_1799 lens1, class_1799 lens2) {
        CompositableLensItem item1 = (CompositableLensItem)lens1.method_7909();
        CompositableLensItem item2 = (CompositableLensItem)lens2.method_7909();
        return (item1.getProps(lens1) & item2.getProps(lens2)) != 0;
    }

    public static Lens getLens(class_1799 stack) {
        class_1792 class_17922 = stack.method_7909();
        if (class_17922 instanceof LensItem) {
            LensItem lens = (LensItem)class_17922;
            return lens.lens;
        }
        return new Lens();
    }

    @Override
    public boolean canCombineLenses(class_1799 sourceLens, class_1799 compositeLens) {
        CompositableLensItem compositeItem;
        CompositableLensItem sourceItem = (CompositableLensItem)sourceLens.method_7909();
        if (sourceItem == (compositeItem = (CompositableLensItem)compositeLens.method_7909())) {
            return false;
        }
        if (!sourceItem.isCombinable(sourceLens) || !compositeItem.isCombinable(compositeLens)) {
            return false;
        }
        return !LensItem.isBlacklisted(sourceLens, compositeLens);
    }

    @Override
    public class_1799 getCompositeLens(class_1799 stack) {
        class_2487 cmp = ItemNBTHelper.getCompound(stack, TAG_COMPOSITE_LENS, true);
        if (cmp == null) {
            return class_1799.field_8037;
        }
        return class_1799.method_7915((class_2487)cmp);
    }

    @Override
    public class_1799 setCompositeLens(class_1799 sourceLens, class_1799 compositeLens) {
        if (compositeLens.method_7960()) {
            ItemNBTHelper.removeEntry(sourceLens, TAG_COMPOSITE_LENS);
        } else {
            class_2487 cmp = compositeLens.method_7953(new class_2487());
            ItemNBTHelper.setCompound(sourceLens, TAG_COMPOSITE_LENS, cmp);
        }
        return sourceLens;
    }

    @Override
    public int getManaToTransfer(ManaBurst burst, class_1799 stack, ManaReceiver receiver) {
        return LensItem.getLens(stack).getManaToTransfer(burst, stack, receiver);
    }

    @Override
    public boolean shouldPull(class_1799 stack) {
        return !stack.method_31574(BotaniaItems.lensStorm);
    }

    @Override
    public boolean isControlLens(class_1799 stack) {
        return (this.getProps(stack) & 0x20) != 0;
    }

    @Override
    public boolean allowBurstShooting(class_1799 stack, ManaSpreader spreader, boolean redstone) {
        return LensItem.getLens(stack).allowBurstShooting(stack, spreader, redstone);
    }

    @Override
    public void onControlledSpreaderTick(class_1799 stack, ManaSpreader spreader, boolean redstone) {
        LensItem.getLens(stack).onControlledSpreaderTick(stack, spreader, redstone);
    }

    @Override
    public void onControlledSpreaderPulse(class_1799 stack, ManaSpreader spreader) {
        LensItem.getLens(stack).onControlledSpreaderPulse(stack, spreader);
    }

    @Override
    public int getProps(class_1799 stack) {
        return this.props;
    }

    @Override
    public boolean isCombinable(class_1799 stack) {
        return !stack.method_31574(BotaniaItems.lensNormal);
    }
}

