/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.crafting.recipe;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.yggdrasil.response.MinecraftTexturesPayload;
import com.mojang.util.UUIDTypeAdapter;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_1263;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1843;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_1869;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2512;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_5250;
import net.minecraft.class_5455;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.common.crafting.BotaniaRecipeTypes;
import vazkii.botania.common.crafting.RunicAltarRecipe;
import vazkii.botania.common.helper.ItemNBTHelper;

public class HeadRecipe
extends RunicAltarRecipe {
    private static final Pattern PROFILE_PATTERN = Pattern.compile("(?<base64>[A-Za-z0-9+/]{100,}={0,2})|(?<url>(?=\\S{50,})https?://(?!bugs|education|feedback)\\w+\\.(?:minecraft\\.net|mojang\\.com)/\\S+)|(?<hash>[0-9a-f]{64})");
    public static final String TEXTURE_URL_BASE = "https://textures.minecraft.net/texture/";
    private static final Supplier<Gson> gson = Suppliers.memoize(() -> new GsonBuilder().registerTypeAdapter(UUID.class, (Object)new UUIDTypeAdapter()).create());
    private static final GameProfile PROFILE_VALID_RESULT = new GameProfile(null, "valid");

    public HeadRecipe(class_2960 id, class_1799 output, int mana, class_1856 ... inputs) {
        super(id, output, mana, inputs);
    }

    @Override
    public boolean method_8115(class_1263 inv, @NotNull class_1937 world) {
        boolean matches = super.method_8115(inv, world);
        boolean foundName = false;
        if (matches) {
            class_1799 stack;
            for (int i = 0; i < inv.method_5439() && !(stack = inv.method_5438(i)).method_7960(); ++i) {
                if (stack.method_31574(class_1802.field_8448)) {
                    if (foundName || !stack.method_7938() || stack.method_7964().getString().isBlank()) {
                        return false;
                    }
                    foundName = true;
                    continue;
                }
                if (!stack.method_31574(class_1802.field_8360)) continue;
                if (foundName || !class_1843.method_8053((class_2487)stack.method_7969()) || this.parseProfileFromBook(stack, true) == null) {
                    return false;
                }
                foundName = true;
            }
        }
        return matches;
    }

    @Override
    @NotNull
    public class_1799 method_8116(@NotNull class_1263 inv, @NotNull class_5455 registries) {
        class_1799 stack = this.method_8110(registries).method_7972();
        for (int i = 0; i < inv.method_5439(); ++i) {
            class_1799 ingr = inv.method_5438(i);
            if (ingr.method_31574(class_1802.field_8448)) {
                ItemNBTHelper.setString(stack, "SkullOwner", ingr.method_7964().getString());
                break;
            }
            if (!ingr.method_31574(class_1802.field_8360)) continue;
            GameProfile profile = this.parseProfileFromBook(ingr, false);
            ItemNBTHelper.setCompound(stack, "SkullOwner", class_2512.method_10684((class_2487)new class_2487(), (GameProfile)profile));
            break;
        }
        return stack;
    }

    private GameProfile parseProfileFromBook(class_1799 stack, boolean validateOnly) {
        class_2487 tag = stack.method_7969();
        String name = tag.method_10558("title");
        if (name.isBlank()) {
            return null;
        }
        class_2499 pages = tag.method_10554("pages", 8);
        int maxPages = Math.min(2, pages.size());
        for (int i = 0; i < maxPages; ++i) {
            Object textureUrl;
            String pageJson = pages.method_10608(i);
            String pageText = HeadRecipe.parsePage(pageJson);
            Matcher matcher = PROFILE_PATTERN.matcher(pageText);
            if (!matcher.matches()) continue;
            String hash = matcher.group("hash");
            if (hash != null) {
                textureUrl = TEXTURE_URL_BASE + hash;
            } else {
                String url = matcher.group("url");
                if (url != null) {
                    try {
                        URL validUrl = new URL(url);
                        textureUrl = validUrl.toString();
                    }
                    catch (Exception e) {
                        return null;
                    }
                } else {
                    String base64 = matcher.group("base64");
                    if (base64 != null) {
                        try {
                            String json = new String(Base64.getDecoder().decode(base64), StandardCharsets.UTF_8);
                            MinecraftTexturesPayload result = (MinecraftTexturesPayload)((Gson)gson.get()).fromJson(json, MinecraftTexturesPayload.class);
                            MinecraftProfileTexture skinTexture = (MinecraftProfileTexture)result.getTextures().get(MinecraftProfileTexture.Type.SKIN);
                            String skinTextureUrl = skinTexture.getUrl();
                            if (!PROFILE_PATTERN.matcher(skinTextureUrl).matches()) {
                                return null;
                            }
                            URL validUrl = new URL(skinTextureUrl);
                            textureUrl = validUrl.toString();
                        }
                        catch (Exception e) {
                            return null;
                        }
                    } else {
                        return null;
                    }
                }
            }
            if (validateOnly) {
                return PROFILE_VALID_RESULT;
            }
            String profileTextureJson = "{textures:{SKIN:{url:\"%s\"}}}".formatted(textureUrl);
            GameProfile profile = new GameProfile(null, name);
            String propertyBase64 = Base64.getEncoder().encodeToString(profileTextureJson.getBytes(StandardCharsets.UTF_8));
            profile.getProperties().put((Object)"textures", (Object)new Property("Value", propertyBase64));
            return profile;
        }
        return null;
    }

    private static String parsePage(String pageJson) {
        try {
            class_5250 formattedtext = class_2561.class_2562.method_10877((String)pageJson);
            return formattedtext != null ? formattedtext.getString() : pageJson;
        }
        catch (Exception exception) {
            return pageJson;
        }
    }

    public static class Serializer
    implements class_1865<HeadRecipe> {
        @NotNull
        public HeadRecipe fromJson(@NotNull class_2960 id, @NotNull JsonObject json) {
            class_1799 output = class_1869.method_35228((JsonObject)class_3518.method_15296((JsonObject)json, (String)"output"));
            int mana = class_3518.method_15260((JsonObject)json, (String)"mana");
            JsonArray ingrs = class_3518.method_15261((JsonObject)json, (String)"ingredients");
            ArrayList<class_1856> inputs = new ArrayList<class_1856>();
            for (JsonElement e : ingrs) {
                inputs.add(class_1856.method_52177((JsonElement)e));
            }
            return new HeadRecipe(id, output, mana, inputs.toArray(new class_1856[0]));
        }

        public HeadRecipe fromNetwork(@NotNull class_2960 id, @NotNull class_2540 buf) {
            class_1856[] inputs = new class_1856[buf.method_10816()];
            for (int i = 0; i < inputs.length; ++i) {
                inputs[i] = class_1856.method_8086((class_2540)buf);
            }
            class_1799 output = buf.method_10819();
            int mana = buf.method_10816();
            return new HeadRecipe(id, output, mana, inputs);
        }

        public void toNetwork(@NotNull class_2540 buf, @NotNull HeadRecipe recipe) {
            BotaniaRecipeTypes.RUNE_SERIALIZER.method_8124(buf, (class_1860)recipe);
        }
    }
}

