/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.core.handler;

import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.class_1087;
import net.minecraft.class_1088;
import net.minecraft.class_1767;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.BotaniaAPIClient;
import vazkii.botania.api.block.FloatingFlower;
import vazkii.botania.client.model.TinyPotatoModel;
import vazkii.botania.client.render.block_entity.CorporeaCrystalCubeBlockEntityRenderer;
import vazkii.botania.client.render.block_entity.ManaPumpBlockEntityRenderer;
import vazkii.botania.common.helper.ColorHelper;
import vazkii.botania.common.lib.ResourceLocationHelper;
import vazkii.botania.xplat.ClientXplatAbstractions;

public class MiscellaneousModels {
    private static final class_2960 goldfishModelId = ResourceLocationHelper.prefix("icon/goldfish");
    private static final class_2960 phiFlowerModelId = ResourceLocationHelper.prefix("icon/phiflower");
    private static final class_2960 nerfBatModelId = ResourceLocationHelper.prefix("icon/nerfbat");
    private static final class_2960 bloodPendantChainId = ResourceLocationHelper.prefix("icon/blood_pendant_chain");
    private static final class_2960 bloodPendantGemId = ResourceLocationHelper.prefix("icon/blood_pendant_gem");
    private static final class_2960[] kingKeyWeaponModelIds = (class_2960[])IntStream.range(0, 12).mapToObj(i -> ResourceLocationHelper.prefix("icon/gate_weapon_" + i)).toArray(class_2960[]::new);
    private static final class_2960 terrasteelHelmWillModelId = ResourceLocationHelper.prefix("icon/will_flame");
    private static final class_2960[] thirdEyeLayerIds = (class_2960[])IntStream.range(0, 3).mapToObj(i -> ResourceLocationHelper.prefix("icon/third_eye_" + i)).toArray(class_2960[]::new);
    private static final class_2960 pyroclastGemId = ResourceLocationHelper.prefix("icon/lava_pendant_gem");
    private static final class_2960 crimsonGemId = ResourceLocationHelper.prefix("icon/super_lava_pendant_gem");
    private static final class_2960 itemFinderGemId = ResourceLocationHelper.prefix("icon/itemfinder_gem");
    private static final class_2960 cirrusGemId = ResourceLocationHelper.prefix("icon/cloud_pendant_gem");
    private static final class_2960 nimbusGemId = ResourceLocationHelper.prefix("icon/super_cloud_pendant_gem");
    private static final class_2960 snowflakePendantGemId = ResourceLocationHelper.prefix("icon/ice_pendant_gem");
    private static final class_2960[] tiaraWingIconIds = (class_2960[])IntStream.range(0, 9).mapToObj(i -> ResourceLocationHelper.prefix("icon/tiara_wing_" + (i + 1))).toArray(class_2960[]::new);
    private static final class_2960 corporeaCrystalCubeGlassId = ResourceLocationHelper.prefix("block/corporea_crystal_cube_glass");
    private static final class_2960 manaPumpHead = ResourceLocationHelper.prefix("block/pump_head");
    private static final class_2960 elvenSpreaderCoreId = ResourceLocationHelper.prefix("block/elven_spreader_core");
    private static final class_2960 gaiaSpreaderCoreId = ResourceLocationHelper.prefix("block/gaia_spreader_core");
    private static final class_2960 manaSpreaderCoreId = ResourceLocationHelper.prefix("block/mana_spreader_core");
    private static final class_2960 redstoneSpreaderCoreId = ResourceLocationHelper.prefix("block/redstone_spreader_core");
    private static final class_2960 manaSpreaderScaffoldingId = ResourceLocationHelper.prefix("block/mana_spreader_scaffolding");
    private static final class_2960 elvenSpreaderScaffoldingId = ResourceLocationHelper.prefix("block/elven_spreader_scaffolding");
    private static final class_2960 gaiaSpreaderScaffoldingId = ResourceLocationHelper.prefix("block/gaia_spreader_scaffolding");
    private static final Map<class_1767, class_2960> spreaderPaddingIds = new EnumMap(ColorHelper.supportedColors().collect(Collectors.toMap(Function.identity(), color -> ResourceLocationHelper.prefix("block/" + color.method_15434() + "_spreader_padding"))));
    public static final MiscellaneousModels INSTANCE = new MiscellaneousModels();
    private final Map<class_2960, Function<class_1087, class_1087>> afterBakeModifiers;
    private final Map<class_2960, Consumer<class_1087>> modelConsumers;
    public boolean registeredModels = false;
    public final class_1087[] tiaraWingIcons;
    public final class_1087[] thirdEyeLayers;
    public class_1087 goldfishModel;
    public class_1087 phiFlowerModel;
    public class_1087 nerfBatModel;
    public class_1087 bloodPendantChain;
    public class_1087 bloodPendantGem;
    public class_1087 snowflakePendantGem;
    public class_1087 itemFinderGem;
    public class_1087 pyroclastGem;
    public class_1087 crimsonGem;
    public class_1087 cirrusGem;
    public class_1087 nimbusGem;
    public class_1087 terrasteelHelmWillModel;
    public class_1087 elvenSpreaderCore;
    public class_1087 gaiaSpreaderCore;
    public class_1087 manaSpreaderCore;
    public class_1087 redstoneSpreaderCore;
    public class_1087 manaSpreaderScaffolding;
    public class_1087 elvenSpreaderScaffolding;
    public class_1087 gaiaSpreaderScaffolding;
    public final HashMap<class_1767, class_1087> spreaderPaddings = new HashMap();
    public final class_1087[] kingKeyWeaponModels;

    public void onModelRegister(class_3300 rm, Consumer<class_2960> consumer) {
        this.modelConsumers.keySet().forEach(consumer);
        MiscellaneousModels.registerIslands();
        MiscellaneousModels.registerTaters(rm, consumer);
        if (!this.registeredModels) {
            this.registeredModels = true;
        }
    }

    private static void registerIslands() {
        BotaniaAPIClient.instance().registerIslandTypeModel(FloatingFlower.IslandType.GRASS, ResourceLocationHelper.prefix("block/islands/island_grass"));
        BotaniaAPIClient.instance().registerIslandTypeModel(FloatingFlower.IslandType.PODZOL, ResourceLocationHelper.prefix("block/islands/island_podzol"));
        BotaniaAPIClient.instance().registerIslandTypeModel(FloatingFlower.IslandType.MYCEL, ResourceLocationHelper.prefix("block/islands/island_mycel"));
        BotaniaAPIClient.instance().registerIslandTypeModel(FloatingFlower.IslandType.SNOW, ResourceLocationHelper.prefix("block/islands/island_snow"));
        BotaniaAPIClient.instance().registerIslandTypeModel(FloatingFlower.IslandType.DRY, ResourceLocationHelper.prefix("block/islands/island_dry"));
        BotaniaAPIClient.instance().registerIslandTypeModel(FloatingFlower.IslandType.GOLDEN, ResourceLocationHelper.prefix("block/islands/island_golden"));
        BotaniaAPIClient.instance().registerIslandTypeModel(FloatingFlower.IslandType.VIVID, ResourceLocationHelper.prefix("block/islands/island_vivid"));
        BotaniaAPIClient.instance().registerIslandTypeModel(FloatingFlower.IslandType.SCORCHED, ResourceLocationHelper.prefix("block/islands/island_scorched"));
        BotaniaAPIClient.instance().registerIslandTypeModel(FloatingFlower.IslandType.INFUSED, ResourceLocationHelper.prefix("block/islands/island_infused"));
        BotaniaAPIClient.instance().registerIslandTypeModel(FloatingFlower.IslandType.MUTATED, ResourceLocationHelper.prefix("block/islands/island_mutated"));
    }

    private static void registerTaters(class_3300 rm, Consumer<class_2960> consumer) {
        for (class_2960 model : rm.method_14488("models/tiny_potato", s -> s.method_12832().endsWith(".json")).keySet()) {
            if (!"botania".equals(model.method_12836())) continue;
            String path = model.method_12832();
            path = path.substring("models/".length(), path.length() - ".json".length());
            consumer.accept(new class_2960("botania", path));
        }
    }

    public void onModelBake(class_1088 loader, Map<class_2960, class_1087> map) {
        if (!this.registeredModels) {
            BotaniaAPI.LOGGER.error("Additional models failed to register! Aborting baking models to avoid early crashing.");
            return;
        }
        this.afterBakeModifiers.forEach((resourceLocation, afterBakeModifier) -> map.computeIfPresent((class_2960)resourceLocation, (resourceLoc, bakedModel) -> (class_1087)afterBakeModifier.apply(bakedModel)));
        this.modelConsumers.forEach((resourceLocation, bakedModelConsumer) -> bakedModelConsumer.accept((class_1087)map.get(resourceLocation)));
    }

    public class_1087 modifyModelAfterbake(class_1087 bakedModel, class_2960 id) {
        this.modelConsumers.getOrDefault(id, model -> {}).accept(bakedModel);
        return (class_1087)this.afterBakeModifiers.getOrDefault(id, Function.identity()).apply(bakedModel);
    }

    private MiscellaneousModels() {
        this.afterBakeModifiers = new HashMap<class_2960, Function<class_1087, class_1087>>();
        this.afterBakeModifiers.put((class_2960)ResourceLocationHelper.modelResourceLocation("abstruse_platform", ""), ClientXplatAbstractions.INSTANCE::wrapPlatformModel);
        this.afterBakeModifiers.put((class_2960)ResourceLocationHelper.modelResourceLocation("spectral_platform", ""), ClientXplatAbstractions.INSTANCE::wrapPlatformModel);
        this.afterBakeModifiers.put((class_2960)ResourceLocationHelper.modelResourceLocation("infrangible_platform", ""), ClientXplatAbstractions.INSTANCE::wrapPlatformModel);
        this.afterBakeModifiers.put((class_2960)ResourceLocationHelper.modelResourceLocation("tiny_potato", "inventory"), TinyPotatoModel::new);
        this.modelConsumers = new HashMap<class_2960, Consumer<class_1087>>();
        this.modelConsumers.put(elvenSpreaderCoreId, bakedModel -> {
            this.elvenSpreaderCore = bakedModel;
        });
        this.modelConsumers.put(gaiaSpreaderCoreId, bakedModel -> {
            this.gaiaSpreaderCore = bakedModel;
        });
        this.modelConsumers.put(manaSpreaderCoreId, bakedModel -> {
            this.manaSpreaderCore = bakedModel;
        });
        this.modelConsumers.put(redstoneSpreaderCoreId, bakedModel -> {
            this.redstoneSpreaderCore = bakedModel;
        });
        this.modelConsumers.put(manaSpreaderScaffoldingId, bakedModel -> {
            this.manaSpreaderScaffolding = bakedModel;
        });
        this.modelConsumers.put(elvenSpreaderScaffoldingId, bakedModel -> {
            this.elvenSpreaderScaffolding = bakedModel;
        });
        this.modelConsumers.put(gaiaSpreaderScaffoldingId, bakedModel -> {
            this.gaiaSpreaderScaffolding = bakedModel;
        });
        for (class_1767 color : spreaderPaddingIds.keySet()) {
            this.modelConsumers.put(spreaderPaddingIds.get(color), bakedModel -> this.spreaderPaddings.put(color, (class_1087)bakedModel));
        }
        this.modelConsumers.put(corporeaCrystalCubeGlassId, bakedModel -> {
            CorporeaCrystalCubeBlockEntityRenderer.cubeModel = bakedModel;
        });
        this.modelConsumers.put(manaPumpHead, bakedModel -> {
            ManaPumpBlockEntityRenderer.headModel = bakedModel;
        });
        this.modelConsumers.put(goldfishModelId, bakedModel -> {
            this.goldfishModel = bakedModel;
        });
        this.modelConsumers.put(phiFlowerModelId, bakedModel -> {
            this.phiFlowerModel = bakedModel;
        });
        this.modelConsumers.put(nerfBatModelId, bakedModel -> {
            this.nerfBatModel = bakedModel;
        });
        this.modelConsumers.put(bloodPendantChainId, bakedModel -> {
            this.bloodPendantChain = bakedModel;
        });
        this.modelConsumers.put(bloodPendantGemId, bakedModel -> {
            this.bloodPendantGem = bakedModel;
        });
        this.modelConsumers.put(terrasteelHelmWillModelId, bakedModel -> {
            this.terrasteelHelmWillModel = bakedModel;
        });
        this.modelConsumers.put(pyroclastGemId, bakedModel -> {
            this.pyroclastGem = bakedModel;
        });
        this.modelConsumers.put(crimsonGemId, bakedModel -> {
            this.crimsonGem = bakedModel;
        });
        this.modelConsumers.put(itemFinderGemId, bakedModel -> {
            this.itemFinderGem = bakedModel;
        });
        this.modelConsumers.put(cirrusGemId, bakedModel -> {
            this.cirrusGem = bakedModel;
        });
        this.modelConsumers.put(nimbusGemId, bakedModel -> {
            this.nimbusGem = bakedModel;
        });
        this.modelConsumers.put(snowflakePendantGemId, bakedModel -> {
            this.snowflakePendantGem = bakedModel;
        });
        this.kingKeyWeaponModels = MiscellaneousModels.getBakedModels(this.modelConsumers, kingKeyWeaponModelIds);
        this.thirdEyeLayers = MiscellaneousModels.getBakedModels(this.modelConsumers, thirdEyeLayerIds);
        this.tiaraWingIcons = MiscellaneousModels.getBakedModels(this.modelConsumers, tiaraWingIconIds);
    }

    private static class_1087[] getBakedModels(Map<class_2960, Consumer<class_1087>> consumers, class_2960[] ids) {
        class_1087[] bakedModels = new class_1087[ids.length];
        int i = 0;
        while (i < ids.length) {
            int index = i++;
            consumers.put(ids[index], bakedModel -> {
                bakedModels[index] = bakedModel;
            });
        }
        return bakedModels;
    }
}

