package vazkii.botania.mixin;

import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1747;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2371;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import vazkii.botania.api.item.BlockProvider;
import vazkii.botania.common.lib.BotaniaTags;
import vazkii.botania.xplat.XplatAbstractions;

@Mixin(class_1661.class)
public class InventoryMixin {
	@Shadow
	@Final
	public class_1657 player;

	@Shadow
	@Final
	public class_2371<class_1799> items;

	/**
	 * Also look for block providers when picking a block, if the actual block item could not be found.
	 */
	@Inject(method = "findSlotMatchingItem", at = @At("RETURN"), cancellable = true)
	private void findBlockProviderItem(class_1799 searchStack, CallbackInfoReturnable<Integer> cir) {
		if (this.player.method_31549().field_7477 || cir.getReturnValue() != -1
				|| !(searchStack.method_7909() instanceof class_1747 blockItem)) {
			// skip when in creative mode, when an exact match was already found, or when not looking for a block item
			return;
		}

		class_2248 block = blockItem.method_7711();
		for (int i = 0; i < this.items.size(); ++i) {
			class_1799 invStack = this.items.get(i);
			if (!invStack.method_31573(BotaniaTags.Items.PICKABLE_BLOCK_PROVIDER)) {
				continue;
			}
			var provider = XplatAbstractions.INSTANCE.findBlockProvider(invStack);
			if (provider != null && provider.provideBlock(this.player, searchStack, block, false)) {
				cir.setReturnValue(i);
				return;
			}
		}
	}
}
