/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.loot;

import java.util.function.BiConsumer;
import net.minecraft.class_2960;
import net.minecraft.class_5339;
import net.minecraft.class_5342;

import static vazkii.botania.common.lib.ResourceLocationHelper.prefix;

public class BotaniaLootModifiers {
	public static final class_5342 TRUE_GUARDIAN_KILLER = new class_5342(new TrueGuardianKiller.Serializer());
	public static final class_5342 ENABLE_RELICS = new class_5342(new EnableRelics.Serializer());
	public static final class_5342 KILLED_BY_REAL_PLAYER = new class_5342(new RealPlayerCondition.Serializer());
	public static final class_5339 BIND_UUID = new class_5339(new BindUuid.Serializer());

	public static void submitLootConditions(BiConsumer<class_5342, class_2960> consumer) {
		consumer.accept(TRUE_GUARDIAN_KILLER, prefix("true_guardian_killer"));
		consumer.accept(ENABLE_RELICS, prefix("enable_relics"));
		consumer.accept(KILLED_BY_REAL_PLAYER, prefix("killed_by_player"));
	}

	public static void submitLootFunctions(BiConsumer<class_5339, class_2960> consumer) {
		consumer.accept(BIND_UUID, prefix("bind_uuid"));
	}
}
