/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.handler;

import com.google.common.collect.ImmutableMap;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.lib.BotaniaTags;
import vazkii.botania.common.lib.LibBlockNames;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.stream.StreamSupport;
import net.minecraft.class_140;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_2960;
import net.minecraft.class_6880;
import net.minecraft.class_7923;

public class ContributorList {
	private static final ImmutableMap<String, String> LEGACY_FLOWER_NAMES = ImmutableMap.<String, String>builder()
			.put("daybloom", LibBlockNames.MOTIF_DAYBLOOM)
			.put("nightshade", LibBlockNames.MOTIF_NIGHTSHADE)
			.put("puredaisy", LibBlockNames.SUBTILE_PUREDAISY.method_12832())
			.put("fallenkanade", LibBlockNames.SUBTILE_FALLEN_KANADE.method_12832())
			.put("heiseidream", LibBlockNames.SUBTILE_HEISEI_DREAM.method_12832())
			.put("arcanerose", LibBlockNames.SUBTILE_ARCANE_ROSE.method_12832())
			.put("jadedamaranthus", LibBlockNames.SUBTILE_JADED_AMARANTHUS.method_12832())
			.put("orechidignem", LibBlockNames.SUBTILE_ORECHID_IGNEM.method_12832())
			.build();
	private static volatile Map<String, class_1799> flowerMap = Collections.emptyMap();
	private static boolean startedLoading = false;

	public static final String TAG_HEADFLOWER = "botania:headflower";

	public static void firstStart() {
		if (!startedLoading) {
			Thread thread = new Thread(ContributorList::fetch);
			thread.setName("Botania Contributor Fanciness Thread");
			thread.setDaemon(true);
			thread.setUncaughtExceptionHandler(new class_140(BotaniaAPI.LOGGER));
			thread.start();

			startedLoading = true;
		}
	}

	public static class_1799 getFlower(String name) {
		return flowerMap.getOrDefault(name, class_1799.field_8037);
	}

	public static boolean hasFlower(String name) {
		return flowerMap.containsKey(name);
	}

	private static void load(Properties props) {
		Map<String, class_1799> m = new HashMap<>();
		Map<class_1792, class_1799> cachedStacks = new HashMap<>();
		for (String key : props.stringPropertyNames()) {
			String value = props.getProperty(key);

			class_1799 stack;
			try {
				int i = Integer.parseInt(value);
				if (i < 0 || i >= 16) {
					throw new NumberFormatException();
				}
				stack = cachedStacks.computeIfAbsent(BotaniaBlocks.getFlower(class_1767.method_7791(i)).method_8389(), ContributorList::configureStack);
			} catch (NumberFormatException e) {
				String rawName = value.toLowerCase(Locale.ROOT);
				String flowerName = LEGACY_FLOWER_NAMES.getOrDefault(rawName, rawName);

				var item = StreamSupport.stream(class_7923.field_41178.method_40286(BotaniaTags.Items.CONTRIBUTOR_HEADFLOWERS).spliterator(), false)
						.filter(h -> h.method_40224(resKey -> resKey.method_29177().method_12832().equals(flowerName)))
						.findFirst()
						.map(class_6880::comp_349)
						.orElse(class_1802.field_8880);
				stack = cachedStacks.computeIfAbsent(item, ContributorList::configureStack);
			}
			m.put(key, stack);
		}
		flowerMap = m;
	}

	private static class_1799 configureStack(class_1792 item) {
		class_1799 stack = new class_1799(item);
		Map<class_1887, Integer> ench = new HashMap<>();
		ench.put(class_1893.field_9119, 1);
		class_7923.field_41176.method_17966(new class_2960("charm", "tinted")).ifPresent(e -> ench.put(e, 1));
		class_1890.method_8214(ench, stack);

		stack.method_7969().method_10556(TAG_HEADFLOWER, true);
		stack.method_7969().method_10582("charm_glint", class_1767.field_7947.method_15434());
		return stack;
	}

	private static void fetch() {
		InputStream stream;
		try {
			URL url = new URL("https://raw.githubusercontent.com/Vazkii/Botania/master/contributors.properties");
			stream = url.openStream();
		} catch (IOException e) {
			BotaniaAPI.LOGGER.info("Could not load live contributors list. Either you're offline or GitHub is down. Loading bundled copy.");
			stream = ContributorList.class.getClassLoader().getResourceAsStream("contributors.properties");
			if (stream == null) {
				BotaniaAPI.LOGGER.info("Could not load bundled contributors list, somehow.");
				return;
			}
		}
		try {
			Properties props = new Properties();
			props.load(new InputStreamReader(stream, StandardCharsets.UTF_8));
			load(props);
			stream.close();
		} catch (IOException e) {
			BotaniaAPI.LOGGER.info("Error while reading contributors list.");
		}
	}
}
