/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.handler;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.internal.ManaNetwork;
import vazkii.botania.api.mana.ManaBlockType;
import vazkii.botania.api.mana.ManaCollector;
import vazkii.botania.api.mana.ManaNetworkAction;
import vazkii.botania.api.mana.ManaPool;
import vazkii.botania.api.mana.ManaReceiver;
import vazkii.botania.common.helper.MathHelper;
import vazkii.botania.xplat.XplatAbstractions;

public final class ManaNetworkHandler
implements ManaNetwork {
    public static final ManaNetworkHandler instance = new ManaNetworkHandler();
    private final Map<class_1937, Set<ManaPool>> manaPools = new WeakHashMap<class_1937, Set<ManaPool>>();
    private final Map<class_1937, Set<ManaCollector>> manaCollectors = new WeakHashMap<class_1937, Set<ManaCollector>>();

    public void onNetworkEvent(ManaReceiver thing, ManaBlockType type, ManaNetworkAction action) {
        switch (type) {
            case COLLECTOR: {
                if (action == ManaNetworkAction.ADD) {
                    this.add(this.manaCollectors, thing.getManaReceiverLevel(), (ManaCollector)thing);
                    break;
                }
                this.remove(this.manaCollectors, thing.getManaReceiverLevel(), (ManaCollector)thing);
                break;
            }
            case POOL: {
                if (action == ManaNetworkAction.ADD) {
                    this.add(this.manaPools, thing.getManaReceiverLevel(), (ManaPool)thing);
                    break;
                }
                this.remove(this.manaPools, thing.getManaReceiverLevel(), (ManaPool)thing);
            }
        }
    }

    @Override
    public void clear() {
        this.manaPools.clear();
        this.manaCollectors.clear();
    }

    @Override
    public ManaPool getClosestPool(class_2338 pos, class_1937 world, int limit) {
        if (this.manaPools.containsKey(world)) {
            return this.getClosest(this.manaPools.get(world), pos, limit);
        }
        return null;
    }

    @Override
    public ManaCollector getClosestCollector(class_2338 pos, class_1937 world, int limit) {
        if (this.manaCollectors.containsKey(world)) {
            return this.getClosest(this.manaCollectors.get(world), pos, limit);
        }
        return null;
    }

    public boolean isCollectorIn(class_1937 level, ManaCollector collector) {
        return this.manaCollectors.getOrDefault(level, Collections.emptySet()).contains(collector);
    }

    public boolean isPoolIn(class_1937 level, ManaPool pool) {
        return this.manaPools.getOrDefault(level, Collections.emptySet()).contains(pool);
    }

    @Nullable
    private <T extends ManaReceiver> T getClosest(Set<T> receivers, class_2338 pos, int limit) {
        long minDist = Long.MAX_VALUE;
        long limitSquared = (long)limit * (long)limit;
        ManaReceiver closest = null;
        for (ManaReceiver receiver : receivers) {
            long distance = MathHelper.distSqr((class_2382)receiver.getManaReceiverPos(), (class_2382)pos);
            if (distance > limitSquared || distance >= minDist) continue;
            minDist = distance;
            closest = receiver;
        }
        return (T)closest;
    }

    private <T> void remove(Map<class_1937, Set<T>> map, class_1937 level, T thing) {
        if (!map.containsKey(level)) {
            return;
        }
        Set<T> set = map.get(level);
        set.remove(thing);
        if (set.isEmpty()) {
            map.remove(level);
        }
    }

    private <T> void add(Map<class_1937, Set<T>> map, class_1937 level, T thing) {
        map.computeIfAbsent(level, k -> new HashSet()).add(thing);
    }

    @Override
    public Set<ManaCollector> getAllCollectorsInWorld(class_1937 world) {
        return this.getAllInWorld(this.manaCollectors, world);
    }

    @Override
    public Set<ManaPool> getAllPoolsInWorld(class_1937 world) {
        return this.getAllInWorld(this.manaPools, world);
    }

    @Override
    public void fireManaNetworkEvent(ManaReceiver thing, ManaBlockType type, ManaNetworkAction action) {
        XplatAbstractions.INSTANCE.fireManaNetworkEvent(thing, type, action);
    }

    private <T> Set<T> getAllInWorld(Map<class_1937, Set<T>> map, class_1937 world) {
        Set<T> ret = map.get(world);
        if (ret == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(ret);
    }
}

