/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.mixin.client;

import net.minecraft.class_1799;
import net.minecraft.class_507;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyVariable;

import vazkii.botania.client.core.RecipeBookAccess;

@Mixin(class_507.class)
public class RecipeBookComponentMixin implements RecipeBookAccess {
	@Unique
	private class_1799 hoveredGhostRecipeStack;

	@Override
	public class_1799 getHoveredGhostRecipeStack() {
		return hoveredGhostRecipeStack;
	}

	// Captures the stack that had its tooltip drawn.
	@ModifyVariable(method = "renderGhostRecipeTooltip", at = @At("RETURN"), ordinal = 0, require = 0)
	private class_1799 captureHoveredGhostStack(class_1799 stack) {
		hoveredGhostRecipeStack = stack;
		return stack;
	}
}
