/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block.block_entity.mana;

import vazkii.botania.api.mana.ManaPool;
import vazkii.botania.api.mana.ManaReceiver;
import vazkii.botania.common.block.block_entity.BotaniaBlockEntities;
import vazkii.botania.common.block.block_entity.BotaniaBlockEntity;
import vazkii.botania.xplat.XplatAbstractions;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;

public class ManaSplitterBlockEntity extends BotaniaBlockEntity implements ManaReceiver {
	private final List<ManaReceiver> validPools = new ArrayList<>();

	public ManaSplitterBlockEntity(class_2338 pos, class_2680 state) {
		super(BotaniaBlockEntities.DISTRIBUTOR, pos, state);
	}

	public static void serverTick(class_1937 level, class_2338 worldPosition, class_2680 state, ManaSplitterBlockEntity self) {
		self.validPools.clear();
		for (class_2350 dir : class_2350.class_2353.field_11062) {
			class_2338 pos = worldPosition.method_10093(dir);
			if (level.method_22340(pos)) {
				var receiver = XplatAbstractions.INSTANCE.findManaReceiver(level, pos, dir.method_10153());
				if (receiver instanceof ManaPool) {
					if (!receiver.isFull()) {
						self.validPools.add(receiver);
					}
				}
			}
		}
	}

	@Override
	public class_1937 getManaReceiverLevel() {
		return method_10997();
	}

	@Override
	public class_2338 getManaReceiverPos() {
		return method_11016();
	}

	@Override
	public int getCurrentMana() {
		return 0;
	}

	@Override
	public boolean isFull() {
		return validPools.isEmpty();
	}

	@Override
	public void receiveMana(int mana) {
		int tiles = validPools.size();
		if (tiles != 0) {
			int manaForEach = mana / tiles;
			for (ManaReceiver pool : validPools) {
				pool.receiveMana(manaForEach);
			}
		}
	}

	@Override
	public boolean canReceiveManaFromBursts() {
		return !isFull();
	}
}
