/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block.block_entity;

import com.google.common.base.Preconditions;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3829;

public abstract class SimpleInventoryBlockEntity extends BotaniaBlockEntity implements class_3829 {

	private final class_1277 itemHandler = createItemHandler();

	protected SimpleInventoryBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
		super(type, pos, state);
		itemHandler.method_5489(i -> method_5431());
	}

	private static void copyToInv(class_2371<class_1799> src, class_1263 dest) {
		Preconditions.checkArgument(src.size() == dest.method_5439());
		for (int i = 0; i < src.size(); i++) {
			dest.method_5447(i, src.get(i));
		}
	}

	private static class_2371<class_1799> copyFromInv(class_1263 inv) {
		class_2371<class_1799> ret = class_2371.method_10213(inv.method_5439(), class_1799.field_8037);
		for (int i = 0; i < inv.method_5439(); i++) {
			ret.set(i, inv.method_5438(i));
		}
		return ret;
	}

	@Override
	public void readPacketNBT(class_2487 tag) {
		class_2371<class_1799> tmp = class_2371.method_10213(inventorySize(), class_1799.field_8037);
		class_1262.method_5429(tag, tmp);
		copyToInv(tmp, itemHandler);
	}

	@Override
	public void writePacketNBT(class_2487 tag) {
		class_1262.method_5426(tag, copyFromInv(itemHandler));
	}

	// NB: Cannot be named the same as the corresponding method in vanilla's interface -- causes obf issues with MCP
	public final int inventorySize() {
		return getItemHandler().method_5439();
	}

	protected abstract class_1277 createItemHandler();

	@Override
	public void method_5448() {
		getItemHandler().method_5448();
	}

	public final class_1263 getItemHandler() {
		return itemHandler;
	}
}
