/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block;

import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2189;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2402;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_5819;
import net.minecraft.world.level.block.*;
import org.jetbrains.annotations.NotNull;

import vazkii.botania.common.block.block_entity.FakeAirBlockEntity;

public class FakeAirBlock extends class_2189 implements class_2343, class_2402 {

	public FakeAirBlock(class_2251 builder) {
		super(builder);
	}

	@Override
	public void method_9612(class_2680 state, class_1937 world, class_2338 pos, class_2248 block, class_2338 fromPos, boolean isMoving) {
		if (shouldRemove(world, pos)) {
			world.method_39279(pos, this, 4);
		}
	}

	private boolean shouldRemove(class_1937 world, class_2338 pos) {
		return !(world.method_8321(pos) instanceof FakeAirBlockEntity fakeAir) || !fakeAir.canStay();
	}

	@Override
	public void method_9588(class_2680 state, class_3218 world, class_2338 pos, class_5819 rand) {
		if (shouldRemove(world, pos)) {
			world.method_8501(pos, rand.method_43048(10) == 0 ? class_2246.field_10382.method_9564() : class_2246.field_10124.method_9564());
		}
	}

	@NotNull
	@Override
	public class_2586 method_10123(@NotNull class_2338 pos, @NotNull class_2680 state) {
		return new FakeAirBlockEntity(pos, state);
	}

	@Override
	public boolean method_10310(class_1922 blockGetter, class_2338 pos, class_2680 state, class_3611 fluid) {
		return false;
	}

	@Override
	public boolean method_10311(class_1936 levelAccessor, class_2338 pos, class_2680 blockState, class_3610 fluidState) {
		return false;
	}
}
