/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block.mana;

import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_3218;
import net.minecraft.class_5819;
import vazkii.botania.api.internal.ManaBurst;
import vazkii.botania.api.mana.ManaCollisionGhost;
import vazkii.botania.api.mana.ManaTrigger;
import vazkii.botania.client.fx.SparkleParticleData;
import vazkii.botania.common.block.BotaniaBlock;

public class ManaDetectorBlock extends BotaniaBlock implements ManaCollisionGhost {

	public ManaDetectorBlock(class_2251 builder) {
		super(builder);
		method_9590(method_9564().method_11657(class_2741.field_12484, false));
	}

	@Override
	protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
		builder.method_11667(class_2741.field_12484);
	}

	@Override
	public boolean method_9506(class_2680 state) {
		return true;
	}

	@Override
	public int method_9524(class_2680 state, class_1922 world, class_2338 pos, class_2350 side) {
		return state.method_11654(class_2741.field_12484) ? 15 : 0;
	}

	@Override
	public Behaviour getGhostBehaviour() {
		return Behaviour.RUN_RECEIVER_TRIGGER;
	}

	public static class ManaTriggerImpl implements ManaTrigger {
		private final class_1937 world;
		private final class_2338 pos;
		private final class_2680 state;

		public ManaTriggerImpl(class_1937 world, class_2338 pos, class_2680 state) {
			this.world = world;
			this.pos = pos;
			this.state = state;
		}

		@Override
		public void onBurstCollision(ManaBurst burst) {
			if (!world.field_9236 && !burst.isFake()) {
				if (!state.method_11654(class_2741.field_12484) && !world.method_8397().method_8674(pos, state.method_26204())) {
					world.method_8501(pos, state.method_11657(class_2741.field_12484, true));
					world.method_39279(pos, state.method_26204(), 4);
				}
			}
		}
	}

	@Override
	public void method_9588(class_2680 state, class_3218 level, class_2338 pos, class_5819 random) {
		if (state.method_11654(class_2741.field_12484)) {
			level.method_8501(pos, state.method_11657(class_2741.field_12484, false));
		}
	}

	@Override
	public void method_9615(class_2680 state, class_1937 level, class_2338 pos, class_2680 oldState, boolean isMoving) {
		if (!level.field_9236 && !state.method_27852(oldState.method_26204())
				&& state.method_11654(class_2741.field_12484)
				&& !level.method_8397().method_8674(pos, this)) {
			level.method_8652(pos, state.method_11657(class_2741.field_12484, false), class_2248.field_31031 | class_2248.field_31028);
		}
	}

	@Override
	public void method_9496(class_2680 state, class_1937 level, class_2338 pos, class_5819 rand) {
		if (state.method_11654(class_2741.field_12484)) {
			for (int i = 0; i < 4; i++) {
				SparkleParticleData data = SparkleParticleData.sparkle(0.7F + 0.5F * (float) Math.random(), 1F, 0.2F, 0.2F, 5);
				level.method_8406(data, pos.method_10263() + Math.random(), pos.method_10264() + Math.random(), pos.method_10260() + Math.random(), 0, 0, 0);
			}
		}
	}

}
