/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block;

import net.minecraft.class_1767;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import net.minecraft.class_4275;
import net.minecraft.class_4538;
import net.minecraft.class_5819;
import vazkii.botania.client.fx.SparkleParticleData;
import vazkii.botania.common.annotations.SoftImplement;
import vazkii.botania.common.block.decor.BotaniaGlassBlock;

public class PermanentBifrostBlock extends BotaniaGlassBlock implements class_4275 {
	public PermanentBifrostBlock(class_2251 builder) {
		super(builder);
	}

	@Override
	public void method_9496(class_2680 state, class_1937 world, class_2338 pos, class_5819 rand) {
		if (rand.method_43056()) {
			SparkleParticleData data = SparkleParticleData.sparkle(0.45F + 0.2F * (float) Math.random(), (float) Math.random(), (float) Math.random(), (float) Math.random(), 6);
			world.method_8406(data, pos.method_10263() + Math.random(), pos.method_10264() + Math.random(), pos.method_10260() + Math.random(), 0, 0, 0);
		}
	}

	@Override
	public class_1767 method_10622() {
		return class_1767.field_7952;
	}

	@SoftImplement("IForgeBlock")
	public float[] getBeaconColorMultiplier(class_2680 state, class_4538 level, class_2338 pos, class_2338 beaconPos) {
		// Note: pos and beaconPos are not accurate when called from Fabric code
		int rgb = class_3532.method_15369(((class_1937) level).method_8510() * 5 % 360 / 360F, 0.4F, 0.9F);
		float[] ret = new float[3];
		ret[0] = ((rgb >> 16) & 0xFF) / 255.0F;
		ret[1] = ((rgb >> 8) & 0xFF) / 255.0F;
		ret[2] = (rgb & 0xFF) / 255.0F;
		return ret;
	}
}
