/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.client.integration.jei.crafting;

import com.google.common.collect.ImmutableList;

import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.ingredient.ICraftingGridHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.category.extensions.vanilla.crafting.ICraftingCategoryExtension;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import vazkii.botania.common.crafting.recipe.TerraShattererTippingRecipe;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.item.equipment.tool.terrasteel.TerraShattererItem;

import java.util.Collections;
import java.util.List;

public class TerraShattererTippingRecipeWrapper implements ICraftingCategoryExtension {
	private final List<List<class_1799>> inputs;
	private final class_1799 output;
	private final class_2960 name;

	public TerraShattererTippingRecipeWrapper(TerraShattererTippingRecipe recipe) {
		inputs = ImmutableList.of(ImmutableList.of(new class_1799(BotaniaItems.terraPick)), ImmutableList.of(new class_1799(BotaniaItems.elementiumPick)));
		output = new class_1799(BotaniaItems.terraPick);
		TerraShattererItem.setTipped(output);

		this.name = recipe.method_8114();
	}

	@Override
	public void setRecipe(@NotNull IRecipeLayoutBuilder builder, @NotNull ICraftingGridHelper helper, @NotNull IFocusGroup focuses) {
		helper.createAndSetInputs(builder, VanillaTypes.ITEM_STACK, inputs, 0, 0);
		helper.createAndSetOutputs(builder, VanillaTypes.ITEM_STACK, Collections.singletonList(output));
	}

	@Nullable
	@Override
	public class_2960 getRegistryName() {
		return name;
	}
}
