/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.client.model;

import com.google.common.base.Preconditions;
import net.minecraft.class_1087;
import net.minecraft.class_1091;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3665;
import net.minecraft.class_4590;
import net.minecraft.class_5819;
import net.minecraft.class_638;
import net.minecraft.class_777;
import net.minecraft.class_7775;
import net.minecraft.class_7923;
import net.minecraft.class_806;
import net.minecraft.client.resources.model.*;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

import vazkii.botania.common.helper.VecHelper;
import vazkii.botania.common.item.ManaBlasterItem;

import java.util.*;

public class ManaBlasterBakedModel extends DelegatedModel {
	// key is (lens, hasClip). If no lens, the Item is null
	private final Map<Pair<class_1792, Boolean>, class_1087> models;

	private ManaBlasterBakedModel(Map<Pair<class_1792, Boolean>, class_1087> models) {
		super(models.get(Pair.of(null, false)));
		this.models = models;
	}

	public static ManaBlasterBakedModel create(class_7775 baker,
			class_2960 gunNoClip, class_2960 gunClip,
			class_3665 state) {
		class_1087 gunNoClipModel = Preconditions.checkNotNull(baker.method_45873(gunNoClip, state));
		class_1087 gunClipModel = Preconditions.checkNotNull(baker.method_45873(gunClip, state));
		Map<Pair<class_1792, Boolean>, class_1087> models = new HashMap<>();
		models.put(Pair.of(null, false), gunNoClipModel);
		models.put(Pair.of(null, true), gunClipModel);

		for (var item : class_7923.field_41178) {
			var lens = item.method_7854();
			if (ManaBlasterItem.isValidLens(lens)) {
				models.put(Pair.of(item, false), new ManaBlasterBakedModel.CompositeBakedModel(baker, lens, gunNoClipModel));
				models.put(Pair.of(item, true), new ManaBlasterBakedModel.CompositeBakedModel(baker, lens, gunClipModel));
			}
		}
		return new ManaBlasterBakedModel(models);
	}

	private final class_806 itemHandler = new class_806() {
		@NotNull
		@Override
		public class_1087 method_3495(class_1087 model, class_1799 stack, @Nullable class_638 worldIn, @Nullable class_1309 entityIn, int seed) {
			boolean clip = ManaBlasterItem.hasClip(stack);

			class_1799 lens = ManaBlasterItem.getLens(stack);
			Pair<class_1792, Boolean> key = Pair.of(lens.method_7960() ? null : lens.method_7909(), clip);

			return ManaBlasterBakedModel.this.models.getOrDefault(key,
					class_310.method_1551().method_1554().method_4744());
		}
	};

	@NotNull
	@Override
	public class_806 method_4710() {
		return itemHandler;
	}

	@NotNull
	@Override
	public List<class_777> method_4707(@Nullable class_2680 state, @Nullable class_2350 side, @NotNull class_5819 rand) {
		return originalModel.method_4707(state, side, rand);
	}

	private static class CompositeBakedModel extends DelegatedModel {
		private final class_1087 lensModel;

		CompositeBakedModel(class_7775 baker, class_1799 lens, class_1087 gun) {
			super(gun);
			class_2960 lensId = class_7923.field_41178.method_10221(lens.method_7909());
			class_3665 transform = new class_3665() {
				@Override
				public class_4590 method_3509() {
					return new class_4590(new Vector3f(-0.4F, 0.2F, 0.0F), VecHelper.rotateY(90), new Vector3f(0.625F, 0.625F, 0.625F), null);
				}
			};
			this.lensModel = baker.method_45873(new class_1091(lensId, "inventory"), transform);
		}

		@NotNull
		@Override
		public List<class_777> method_4707(class_2680 state, class_2350 face, @NotNull class_5819 rand) {
			List<class_777> gunQuads = this.originalModel.method_4707(state, face, rand);
			List<class_777> lensQuads = this.lensModel.method_4707(state, face, rand);
			List<class_777> ret = new ArrayList<>(gunQuads.size() + lensQuads.size());
			ret.addAll(gunQuads);
			ret.addAll(lensQuads);
			return ret;
		}
	}

}
