/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.item.rod;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.client.fx.WispParticleData;
import vazkii.botania.common.annotations.SoftImplement;
import vazkii.botania.common.entity.ThrownItemEntity;
import vazkii.botania.common.helper.ItemNBTHelper;
import vazkii.botania.common.helper.MathHelper;
import vazkii.botania.common.helper.VecHelper;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.lib.BotaniaTags;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2743;
import net.minecraft.class_3222;
import net.minecraft.class_3966;
import net.minecraft.class_6862;

public class ShadedMesaRodItem extends class_1792 {
	private static final class_6862<class_1299<?>> BLACKLIST = BotaniaTags.Entities.SHADED_MESA_BLACKLIST;
	private static final float RANGE = 3F;
	private static final int COST = 2;
	private static final Predicate<class_1297> CAN_TARGET = e -> !e.method_7325() && e.method_5805() && !e.method_5864().method_20210(BLACKLIST);

	private static final String TAG_TICKS_TILL_EXPIRE = "ticksTillExpire";
	private static final String TAG_TICKS_COOLDOWN = "ticksCooldown";
	private static final String TAG_TARGET = "target";
	private static final String TAG_DIST = "dist";

	public ShadedMesaRodItem(class_1793 props) {
		super(props);
	}

	@SoftImplement("IForgeItem")
	public boolean shouldCauseReequipAnimation(class_1799 oldStack, class_1799 newStack, boolean slotChanged) {
		return reequipAnimation(oldStack, newStack);
	}

	@SoftImplement("FabricItem")
	public boolean allowNbtUpdateAnimation(class_1657 player, class_1268 hand, class_1799 oldStack, class_1799 newStack) {
		return reequipAnimation(oldStack, newStack);
	}

	private boolean reequipAnimation(class_1799 before, class_1799 after) {
		return !after.method_31574(this);
	}

	@Override
	public void method_7888(class_1799 stack, class_1937 world, class_1297 entity, int slot, boolean held) {
		if (!(entity instanceof class_1657)) {
			return;
		}

		int ticksTillExpire = ItemNBTHelper.getInt(stack, TAG_TICKS_TILL_EXPIRE, 0);
		int ticksCooldown = ItemNBTHelper.getInt(stack, TAG_TICKS_COOLDOWN, 0);

		if (ticksTillExpire == 0) {
			ItemNBTHelper.setInt(stack, TAG_TARGET, -1);
			ItemNBTHelper.setDouble(stack, TAG_DIST, -1);
		}

		if (ticksCooldown > 0) {
			ticksCooldown--;
		}

		if (ticksTillExpire >= 0) {
			ticksTillExpire--;
		}
		ItemNBTHelper.setInt(stack, TAG_TICKS_TILL_EXPIRE, ticksTillExpire);
		ItemNBTHelper.setInt(stack, TAG_TICKS_COOLDOWN, ticksCooldown);
	}

	@SoftImplement("IForgeItem")
	public boolean onEntitySwing(class_1799 stack, class_1309 entity) {
		if (entity instanceof class_1657 player) {
			leftClick(player);
		}
		return false;
	}

	// Prevent damaging the entity you just held with the rod
	@SoftImplement("IForgeItem")
	public boolean onLeftClickEntity(class_1799 stack, class_1657 player, class_1297 entity) {
		return ItemNBTHelper.getInt(stack, TAG_TICKS_TILL_EXPIRE, 0) != 0;
	}

	// Calls hook above on Fabric
	public static class_1269 onAttack(class_1657 player, class_1937 level, class_1268 hand, class_1297 target, @Nullable class_3966 hit) {
		class_1799 stack = player.method_5998(hand);
		if (stack.method_31574(BotaniaItems.gravityRod) && ((ShadedMesaRodItem) stack.method_7909()).onLeftClickEntity(stack, player, target)) {
			return class_1269.field_5814;
		}
		return class_1269.field_5811;
	}

	@NotNull
	@Override
	public class_1271<class_1799> method_7836(class_1937 world, class_1657 player, @NotNull class_1268 hand) {
		class_1799 stack = player.method_5998(hand);
		int targetID = ItemNBTHelper.getInt(stack, TAG_TARGET, -1);
		int ticksCooldown = ItemNBTHelper.getInt(stack, TAG_TICKS_COOLDOWN, 0);
		double length = ItemNBTHelper.getDouble(stack, TAG_DIST, -1);

		if (ticksCooldown == 0) {
			class_1297 target = null;
			if (targetID != -1 && player.method_37908().method_8469(targetID) != null) {
				class_1297 taritem = player.method_37908().method_8469(targetID);

				boolean found = false;
				class_243 targetVec = VecHelper.fromEntityCenter(player);
				List<class_1297> entities = new ArrayList<>();
				int distance = 1;
				while (entities.size() == 0 && distance < 25) {
					targetVec = targetVec.method_1019(player.method_5720().method_1021(distance)).method_1031(0, 0.5, 0);
					entities = player.method_37908().method_8333(player, VecHelper.boxForRange(targetVec, RANGE), CAN_TARGET);
					distance++;
					if (entities.contains(taritem)) {
						found = true;
					}
				}

				if (found) {
					target = player.method_37908().method_8469(targetID);
				}
			}

			if (target == null) {
				class_243 targetVec = VecHelper.fromEntityCenter(player);
				List<class_1297> entities = new ArrayList<>();
				int distance = 1;
				while (entities.size() == 0 && distance < 25) {
					targetVec = targetVec.method_1019(player.method_5720().method_1021(distance)).method_1031(0, 0.5, 0);
					entities = player.method_37908().method_8333(player, VecHelper.boxForRange(targetVec, RANGE), CAN_TARGET);
					distance++;
				}

				if (entities.size() > 0) {
					target = entities.get(0);
					length = 5.5D;
					if (target instanceof class_1542) {
						length = 2.0D;
					}
				}
			}

			if (target != null) {
				if (target.method_5864().method_20210(BLACKLIST)) {
					return class_1271.method_22431(stack);
				}

				if (ManaItemHandler.instance().requestManaExactForTool(stack, player, COST, true)) {
					boolean targetIsPlayer = target instanceof class_1657;

					if (target instanceof class_1542 item) {
						item.method_6982(5);
					}

					if (target instanceof class_1309 living) {
						living.field_6017 = 0.0F;
						if (living.method_6112(class_1294.field_5909) == null) {
							living.method_6092(new class_1293(class_1294.field_5909,
									targetIsPlayer ? 20 : 2, targetIsPlayer ? 1 : 3, true, true));
						}
					}

					class_243 target3 = VecHelper.fromEntityCenter(player)
							.method_1019(player.method_5720().method_1021(length)).method_1031(0, 0.5, 0);
					if (target instanceof class_1542) {
						target3 = target3.method_1031(0, 0.25, 0);
					}

					for (int i = 0; i < 4; i++) {
						float r = 0.5F + (float) Math.random() * 0.5F;
						float b = 0.5F + (float) Math.random() * 0.5F;
						float s = 0.2F + (float) Math.random() * 0.1F;
						float m = 0.1F;
						float xm = ((float) Math.random() - 0.5F) * m;
						float ym = ((float) Math.random() - 0.5F) * m;
						float zm = ((float) Math.random() - 0.5F) * m;
						WispParticleData data = WispParticleData.wisp(s, r, 0F, b);
						world.method_8406(data, target.method_23317() + target.method_17681() / 2, target.method_23318() + target.method_17682() / 2, target.method_23321() + target.method_17681() / 2, xm, ym, zm);
					}

					MathHelper.setEntityMotionFromVector(target, target3, 0.3333333F);
					if (targetIsPlayer && target instanceof class_3222 p) {
						p.field_13987.method_14364(new class_2743(p));
					}

					ItemNBTHelper.setInt(stack, TAG_TARGET, target.method_5628());
					ItemNBTHelper.setDouble(stack, TAG_DIST, length);
				}

				ItemNBTHelper.setInt(stack, TAG_TICKS_TILL_EXPIRE, 5);
				return class_1271.method_22428(stack);
			}
		}
		return class_1271.method_22430(stack);
	}

	private static void leftClick(class_1657 player) {
		class_1799 stack = player.method_6047();
		if (!stack.method_7960() && stack.method_31574(BotaniaItems.gravityRod)) {
			int targetID = ItemNBTHelper.getInt(stack, TAG_TARGET, -1);
			ItemNBTHelper.getDouble(stack, TAG_DIST, -1);

			if (targetID != -1 && player.method_37908().method_8469(targetID) != null) {
				class_1297 target = player.method_37908().method_8469(targetID);

				boolean found = false;
				class_243 vec = VecHelper.fromEntityCenter(player);
				List<class_1297> entities = new ArrayList<>();
				int distance = 1;
				while (entities.size() == 0 && distance < 25) {
					vec = vec.method_1019(player.method_5720().method_1021(distance)).method_1031(0, 0.5, 0);
					entities = player.method_37908().method_8333(player, new class_238(vec.method_1023(RANGE, RANGE, RANGE), vec.method_1031(RANGE, RANGE, RANGE)), CAN_TARGET);
					distance++;
					if (entities.contains(target)) {
						found = true;
					}
				}

				if (found) {
					ItemNBTHelper.setInt(stack, TAG_TARGET, -1);
					ItemNBTHelper.setDouble(stack, TAG_DIST, -1);
					class_243 moveVector = player.method_5720().method_1029();
					if (target instanceof class_1542 item) {
						item.method_6982(20);
						float mot = ManaItemHandler.instance().hasProficiency(player, stack) ? 2.25F : 1.5F;
						item.method_18800(moveVector.field_1352 * mot, moveVector.field_1351, moveVector.field_1350 * mot);
						if (!player.method_37908().field_9236) {
							ThrownItemEntity thrown = new ThrownItemEntity(item.method_37908(), item.method_23317(), item.method_23318(), item.method_23321(), item);
							item.method_37908().method_8649(thrown);
						}
						item.method_31472();
					} else {
						if (target instanceof class_1309 living) {
							living.method_6015(player);
							living.method_29505(player);
						}
						target.method_18799(moveVector.method_18805(3, 1.5, 3));
					}
					ItemNBTHelper.setInt(stack, TAG_TICKS_COOLDOWN, 10);
				}
			}
		}
	}
}
