/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block.block_entity;

import org.jetbrains.annotations.Nullable;

import vazkii.botania.api.block.WandHUD;
import vazkii.botania.api.brew.BrewContainer;
import vazkii.botania.api.brew.BrewItem;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.api.mana.ManaReceiver;
import vazkii.botania.api.recipe.BotanicalBreweryRecipe;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.client.fx.SparkleParticleData;
import vazkii.botania.client.fx.WispParticleData;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.brew.BotaniaBrews;
import vazkii.botania.common.crafting.BotaniaRecipeTypes;
import vazkii.botania.common.handler.BotaniaSounds;
import vazkii.botania.common.helper.EntityHelper;

import java.util.List;
import java.util.Optional;
import net.minecraft.class_1268;
import net.minecraft.class_1277;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3419;

public class BreweryBlockEntity extends SimpleInventoryBlockEntity implements ManaReceiver {
	private static final String TAG_MANA = "mana";
	private static final int CRAFT_EFFECT_EVENT = 0;

	public BotanicalBreweryRecipe recipe;
	private int mana = 0;
	private int manaLastTick = 0;
	public int signal = 0;

	public BreweryBlockEntity(class_2338 pos, class_2680 state) {
		super(BotaniaBlockEntities.BREWERY, pos, state);
	}

	public boolean addItem(@Nullable class_1657 player, class_1799 stack, @Nullable class_1268 hand) {
		if (recipe != null || stack.method_7960() || stack.method_7909() instanceof BrewItem brew && brew.getBrew(stack) != null && brew.getBrew(stack) != BotaniaBrews.fallbackBrew || getItemHandler().method_5438(0).method_7960() != stack.method_7909() instanceof BrewContainer) {
			return false;
		}

		boolean did = false;

		for (int i = 0; i < inventorySize(); i++) {
			if (getItemHandler().method_5438(i).method_7960()) {
				did = true;
				class_1799 stackToAdd = stack.method_46651(1);
				getItemHandler().method_5447(i, stackToAdd);

				if (player == null || !player.method_31549().field_7477) {
					stack.method_7934(1);
					if (stack.method_7960() && player != null) {
						player.method_6122(hand, class_1799.field_8037);
					}
				}

				break;
			}
		}

		if (did) {
			VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this);
			findRecipe();
		}

		return true;
	}

	private void findRecipe() {
		Optional<BotanicalBreweryRecipe> maybeRecipe = field_11863.method_8433().method_8132(BotaniaRecipeTypes.BREW_TYPE, getItemHandler(), field_11863);
		maybeRecipe.ifPresent(recipeBrew -> {
			this.recipe = recipeBrew;
			field_11863.method_8501(field_11867, BotaniaBlocks.brewery.method_9564().method_11657(class_2741.field_12484, true));
		});
	}

	public static void commonTick(class_1937 level, class_2338 worldPosition, class_2680 state, BreweryBlockEntity self) {
		if (self.mana > 0 && self.recipe == null) {
			self.findRecipe();

			if (self.recipe == null) {
				self.mana = 0;
			}
		}

		// Update every tick.
		self.receiveMana(0);

		if (!level.field_9236 && self.recipe == null) {
			List<class_1542> items = level.method_18467(class_1542.class, new class_238(worldPosition.method_10263(), worldPosition.method_10264(), worldPosition.method_10260(), worldPosition.method_10263() + 1, worldPosition.method_10264() + 1, worldPosition.method_10260() + 1));
			for (class_1542 item : items) {
				if (item.method_5805() && !item.method_6983().method_7960()) {
					class_1799 stack = item.method_6983();
					if (self.addItem(null, stack, null)) {
						EntityHelper.syncItem(item);
					}
				}
			}
		}

		if (self.recipe != null) {
			if (!self.recipe.method_8115(self.getItemHandler(), level)) {
				self.recipe = null;
				level.method_8501(worldPosition, BotaniaBlocks.brewery.method_9564());
			}

			if (self.recipe != null) {
				if (self.mana != self.manaLastTick) {
					int color = self.recipe.getBrew().getColor(self.getItemHandler().method_5438(0));
					float r = (color >> 16 & 0xFF) / 255F;
					float g = (color >> 8 & 0xFF) / 255F;
					float b = (color & 0xFF) / 255F;
					for (int i = 0; i < 5; i++) {
						WispParticleData data1 = WispParticleData.wisp(0.1F + (float) Math.random() * 0.05F, r, g, b);
						level.method_8406(data1, worldPosition.method_10263() + 0.7 - Math.random() * 0.4, worldPosition.method_10264() + 0.9 - Math.random() * 0.2, worldPosition.method_10260() + 0.7 - Math.random() * 0.4, 0.03F - (float) Math.random() * 0.06F, 0.03F + (float) Math.random() * 0.015F, 0.03F - (float) Math.random() * 0.06F);
						for (int j = 0; j < 2; j++) {
							WispParticleData data = WispParticleData.wisp(0.1F + (float) Math.random() * 0.2F, 0.2F, 0.2F, 0.2F);
							level.method_8406(data, worldPosition.method_10263() + 0.7 - Math.random() * 0.4, worldPosition.method_10264() + 0.9 - Math.random() * 0.2, worldPosition.method_10260() + 0.7 - Math.random() * 0.4, 0.03F - (float) Math.random() * 0.06F, 0.03F + (float) Math.random() * 0.015F, 0.03F - (float) Math.random() * 0.06F);
						}
					}
				}

				if (self.mana >= self.getManaCost() && !level.field_9236) {
					int mana = self.getManaCost();
					self.receiveMana(-mana);

					class_1799 output = self.recipe.getOutput(self.getItemHandler().method_5438(0));
					class_1542 outputItem = new class_1542(level, worldPosition.method_10263() + 0.5, worldPosition.method_10264() + 1.5, worldPosition.method_10260() + 0.5, output);
					level.method_8649(outputItem);
					level.method_8427(worldPosition, BotaniaBlocks.brewery, CRAFT_EFFECT_EVENT, self.recipe.getBrew().getColor(output));

					for (int i = 0; i < self.inventorySize(); i++) {
						self.getItemHandler().method_5447(i, class_1799.field_8037);
					}
				}
			}
		}

		int newSignal = 0;
		if (self.recipe != null) {
			newSignal++;
		}

		if (newSignal != self.signal) {
			self.signal = newSignal;
			level.method_8455(worldPosition, state.method_26204());
		}

		self.manaLastTick = self.mana;
	}

	@Override
	public boolean method_11004(int event, int param) {
		if (event == CRAFT_EFFECT_EVENT) {
			if (field_11863.field_9236) {
				for (int i = 0; i < 25; i++) {
					float r = (param >> 16 & 0xFF) / 255F;
					float g = (param >> 8 & 0xFF) / 255F;
					float b = (param & 0xFF) / 255F;
					SparkleParticleData data1 = SparkleParticleData.sparkle((float) Math.random() * 2F + 0.5F, r, g, b, 10);
					field_11863.method_8406(data1, field_11867.method_10263() + 0.5 + Math.random() * 0.4 - 0.2, field_11867.method_10264() + 1, field_11867.method_10260() + 0.5 + Math.random() * 0.4 - 0.2, 0, 0, 0);
					for (int j = 0; j < 2; j++) {
						WispParticleData data = WispParticleData.wisp(0.1F + (float) Math.random() * 0.2F, 0.2F, 0.2F, 0.2F);
						field_11863.method_8406(data, field_11867.method_10263() + 0.7 - Math.random() * 0.4, field_11867.method_10264() + 0.9 - Math.random() * 0.2, field_11867.method_10260() + 0.7 - Math.random() * 0.4, 0.05F - (float) Math.random() * 0.1F, 0.05F + (float) Math.random() * 0.03F, 0.05F - (float) Math.random() * 0.1F);
					}
				}
				field_11863.method_8486(field_11867.method_10263(), field_11867.method_10264(), field_11867.method_10260(), BotaniaSounds.potionCreate, class_3419.field_15245, 1F, 1.5F + (float) Math.random() * 0.25F, false);
			}
			return true;
		} else {
			return super.method_11004(event, param);
		}
	}

	public int getManaCost() {
		class_1799 stack = getItemHandler().method_5438(0);
		if (recipe == null || stack.method_7960() || !(stack.method_7909() instanceof BrewContainer container)) {
			return 0;
		}
		return container.getManaCost(recipe.getBrew(), stack);
	}

	@Override
	public void writePacketNBT(class_2487 tag) {
		super.writePacketNBT(tag);

		tag.method_10569(TAG_MANA, mana);
	}

	@Override
	public void readPacketNBT(class_2487 tag) {
		super.readPacketNBT(tag);

		mana = tag.method_10550(TAG_MANA);
	}

	@Override
	protected class_1277 createItemHandler() {
		return new class_1277(7) {
			@Override
			public int method_5444() {
				return 1;
			}
		};
	}

	@Override
	public class_1937 getManaReceiverLevel() {
		return method_10997();
	}

	@Override
	public class_2338 getManaReceiverPos() {
		return method_11016();
	}

	@Override
	public int getCurrentMana() {
		return mana;
	}

	@Override
	public boolean isFull() {
		return mana >= getManaCost();
	}

	@Override
	public void receiveMana(int mana) {
		this.mana = Math.min(this.mana + mana, getManaCost());
	}

	@Override
	public boolean canReceiveManaFromBursts() {
		return !isFull();
	}

	public static class WandHud implements WandHUD {
		private final BreweryBlockEntity brewery;

		public WandHud(BreweryBlockEntity brewery) {
			this.brewery = brewery;
		}

		@Override
		public void renderHUD(class_332 gui, class_310 mc) {
			int manaToGet = brewery.getManaCost();
			if (manaToGet > 0) {
				if (brewery.recipe == null) {
					return;
				}

				int x = mc.method_22683().method_4486() / 2 + 8;
				int y = mc.method_22683().method_4502() / 2 - 12;

				RenderHelper.renderHUDBox(gui, x, y, x + 24, y + 24);
				RenderHelper.renderProgressPie(gui, x + 4, y + 4, (float) brewery.mana / (float) manaToGet,
						brewery.recipe.getOutput(brewery.getItemHandler().method_5438(0)));
			}
		}
	}

}
