package vazkii.botania.data;

import com.google.gson.JsonElement;

import net.minecraft.advancements.critereon.*;
import net.minecraft.class_109;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1299;
import net.minecraft.class_159;
import net.minecraft.class_173;
import net.minecraft.class_1740;
import net.minecraft.class_1741;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_1844;
import net.minecraft.class_2040;
import net.minecraft.class_2048;
import net.minecraft.class_2050;
import net.minecraft.class_2073;
import net.minecraft.class_2105;
import net.minecraft.class_215;
import net.minecraft.class_219;
import net.minecraft.class_2405;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2509;
import net.minecraft.class_2960;
import net.minecraft.class_3735;
import net.minecraft.class_3852;
import net.minecraft.class_44;
import net.minecraft.class_47;
import net.minecraft.class_52;
import net.minecraft.class_5270;
import net.minecraft.class_5321;
import net.minecraft.class_55;
import net.minecraft.class_5662;
import net.minecraft.class_6880;
import net.minecraft.class_6903;
import net.minecraft.class_7225;
import net.minecraft.class_7403;
import net.minecraft.class_77;
import net.minecraft.class_7784;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_8053;
import net.minecraft.class_8054;
import net.minecraft.class_8055;
import net.minecraft.class_8056;
import net.minecraft.class_8057;
import net.minecraft.class_83;
import net.minecraft.class_8551;
import net.minecraft.world.item.*;
import net.minecraft.world.item.armortrim.*;
import org.apache.commons.lang3.function.TriFunction;
import org.jetbrains.annotations.NotNull;

import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.common.loot.BotaniaLootTables;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;

public class LooniumEquipmentLootProvider implements class_2405 {
	public static final int COLOR_ENDERMAN_BODY = 0x1d1d21; // (black)
	public static final int COLOR_TIDE_LEATHER = 0x169c9c; // (cyan)
	public static final int COLOR_EVOKER_COAT = 0x323639; // (black + gray)
	public static final int COLOR_VINDICATOR_BOOTS = 0x323639; // (black + gray(
	public static final int COLOR_VINDICATOR_JACKET = 0x474f52; // (gray)
	public static final int COLOR_VINDICATOR_LEGWEAR = 0x168c8c; // (black + 7 cyan)
	public static final int COLOR_ILLUSIONER_COAT = 0x3b7bc2; // (blue + light blue)

	private final class_7784.class_7489 pathProvider;
	private final CompletableFuture<class_7225.class_7874> registryLookupFuture;

	public LooniumEquipmentLootProvider(class_7784 packOutput, CompletableFuture<class_7225.class_7874> registryLookupFuture) {
		// NOTE: equipment loot tables become a vanilla feature in future versions
		this.pathProvider = packOutput.method_45973(class_7784.class_7490.field_39367, "loot_tables");
		this.registryLookupFuture = registryLookupFuture;
	}

	@NotNull
	@Override
	public CompletableFuture<?> method_10319(@NotNull class_7403 cache) {
		return registryLookupFuture.thenCompose(registryLookup -> this.run(cache, registryLookup));
	}

	private CompletableFuture<?> run(@NotNull class_7403 cache, class_7225.class_7874 registryLookup) {
		class_7225.class_7226<class_8056> patternRegistry = registryLookup.method_46762(class_7924.field_42082);
		class_7225.class_7226<class_8054> materialRegistry = registryLookup.method_46762(class_7924.field_42083);
		BiFunction<class_5321<class_8056>, class_5321<class_8054>, class_8053> trimFactory =
				(pattern, material) -> getTrim(patternRegistry, materialRegistry, pattern, material);
		BiConsumer<class_8053, class_2487> trimSetter = (trim, tag) -> addTrimToTag(registryLookup, trim).accept(tag);
		BiFunction<class_8053, class_1792[], class_52.class_53> randomizedSetFactory =
				(trim, armorItems) -> createArmorSet(addTrimToTag(registryLookup, trim), true, armorItems);
		TriFunction<class_8053, Integer, class_1792[], class_52.class_53> randomizedDyedSetFactory =
				(trim, color, armorItems) -> createArmorSet(addTrimToTag(registryLookup, trim)
						.andThen(addDyedColorToTag(color)), true, armorItems);
		TriFunction<class_8053, Integer, class_1792[], class_52.class_53> fixedDyedSetFactory =
				(trim, color, armorItems) -> createArmorSet(addTrimToTag(registryLookup, trim)
						.andThen(addDyedColorToTag(color)), false, armorItems);

		Map<class_1741, class_1792[]> armorItems = Map.of(
				class_1740.field_7897, new class_1792[] {
						class_1802.field_8267, class_1802.field_8577, class_1802.field_8570, class_1802.field_8370
				},
				class_1740.field_7887, new class_1792[] {
						class_1802.field_8283, class_1802.field_8873, class_1802.field_8218, class_1802.field_8313
				},
				class_1740.field_7892, new class_1792[] {
						class_1802.field_8743, class_1802.field_8523, class_1802.field_8396, class_1802.field_8660
				},
				class_1740.field_7895, new class_1792[] {
						class_1802.field_8862, class_1802.field_8678, class_1802.field_8416, class_1802.field_8753
				},
				class_1740.field_7889, new class_1792[] {
						class_1802.field_8805, class_1802.field_8058, class_1802.field_8348, class_1802.field_8285
				},
				class_1740.field_21977, new class_1792[] {
						class_1802.field_22027, class_1802.field_22028, class_1802.field_22029, class_1802.field_22030
				}
		);

		Map<class_2960, class_52.class_53> tables = new HashMap<>();

		defineWeaponEquipmentTables(tables);
		defineAncientCityEquipmentTables(tables, armorItems, trimFactory, randomizedSetFactory);
		defineBastionRemnantEquipmentTables(tables, armorItems, trimFactory, randomizedSetFactory);
		defineDesertPyramidEquipmentTables(tables, armorItems, trimFactory, randomizedSetFactory);
		defineEndCityEquipmentTables(tables, armorItems, trimFactory, randomizedSetFactory);
		defineJungleTempleEquipmentTables(tables, armorItems, trimFactory, randomizedSetFactory);
		defineFortressEquipmentTables(tables, armorItems, trimFactory, randomizedSetFactory);
		defineOceanMonumentEquipmentTables(tables, armorItems, trimFactory, randomizedSetFactory, randomizedDyedSetFactory);
		definePillagerOutpostEquipmentTables(tables, armorItems, trimFactory, randomizedSetFactory);
		defineRuinedPortalEquipmentTables(tables);
		defineShipwreckEquipmentTables(tables, armorItems, trimFactory, randomizedSetFactory);
		defineStrongholdEquipmentTables(tables, armorItems, trimFactory, randomizedSetFactory, trimSetter);
		defineTrailRuinsEquipmentTables(tables, armorItems, trimFactory, randomizedSetFactory);
		defineWoodlandMansionEquipmentTables(tables, trimFactory, fixedDyedSetFactory, trimSetter);

		// TODO: we should be using LootTableSubProvider implementations instead of three individual loot providers
		var output = new ArrayList<CompletableFuture<?>>(tables.size());
		for (Map.Entry<class_2960, class_52.class_53> e : tables.entrySet()) {
			Path path = pathProvider.method_44107(e.getKey());
			class_52.class_53 builder = e.getValue();
			// TODO 1.21: use LootContextParamSets.EQUIPMENT instead
			class_52 lootTable = builder.method_334(class_173.field_20762).method_338();
			JsonElement jsonTree = class_5270.method_27862().create().toJsonTree(lootTable);
			output.add(class_2405.method_10320(cache, jsonTree, path));
		}
		return CompletableFuture.allOf(output.toArray(CompletableFuture<?>[]::new));
	}

	private void defineWeaponEquipmentTables(Map<class_2960, class_52.class_53> tables) {
		tables.put(BotaniaLootTables.LOONIUM_WEAPON_AXE,
				class_52.method_324().method_336(class_55.method_347()
						.method_353(class_109.method_489()
								.method_524(class_219.method_932(0.3f)))
						.method_351(class_77.method_411(class_1802.field_8475))
				// no need to add diamond axe, it's the same base damage, but actually less enchantable
				)
		);
		tables.put(BotaniaLootTables.LOONIUM_WEAPON_AXE_GOLD,
				class_52.method_324().method_336(class_55.method_347()
						.method_353(class_109.method_489()
								.method_524(class_219.method_932(0.3f)))
						.method_351(class_77.method_411(class_1802.field_8825))
				)
		);
		tables.put(BotaniaLootTables.LOONIUM_WEAPON_BOW,
				class_52.method_324().method_336(class_55.method_347()
						.method_353(class_109.method_489()
								.method_524(class_219.method_932(0.3f)))
						.method_351(class_77.method_411(class_1802.field_8102))
				)
		);
		tables.put(BotaniaLootTables.LOONIUM_WEAPON_CROSSBOW,
				class_52.method_324().method_336(class_55.method_347()
						.method_353(class_109.method_489())
						.method_351(class_77.method_411(class_1802.field_8399))
				)
		);
		tables.put(BotaniaLootTables.LOONIUM_WEAPON_SWORD,
				class_52.method_324().method_336(class_55.method_347()
						.method_353(class_109.method_489()
								.method_524(class_219.method_932(0.3f)))
						.method_351(class_77.method_411(class_1802.field_8371).method_437(4))
						.method_351(class_77.method_411(class_1802.field_8802))
				)
		);
		tables.put(BotaniaLootTables.LOONIUM_WEAPON_SWORD_GOLD,
				class_52.method_324().method_336(class_55.method_347()
						.method_353(class_109.method_489()
								.method_524(class_219.method_932(0.3f)))
						.method_351(class_77.method_411(class_1802.field_8845))
				)
		);
		tables.put(BotaniaLootTables.LOONIUM_WEAPON_TRIDENT,
				class_52.method_324().method_336(class_55.method_347()
						// no useful enchantments for mob usage
						.method_351(class_77.method_411(class_1802.field_8547))
				)
		);
		tables.put(BotaniaLootTables.LOONIUM_WEAPON_BY_PROFESSION,
				class_52.method_324().method_336(class_55.method_347()
						.method_351(class_83.method_428(BotaniaLootTables.LOONIUM_WEAPON_AXE)
								.method_438(class_109.method_489()
										.method_524(class_219.method_932(0.3f)))
								.method_421(class_215.method_917(class_47.class_50.field_935,
										class_2048.class_2049.method_8916().method_8915(
												new class_2105(getProfessionNbt(class_3852.field_17053))))))
						.method_351(class_77.method_411(class_1802.field_8609)
								.method_421(class_215.method_917(class_47.class_50.field_935,
										class_2048.class_2049.method_8916().method_8915(
												new class_2105(getProfessionNbt(class_3852.field_17056))))))
						.method_351(class_77.method_411(class_1802.field_8378)
								.method_421(class_215.method_917(class_47.class_50.field_935,
										class_2048.class_2049.method_8916().method_8915(
												new class_2105(getProfessionNbt(class_3852.field_17057))))))
						.method_351(class_77.method_411(class_1802.field_8403)
								.method_421(class_215.method_917(class_47.class_50.field_935,
										class_2048.class_2049.method_8916().method_8915(
												new class_2105(getProfessionNbt(class_3852.field_17064))))))
						.method_351(class_83.method_428(BotaniaLootTables.LOONIUM_WEAPON_SWORD)
								.method_438(class_109.method_489()
										.method_524(class_219.method_932(0.3f)))
								.method_421(class_215.method_917(class_47.class_50.field_935,
										class_2048.class_2049.method_8916().method_8915(
												new class_2105(getProfessionNbt(class_3852.field_17065))))))
				)
		);
		tables.put(BotaniaLootTables.LOONIUM_WEAPON_FOR_PIGLIN,
				class_52.method_324().method_336(class_55.method_347()
						.method_353(class_109.method_489()
								.method_524(class_219.method_932(0.3f)))
						.method_351(class_83.method_428(BotaniaLootTables.LOONIUM_WEAPON_SWORD_GOLD))
						.method_351(class_83.method_428(BotaniaLootTables.LOONIUM_WEAPON_CROSSBOW))
				)
		);
		tables.put(BotaniaLootTables.LOONIUM_WEAPON_FOR_WITHER_SKELETON,
				class_52.method_324().method_336(class_55.method_347().method_352(class_5662.method_32462(-1, 1))
						.method_353(class_109.method_489())
						.method_351(class_77.method_411(class_1802.field_8528))
						.method_351(class_77.method_411(class_1802.field_8102))
				)
		);
	}

	private class_2487 getProfessionNbt(class_3852 profession) {
		var villagerDataTag = new class_2487();
		class_7923.field_41195.method_39673().encodeStart(class_2509.field_11560, profession).resultOrPartial(
				BotaniaAPI.LOGGER::error).ifPresent(data -> villagerDataTag.method_10566("profession", data));
		var tag = new class_2487();
		tag.method_10566("VillagerData", villagerDataTag);
		return tag;
	}

	private void defineAncientCityEquipmentTables(Map<class_2960, class_52.class_53> tables,
			Map<class_1741, class_1792[]> armorItems,
			BiFunction<class_5321<class_8056>, class_5321<class_8054>, class_8053> trimFactory,
			BiFunction<class_8053, class_1792[], class_52.class_53> randomizedSetFactory) {

		class_8053 trimWardQuartz = trimFactory.apply(class_8057.field_42020, class_8055.field_42004);
		class_8053 trimSilenceCopper = trimFactory.apply(class_8057.field_43223, class_8055.field_42008);
		tables.put(BotaniaLootTables.LOONIUM_ARMORSET_WARD_IRON,
				randomizedSetFactory.apply(trimWardQuartz, armorItems.get(class_1740.field_7892)));
		tables.put(BotaniaLootTables.LOONIUM_ARMORSET_WARD_DIAMOND,
				randomizedSetFactory.apply(trimWardQuartz, armorItems.get(class_1740.field_7889)));
		tables.put(BotaniaLootTables.LOONIUM_ARMORSET_SILENCE_GOLD,
				randomizedSetFactory.apply(trimSilenceCopper, armorItems.get(class_1740.field_7895)));
		tables.put(BotaniaLootTables.LOONIUM_ARMORSET_SILENCE_DIAMOND,
				randomizedSetFactory.apply(trimSilenceCopper, armorItems.get(class_1740.field_7889)));

		class_2487 darknessEffectTag = getPotionEffectTag(class_1294.field_38092, 200);
		tables.put(BotaniaLootTables.LOONIUM_ARMOR_ANCIENT_CITY,
				class_52.method_324().method_336(class_55.method_347()
						.method_351(class_83.method_428(BotaniaLootTables.LOONIUM_ARMORSET_WARD_IRON).method_437(11))
						.method_351(class_83.method_428(BotaniaLootTables.LOONIUM_ARMORSET_WARD_DIAMOND).method_437(5))
						.method_351(class_83.method_428(BotaniaLootTables.LOONIUM_ARMORSET_SILENCE_GOLD).method_437(3))
						.method_351(class_83.method_428(BotaniaLootTables.LOONIUM_ARMORSET_SILENCE_DIAMOND).method_437(1))
				).method_336(class_55.method_347()
						// Note: Slowness from Strays stacks with tipped arrow effects, so just checking for bow here
						.method_356(class_215.method_917(class_47.class_50.field_935,
								class_2048.class_2049.method_8916().method_16227(class_3735.class_5278.method_27965()
										.method_35195(class_2073.class_2074.method_8973().method_8977(class_1802.field_8102).method_8976()).method_27967())))
						.method_356(class_219.method_932(0.9f))
						.method_351(class_77.method_411(class_1802.field_8087).method_438(class_159.method_677(darknessEffectTag)))
				)
		);
		tables.put(BotaniaLootTables.LOONIUM_DROWNED_ANCIENT_CITY,
				class_52.method_324()
						.method_336(class_55.method_347().method_351(class_83.method_428(BotaniaLootTables.LOONIUM_WEAPON_TRIDENT)))
						.method_336(class_55.method_347().method_351(class_83.method_428(BotaniaLootTables.LOONIUM_ARMOR_ANCIENT_CITY)))
		);
		tables.put(BotaniaLootTables.LOONIUM_SKELETON_ANCIENT_CITY,
				class_52.method_324()
						.method_336(class_55.method_347().method_351(class_83.method_428(BotaniaLootTables.LOONIUM_WEAPON_BOW)))
						.method_336(class_55.method_347().method_351(class_83.method_428(BotaniaLootTables.LOONIUM_ARMOR_ANCIENT_CITY)))
		);
		tables.put(BotaniaLootTables.LOONIUM_ZOMBIE_ANCIENT_CITY,
				class_52.method_324()
						.method_336(class_55.method_347().method_351(class_83.method_428(BotaniaLootTables.LOONIUM_WEAPON_SWORD)))
						.method_336(class_55.method_347().method_351(class_83.method_428(BotaniaLootTables.LOONIUM_ARMOR_ANCIENT_CITY)))
		);
	}

	private void defineBastionRemnantEquipmentTables(Map<class_2960, class_52.class_53> tables,
			Map<class_1741, class_1792[]> armorItems,
			BiFunction<class_5321<class_8056>, class_5321<class_8054>, class_8053> trimFactory,
			BiFunction<class_8053, class_1792[], class_52.class_53> randomizedSetFactory) {

		class_8053 trimSnoutGold = trimFactory.apply(class_8057.field_42024, class_8055.field_42009);
		class_8053 trimSnoutNetherite = trimFactory.apply(class_8057.field_42024, class_8055.field_42006);
		tables.put(BotaniaLootTables.LOONIUM_ARMORSET_SNOUT_GOLD,
				randomizedSetFactory.apply(trimSnoutNetherite, armorItems.get(class_1740.field_7895)));
		tables.put(BotaniaLootTables.LOONIUM_ARMORSET_SNOUT_NETHERITE,
				randomizedSetFactory.apply(trimSnoutGold, armorItems.get(class_1740.field_21977)));

		tables.put(BotaniaLootTables.LOONIUM_ARMOR_BASTION_REMNANT,
				class_52.method_324().method_336(class_55.method_347()
						.method_351(class_83.method_428(BotaniaLootTables.LOONIUM_ARMORSET_SNOUT_GOLD).method_437(4))
						.method_351(class_83.method_428(BotaniaLootTables.LOONIUM_ARMORSET_SNOUT_NETHERITE).method_437(1))
				)
		);
		tables.put(BotaniaLootTables.LOONIUM_PIGLIN_BASTION_REMNANT,
				class_52.method_324()
						.method_336(class_55.method_347().method_351(class_83.method_428(BotaniaLootTables.LOONIUM_WEAPON_FOR_PIGLIN)))
						.method_336(class_55.method_347().method_351(class_83.method_428(BotaniaLootTables.LOONIUM_ARMOR_BASTION_REMNANT)))
		);
	}

	private void defineDesertPyramidEquipmentTables(Map<class_2960, class_52.class_53> tables,
			Map<class_1741, class_1792[]> armorItems,
			BiFunction<class_5321<class_8056>, class_5321<class_8054>, class_8053> trimFactory,
			BiFunction<class_8053, class_1792[], class_52.class_53> randomizedSetFactory) {

		class_8053 trimDuneRedstone = trimFactory.apply(class_8057.field_42017, class_8055.field_42007);
		tables.put(BotaniaLootTables.LOONIUM_ARMORSET_DUNE_IRON,
				randomizedSetFactory.apply(trimDuneRedstone, armorItems.get(class_1740.field_7892)));
		tables.put(BotaniaLootTables.LOONIUM_ARMORSET_DUNE_GOLD,
				randomizedSetFactory.apply(trimDuneRedstone, armorItems.get(class_1740.field_7895)));
		tables.put(BotaniaLootTables.LOONIUM_ARMORSET_DUNE_DIAMOND,
				randomizedSetFactory.apply(trimDuneRedstone, armorItems.get(class_1740.field_7889)));

		tables.put(BotaniaLootTables.LOONIUM_ARMOR_DESERT_PYRAMID,
				class_52.method_324().method_336(class_55.method_347()
						.method_351(class_83.method_428(BotaniaLootTables.LOONIUM_ARMORSET_DUNE_IRON).method_437(5))
						.method_351(class_83.method_428(BotaniaLootTables.LOONIUM_ARMORSET_DUNE_GOLD).method_437(2))
						.method_351(class_83.method_428(BotaniaLootTables.LOONIUM_ARMORSET_DUNE_DIAMOND).method_437(1))
				)
		);
		tables.put(BotaniaLootTables.LOONIUM_SKELETON_DESERT_PYRAMID,
				class_52.method_324()
						.method_336(class_55.method_347().method_351(class_83.method_428(BotaniaLootTables.LOONIUM_WEAPON_BOW)))
						.method_336(class_55.method_347().method_351(class_83.method_428(BotaniaLootTables.LOONIUM_ARMOR_DESERT_PYRAMID)))
		);
		tables.put(BotaniaLootTables.LOONIUM_ZOMBIE_DESERT_PYRAMID,
				class_52.method_324()
						.method_336(class_55.method_347().method_351(class_83.method_428(BotaniaLootTables.LOONIUM_WEAPON_SWORD)))
						.method_336(class_55.method_347().method_351(class_83.method_428(BotaniaLootTables.LOONIUM_ARMOR_DESERT_PYRAMID)))
		);
	}

	private void defineEndCityEquipmentTables(Map<class_2960, class_52.class_53> tables,
			Map<class_1741, class_1792[]> armorItems,
			BiFunction<class_5321<class_8056>, class_5321<class_8054>, class_8053> trimFactory,
			BiFunction<class_8053, class_1792[], class_52.class_53> randomizedSetFactory) {

		class_8053 trimSpireAmethyst = trimFactory.apply(class_8057.field_42026, class_8055.field_42013);
		tables.put(BotaniaLootTables.LOONIUM_ARMORSET_SPIRE_IRON,
				randomizedSetFactory.apply(trimSpireAmethyst, armorItems.get(class_1740.field_7892)));
		tables.put(BotaniaLootTables.LOONIUM_ARMORSET_SPIRE_GOLD,
				randomizedSetFactory.apply(trimSpireAmethyst, armorItems.get(class_1740.field_7895)));
		tables.put(BotaniaLootTables.LOONIUM_ARMORSET_SPIRE_DIAMOND,
				randomizedSetFactory.apply(trimSpireAmethyst, armorItems.get(class_1740.field_7889)));

		class_2487 levitationEffectTag = getPotionEffectTag(class_1294.field_5902, 200);
		tables.put(BotaniaLootTables.LOONIUM_ARMOR_END_CITY,
				class_52.method_324().method_336(class_55.method_347()
						.method_353(class_109.method_489()
								.method_524(class_219.method_932(0.3f)))
						.method_351(class_83.method_428(BotaniaLootTables.LOONIUM_ARMORSET_SPIRE_IRON).method_437(3))
						.method_351(class_83.method_428(BotaniaLootTables.LOONIUM_ARMORSET_SPIRE_GOLD).method_437(2))
						.method_351(class_83.method_428(BotaniaLootTables.LOONIUM_ARMORSET_SPIRE_DIAMOND).method_437(2))
				).method_336(class_55.method_347()
						.method_356(class_215.method_917(class_47.class_50.field_935,
								class_2048.class_2049.method_8916()
										.method_8917(class_2050.method_8929(class_1299.field_6137))))
						.method_356(class_219.method_932(0.9f))
						.method_351(class_77.method_411(class_1802.field_8087)
								.method_438(class_159.method_677(levitationEffectTag)))
				)
		);
		tables.put(BotaniaLootTables.LOONIUM_SKELETON_END_CITY,
				class_52.method_324()
						.method_336(class_55.method_347().method_351(class_83.method_428(BotaniaLootTables.LOONIUM_WEAPON_BOW)))
						.method_336(class_55.method_347().method_351(class_83.method_428(BotaniaLootTables.LOONIUM_ARMOR_END_CITY)))
		);
		tables.put(BotaniaLootTables.LOONIUM_ZOMBIE_END_CITY,
				class_52.method_324()
						.method_336(class_55.method_347().method_351(class_83.method_428(BotaniaLootTables.LOONIUM_WEAPON_SWORD)))
						.method_336(class_55.method_347().method_351(class_83.method_428(BotaniaLootTables.LOONIUM_ARMOR_END_CITY)))
		);
	}

	private static class_2487 getPotionEffectTag(class_1291 mobEffect, int duration) {
		// [VanillaCopy] based on PotionUtils::setCustomEffects
		class_2499 effects = new class_2499();
		effects.add(new class_1293(mobEffect, duration).method_5582(new class_2487()));

		class_2487 effectTag = new class_2487();
		effectTag.method_10566(class_1844.field_30943, effects);
		effectTag.method_10569(class_1844.field_30944, mobEffect.method_5556());

		return effectTag;
	}

	private void defineFortressEquipmentTables(Map<class_2960, class_52.class_53> tables,
			Map<class_1741, class_1792[]> armorItems,
			BiFunction<class_5321<class_8056>, class_5321<class_8054>, class_8053> trimFactory,
			BiFunction<class_8053, class_1792[], class_52.class_53> randomizedSetFactory) {

		class_8053 trimRibIron = trimFactory.apply(class_8057.field_42025, class_8055.field_42005);
		tables.put(BotaniaLootTables.LOONIUM_ARMORSET_RIB_IRON,
				randomizedSetFactory.apply(trimRibIron, armorItems.get(class_1740.field_7892)));
		tables.put(BotaniaLootTables.LOONIUM_ARMORSET_RIB_GOLD,
				randomizedSetFactory.apply(trimRibIron, armorItems.get(class_1740.field_7895)));
		tables.put(BotaniaLootTables.LOONIUM_ARMORSET_RIB_DIAMOND,
				randomizedSetFactory.apply(trimRibIron, armorItems.get(class_1740.field_7889)));

		tables.put(BotaniaLootTables.LOONIUM_ARMOR_FORTRESS,
				class_52.method_324().method_336(class_55.method_347()
						.method_351(class_83.method_428(BotaniaLootTables.LOONIUM_ARMORSET_RIB_IRON).method_437(7))
						.method_351(class_83.method_428(BotaniaLootTables.LOONIUM_ARMORSET_RIB_GOLD).method_437(3))
						.method_351(class_83.method_428(BotaniaLootTables.LOONIUM_ARMORSET_RIB_DIAMOND).method_437(2))
				)
		);
		tables.put(BotaniaLootTables.LOONIUM_SKELETON_FORTRESS,
				class_52.method_324()
						.method_336(class_55.method_347().method_351(class_83.method_428(BotaniaLootTables.LOONIUM_WEAPON_FOR_WITHER_SKELETON)))
						.method_336(class_55.method_347().method_351(class_83.method_428(BotaniaLootTables.LOONIUM_ARMOR_FORTRESS)))
		);
		tables.put(BotaniaLootTables.LOONIUM_ZOMBIE_FORTRESS,
				class_52.method_324()
						.method_336(class_55.method_347().method_351(class_83.method_428(BotaniaLootTables.LOONIUM_WEAPON_SWORD_GOLD)))
						.method_336(class_55.method_347().method_351(class_83.method_428(BotaniaLootTables.LOONIUM_ARMOR_FORTRESS)))
		);
	}

	private void defineJungleTempleEquipmentTables(Map<class_2960, class_52.class_53> tables,
			Map<class_1741, class_1792[]> armorItems,
			BiFunction<class_5321<class_8056>, class_5321<class_8054>, class_8053> trimFactory,
			BiFunction<class_8053, class_1792[], class_52.class_53> randomizedSetFactory) {

		class_8053 trimWildEmerald = trimFactory.apply(class_8057.field_42019, class_8055.field_42010);
		tables.put(BotaniaLootTables.LOONIUM_ARMORSET_WILD_CHAIN,
				randomizedSetFactory.apply(trimWildEmerald, armorItems.get(class_1740.field_7887)));
		tables.put(BotaniaLootTables.LOONIUM_ARMORSET_WILD_GOLD,
				randomizedSetFactory.apply(trimWildEmerald, armorItems.get(class_1740.field_7895)));
		tables.put(BotaniaLootTables.LOONIUM_ARMORSET_WILD_DIAMOND,
				randomizedSetFactory.apply(trimWildEmerald, armorItems.get(class_1740.field_7889)));

		tables.put(BotaniaLootTables.LOONIUM_ARMOR_JUNGLE_TEMPLE,
				class_52.method_324().method_336(class_55.method_347()
						.method_351(class_83.method_428(BotaniaLootTables.LOONIUM_ARMORSET_WILD_CHAIN).method_437(4))
						.method_351(class_83.method_428(BotaniaLootTables.LOONIUM_ARMORSET_WILD_GOLD).method_437(2))
						.method_351(class_83.method_428(BotaniaLootTables.LOONIUM_ARMORSET_WILD_DIAMOND).method_437(1))
				)
		);
		tables.put(BotaniaLootTables.LOONIUM_DROWNED_JUNGLE_TEMPLE,
				class_52.method_324()
						.method_336(class_55.method_347().method_351(class_83.method_428(BotaniaLootTables.LOONIUM_WEAPON_TRIDENT)))
						.method_336(class_55.method_347().method_351(class_83.method_428(BotaniaLootTables.LOONIUM_ARMOR_JUNGLE_TEMPLE)))
		);
		tables.put(BotaniaLootTables.LOONIUM_SKELETON_JUNGLE_TEMPLE,
				class_52.method_324()
						.method_336(class_55.method_347().method_351(class_83.method_428(BotaniaLootTables.LOONIUM_WEAPON_BOW)))
						.method_336(class_55.method_347().method_351(class_83.method_428(BotaniaLootTables.LOONIUM_ARMOR_JUNGLE_TEMPLE)))
		);
		tables.put(BotaniaLootTables.LOONIUM_ZOMBIE_JUNGLE_TEMPLE,
				class_52.method_324()
						.method_336(class_55.method_347().method_351(class_83.method_428(BotaniaLootTables.LOONIUM_WEAPON_SWORD)))
						.method_336(class_55.method_347().method_351(class_83.method_428(BotaniaLootTables.LOONIUM_ARMOR_JUNGLE_TEMPLE)))
		);
	}

	private void defineOceanMonumentEquipmentTables(Map<class_2960, class_52.class_53> tables,
			Map<class_1741, class_1792[]> armorItems,
			BiFunction<class_5321<class_8056>, class_5321<class_8054>, class_8053> trimFactory,
			BiFunction<class_8053, class_1792[], class_52.class_53> randomizedSetFactory,
			TriFunction<class_8053, Integer, class_1792[], class_52.class_53> randomizedDyedSetFactory) {

		tables.put(BotaniaLootTables.LOONIUM_ARMORSET_TIDE_LEATHER, randomizedDyedSetFactory.apply(
				trimFactory.apply(class_8057.field_42023, class_8055.field_42008), COLOR_TIDE_LEATHER, armorItems.get(class_1740.field_7897)));
		tables.put(BotaniaLootTables.LOONIUM_ARMORSET_TIDE_GOLD, randomizedSetFactory.apply(
				trimFactory.apply(class_8057.field_42023, class_8055.field_42011), armorItems.get(class_1740.field_7895)));
		tables.put(BotaniaLootTables.LOONIUM_ARMORSET_TIDE_DIAMOND, randomizedSetFactory.apply(
				trimFactory.apply(class_8057.field_42023, class_8055.field_42009), armorItems.get(class_1740.field_7889)));

		tables.put(BotaniaLootTables.LOONIUM_ARMOR_MONUMENT,
				class_52.method_324().method_336(class_55.method_347()
						.method_351(class_83.method_428(BotaniaLootTables.LOONIUM_ARMORSET_TIDE_LEATHER).method_437(2))
						.method_351(class_83.method_428(BotaniaLootTables.LOONIUM_ARMORSET_TIDE_GOLD).method_437(3))
						.method_351(class_83.method_428(BotaniaLootTables.LOONIUM_ARMORSET_TIDE_DIAMOND).method_437(1))
				)
		);
		tables.put(BotaniaLootTables.LOONIUM_DROWNED_MONUMENT,
				class_52.method_324()
						.method_336(class_55.method_347().method_351(class_83.method_428(BotaniaLootTables.LOONIUM_WEAPON_TRIDENT)))
						.method_336(class_55.method_347().method_351(class_83.method_428(BotaniaLootTables.LOONIUM_ARMOR_MONUMENT)))
		);
		tables.put(BotaniaLootTables.LOONIUM_SKELETON_MONUMENT,
				class_52.method_324()
						.method_336(class_55.method_347().method_351(class_83.method_428(BotaniaLootTables.LOONIUM_WEAPON_BOW)))
						.method_336(class_55.method_347().method_351(class_83.method_428(BotaniaLootTables.LOONIUM_ARMOR_MONUMENT)))
		);
		tables.put(BotaniaLootTables.LOONIUM_ZOMBIE_MONUMENT,
				class_52.method_324()
						.method_336(class_55.method_347().method_351(class_83.method_428(BotaniaLootTables.LOONIUM_WEAPON_SWORD)))
						.method_336(class_55.method_347().method_351(class_83.method_428(BotaniaLootTables.LOONIUM_ARMOR_MONUMENT)))
		);
	}

	private void definePillagerOutpostEquipmentTables(Map<class_2960, class_52.class_53> tables,
			Map<class_1741, class_1792[]> armorItems,
			BiFunction<class_5321<class_8056>, class_5321<class_8054>, class_8053> trimFactory,
			BiFunction<class_8053, class_1792[], class_52.class_53> randomizedSetFactory) {

		class_8053 trimSentryEmerald = trimFactory.apply(class_8057.field_42016, class_8055.field_42010);
		tables.put(BotaniaLootTables.LOONIUM_ARMORSET_SENTRY_CHAIN,
				randomizedSetFactory.apply(trimSentryEmerald, armorItems.get(class_1740.field_7887)));
		tables.put(BotaniaLootTables.LOONIUM_ARMORSET_SENTRY_IRON,
				randomizedSetFactory.apply(trimSentryEmerald, armorItems.get(class_1740.field_7892)));
		tables.put(BotaniaLootTables.LOONIUM_ARMORSET_SENTRY_DIAMOND,
				randomizedSetFactory.apply(trimSentryEmerald, armorItems.get(class_1740.field_7889)));

		tables.put(BotaniaLootTables.LOONIUM_ARMOR_OUTPOST,
				class_52.method_324().method_336(class_55.method_347()
						.method_351(class_83.method_428(BotaniaLootTables.LOONIUM_ARMORSET_SENTRY_CHAIN).method_437(5))
						.method_351(class_83.method_428(BotaniaLootTables.LOONIUM_ARMORSET_SENTRY_IRON).method_437(3))
						.method_351(class_83.method_428(BotaniaLootTables.LOONIUM_ARMORSET_SENTRY_DIAMOND).method_437(1))
				)
		);
		tables.put(BotaniaLootTables.LOONIUM_SKELETON_OUTPOST,
				class_52.method_324()
						.method_336(class_55.method_347().method_351(class_83.method_428(BotaniaLootTables.LOONIUM_WEAPON_BOW)))
						.method_336(class_55.method_347().method_351(class_83.method_428(BotaniaLootTables.LOONIUM_ARMOR_OUTPOST)))
		);
		tables.put(BotaniaLootTables.LOONIUM_ZOMBIE_OUTPOST,
				class_52.method_324()
						.method_336(class_55.method_347().method_351(class_83.method_428(BotaniaLootTables.LOONIUM_WEAPON_SWORD)))
						.method_336(class_55.method_347().method_351(class_83.method_428(BotaniaLootTables.LOONIUM_ARMOR_OUTPOST)))
		);
	}

	private void defineRuinedPortalEquipmentTables(Map<class_2960, class_52.class_53> tables) {

		tables.put(BotaniaLootTables.LOONIUM_ARMOR_PORTAL,
				class_52.method_324()
						.method_336(class_55.method_347().method_351(
								class_77.method_411(class_1802.field_8862)).method_352(class_5662.method_32462(0, 1)))
						.method_336(class_55.method_347().method_351(
								class_77.method_411(class_1802.field_8678)).method_352(class_5662.method_32462(0, 1)))
						.method_336(class_55.method_347().method_351(
								class_77.method_411(class_1802.field_8416)).method_352(class_5662.method_32462(0, 1)))
						.method_336(class_55.method_347().method_351(
								class_77.method_411(class_1802.field_8753)).method_352(class_5662.method_32462(0, 1)))
		);

		tables.put(BotaniaLootTables.LOONIUM_DROWNED_PORTAL,
				class_52.method_324()
						.method_336(class_55.method_347().method_351(
								class_83.method_428(BotaniaLootTables.LOONIUM_ARMOR_PORTAL)))
						.method_336(class_55.method_347().method_351(
								class_83.method_428(BotaniaLootTables.LOONIUM_WEAPON_TRIDENT)))
		);
		tables.put(BotaniaLootTables.LOONIUM_PIGLIN_PORTAL,
				class_52.method_324()
						.method_336(class_55.method_347().method_351(
								class_83.method_428(BotaniaLootTables.LOONIUM_ARMOR_PORTAL)))
						.method_336(class_55.method_347().method_351(
								class_83.method_428(BotaniaLootTables.LOONIUM_WEAPON_FOR_PIGLIN)))
		);
		tables.put(BotaniaLootTables.LOONIUM_SKELETON_PORTAL,
				class_52.method_324()
						.method_336(class_55.method_347().method_351(
								class_83.method_428(BotaniaLootTables.LOONIUM_ARMOR_PORTAL)))
						.method_336(class_55.method_347().method_351(
								class_83.method_428(BotaniaLootTables.LOONIUM_WEAPON_BOW)))
		);
		tables.put(BotaniaLootTables.LOONIUM_ZOMBIE_PORTAL,
				class_52.method_324()
						.method_336(class_55.method_347().method_351(
								class_83.method_428(BotaniaLootTables.LOONIUM_ARMOR_PORTAL)))
						.method_336(class_55.method_347().method_351(
								class_83.method_428(BotaniaLootTables.LOONIUM_WEAPON_SWORD_GOLD)))
		);
	}

	private void defineShipwreckEquipmentTables(Map<class_2960, class_52.class_53> tables,
			Map<class_1741, class_1792[]> armorItems,
			BiFunction<class_5321<class_8056>, class_5321<class_8054>, class_8053> trimFactory,
			BiFunction<class_8053, class_1792[], class_52.class_53> randomizedSetFactory) {

		class_8053 trimCoastEmerald = trimFactory.apply(class_8057.field_42018, class_8055.field_42010);
		tables.put(BotaniaLootTables.LOONIUM_ARMORSET_COAST_CHAIN,
				randomizedSetFactory.apply(trimCoastEmerald, armorItems.get(class_1740.field_7887)));
		tables.put(BotaniaLootTables.LOONIUM_ARMORSET_COAST_IRON,
				randomizedSetFactory.apply(trimCoastEmerald, armorItems.get(class_1740.field_7892)));
		tables.put(BotaniaLootTables.LOONIUM_ARMORSET_COAST_DIAMOND,
				randomizedSetFactory.apply(trimCoastEmerald, armorItems.get(class_1740.field_7889)));

		tables.put(BotaniaLootTables.LOONIUM_ARMOR_SHIPWRECK,
				class_52.method_324().method_336(class_55.method_347()
						.method_351(class_83.method_428(BotaniaLootTables.LOONIUM_ARMORSET_COAST_CHAIN).method_437(4))
						.method_351(class_83.method_428(BotaniaLootTables.LOONIUM_ARMORSET_COAST_IRON).method_437(4))
						.method_351(class_83.method_428(BotaniaLootTables.LOONIUM_ARMORSET_COAST_DIAMOND).method_437(1))
				)
		);
		tables.put(BotaniaLootTables.LOONIUM_DROWNED_SHIPWRECK,
				class_52.method_324()
						.method_336(class_55.method_347().method_351(class_83.method_428(BotaniaLootTables.LOONIUM_WEAPON_TRIDENT)))
						.method_336(class_55.method_347().method_351(class_83.method_428(BotaniaLootTables.LOONIUM_ARMOR_SHIPWRECK)))
		);
		tables.put(BotaniaLootTables.LOONIUM_SKELETON_SHIPWRECK,
				class_52.method_324()
						.method_336(class_55.method_347().method_351(class_83.method_428(BotaniaLootTables.LOONIUM_WEAPON_BOW)))
						.method_336(class_55.method_347().method_351(class_83.method_428(BotaniaLootTables.LOONIUM_ARMOR_SHIPWRECK)))
		);
		tables.put(BotaniaLootTables.LOONIUM_ZOMBIE_SHIPWRECK,
				class_52.method_324()
						.method_336(class_55.method_347().method_351(class_83.method_428(BotaniaLootTables.LOONIUM_WEAPON_SWORD)))
						.method_336(class_55.method_347().method_351(class_83.method_428(BotaniaLootTables.LOONIUM_ARMOR_SHIPWRECK)))
		);
	}

	private void defineStrongholdEquipmentTables(Map<class_2960, class_52.class_53> tables,
			Map<class_1741, class_1792[]> armorItems,
			BiFunction<class_5321<class_8056>, class_5321<class_8054>, class_8053> trimFactory,
			BiFunction<class_8053, class_1792[], class_52.class_53> randomizedSetFactory,
			BiConsumer<class_8053, class_2487> trimSetter) {

		class_8053 trimEyeRedstone = trimFactory.apply(class_8057.field_42021, class_8055.field_42007);
		class_8053 trimEyeLapis = trimFactory.apply(class_8057.field_42021, class_8055.field_42012);
		tables.put(BotaniaLootTables.LOONIUM_ARMORSET_EYE_IRON,
				randomizedSetFactory.apply(trimEyeLapis, armorItems.get(class_1740.field_7892)));
		tables.put(BotaniaLootTables.LOONIUM_ARMORSET_EYE_GOLD,
				randomizedSetFactory.apply(trimEyeRedstone, armorItems.get(class_1740.field_7895)));
		tables.put(BotaniaLootTables.LOONIUM_ARMORSET_EYE_DIAMOND,
				randomizedSetFactory.apply(trimEyeLapis, armorItems.get(class_1740.field_7889)));

		// Enderman cosplay
		var endermanHeadTag = new class_2487();
		trimSetter.accept(trimFactory.apply(class_8057.field_42021, class_8055.field_42013), endermanHeadTag);
		addDyedColorToTag(COLOR_ENDERMAN_BODY).accept(endermanHeadTag);
		var endermanBodyTag = new class_2487();
		addDyedColorToTag(COLOR_ENDERMAN_BODY).accept(endermanBodyTag);
		tables.put(BotaniaLootTables.LOONIUM_ARMORSET_COSTUME_ENDERMAN, class_52.method_324()
				.method_336(class_55.method_347().method_351(class_77.method_411(class_1802.field_8267)
						.method_438(class_159.method_677(endermanHeadTag))))
				.method_336(class_55.method_347().method_351(class_77.method_411(class_1802.field_8577)
						.method_438(class_159.method_677(endermanBodyTag))))
				.method_336(class_55.method_347().method_351(class_77.method_411(class_1802.field_8570)
						.method_438(class_159.method_677(endermanBodyTag))))
				.method_336(class_55.method_347().method_351(class_77.method_411(class_1802.field_8370)
						.method_438(class_159.method_677(endermanBodyTag))))
		);

		tables.put(BotaniaLootTables.LOONIUM_ARMOR_STRONGHOLD,
				class_52.method_324().method_336(class_55.method_347()
						.method_351(class_83.method_428(BotaniaLootTables.LOONIUM_ARMORSET_EYE_IRON).method_437(5))
						.method_351(class_83.method_428(BotaniaLootTables.LOONIUM_ARMORSET_EYE_GOLD).method_437(3))
						.method_351(class_83.method_428(BotaniaLootTables.LOONIUM_ARMORSET_EYE_DIAMOND).method_437(2))
						.method_351(class_83.method_428(BotaniaLootTables.LOONIUM_ARMORSET_COSTUME_ENDERMAN).method_437(1))
				)
		);
		tables.put(BotaniaLootTables.LOONIUM_DROWNED_STRONGHOLD,
				class_52.method_324()
						.method_336(class_55.method_347().method_351(class_83.method_428(BotaniaLootTables.LOONIUM_WEAPON_TRIDENT)))
						.method_336(class_55.method_347().method_351(class_83.method_428(BotaniaLootTables.LOONIUM_ARMOR_STRONGHOLD)))
		);
		tables.put(BotaniaLootTables.LOONIUM_SKELETON_STRONGHOLD,
				class_52.method_324()
						.method_336(class_55.method_347().method_351(class_83.method_428(BotaniaLootTables.LOONIUM_WEAPON_BOW)))
						.method_336(class_55.method_347().method_351(class_83.method_428(BotaniaLootTables.LOONIUM_ARMOR_STRONGHOLD)))
		);
		tables.put(BotaniaLootTables.LOONIUM_ZOMBIE_STRONGHOLD,
				class_52.method_324()
						.method_336(class_55.method_347().method_351(class_83.method_428(BotaniaLootTables.LOONIUM_WEAPON_SWORD)))
						.method_336(class_55.method_347().method_351(class_83.method_428(BotaniaLootTables.LOONIUM_ARMOR_STRONGHOLD)))
		);
	}

	private void defineTrailRuinsEquipmentTables(Map<class_2960, class_52.class_53> tables,
			Map<class_1741, class_1792[]> armorItems,
			BiFunction<class_5321<class_8056>, class_5321<class_8054>, class_8053> trimFactory,
			BiFunction<class_8053, class_1792[], class_52.class_53> randomizedSetFactory) {

		class_8053 trimHostEmerald = trimFactory.apply(class_8057.field_43225, class_8055.field_42010);
		tables.put(BotaniaLootTables.LOONIUM_ARMORSET_HOST_CHAIN,
				randomizedSetFactory.apply(trimHostEmerald, armorItems.get(class_1740.field_7887)));
		tables.put(BotaniaLootTables.LOONIUM_ARMORSET_HOST_IRON,
				randomizedSetFactory.apply(trimHostEmerald, armorItems.get(class_1740.field_7892)));

		class_8053 trimRaiserAmethyst = trimFactory.apply(class_8057.field_43224, class_8055.field_42013);
		tables.put(BotaniaLootTables.LOONIUM_ARMORSET_RAISER_IRON,
				randomizedSetFactory.apply(trimRaiserAmethyst, armorItems.get(class_1740.field_7892)));
		tables.put(BotaniaLootTables.LOONIUM_ARMORSET_RAISER_GOLD,
				randomizedSetFactory.apply(trimRaiserAmethyst, armorItems.get(class_1740.field_7895)));

		class_8053 trimShaperLapis = trimFactory.apply(class_8057.field_43222, class_8055.field_42012);
		tables.put(BotaniaLootTables.LOONIUM_ARMORSET_SHAPER_GOLD,
				randomizedSetFactory.apply(trimShaperLapis, armorItems.get(class_1740.field_7895)));
		tables.put(BotaniaLootTables.LOONIUM_ARMORSET_SHAPER_DIAMOND,
				randomizedSetFactory.apply(trimShaperLapis, armorItems.get(class_1740.field_7889)));

		class_8053 trimWayfinderRedstone = trimFactory.apply(class_8057.field_43221, class_8055.field_42007);
		tables.put(BotaniaLootTables.LOONIUM_ARMORSET_WAYFINDER_CHAIN,
				randomizedSetFactory.apply(trimWayfinderRedstone, armorItems.get(class_1740.field_7887)));
		tables.put(BotaniaLootTables.LOONIUM_ARMORSET_WAYFINDER_DIAMOND,
				randomizedSetFactory.apply(trimWayfinderRedstone, armorItems.get(class_1740.field_7889)));

		tables.put(BotaniaLootTables.LOONIUM_ARMOR_TRAIL_RUINS,
				class_52.method_324().method_336(class_55.method_347()
						.method_351(class_83.method_428(BotaniaLootTables.LOONIUM_ARMORSET_HOST_CHAIN).method_437(7))
						.method_351(class_83.method_428(BotaniaLootTables.LOONIUM_ARMORSET_WAYFINDER_CHAIN).method_437(7))
						.method_351(class_83.method_428(BotaniaLootTables.LOONIUM_ARMORSET_RAISER_IRON).method_437(8))
						.method_351(class_83.method_428(BotaniaLootTables.LOONIUM_ARMORSET_HOST_IRON).method_437(8))
						.method_351(class_83.method_428(BotaniaLootTables.LOONIUM_ARMORSET_RAISER_GOLD).method_437(3))
						.method_351(class_83.method_428(BotaniaLootTables.LOONIUM_ARMORSET_SHAPER_GOLD).method_437(3))
						.method_351(class_83.method_428(BotaniaLootTables.LOONIUM_ARMORSET_SHAPER_DIAMOND).method_437(2))
						.method_351(class_83.method_428(BotaniaLootTables.LOONIUM_ARMORSET_WAYFINDER_DIAMOND).method_437(2))
				)
		);
		tables.put(BotaniaLootTables.LOONIUM_DROWNED_TRAIL_RUINS,
				class_52.method_324()
						.method_336(class_55.method_347().method_351(class_83.method_428(BotaniaLootTables.LOONIUM_WEAPON_TRIDENT)))
						.method_336(class_55.method_347().method_351(class_83.method_428(BotaniaLootTables.LOONIUM_ARMOR_TRAIL_RUINS)))
		);
		tables.put(BotaniaLootTables.LOONIUM_SKELETON_TRAIL_RUINS,
				class_52.method_324()
						.method_336(class_55.method_347().method_351(class_83.method_428(BotaniaLootTables.LOONIUM_WEAPON_BOW)))
						.method_336(class_55.method_347().method_351(class_83.method_428(BotaniaLootTables.LOONIUM_ARMOR_TRAIL_RUINS)))
		);
		tables.put(BotaniaLootTables.LOONIUM_ZOMBIE_TRAIL_RUINS,
				class_52.method_324()
						.method_336(class_55.method_347().method_351(class_83.method_428(BotaniaLootTables.LOONIUM_WEAPON_SWORD)))
						.method_336(class_55.method_347().method_351(class_83.method_428(BotaniaLootTables.LOONIUM_ARMOR_TRAIL_RUINS)))
		);
	}

	private void defineWoodlandMansionEquipmentTables(Map<class_2960, class_52.class_53> tables,
			BiFunction<class_5321<class_8056>, class_5321<class_8054>, class_8053> trimFactory,
			TriFunction<class_8053, Integer, class_1792[], class_52.class_53> fixedDyedSetFactory,
			BiConsumer<class_8053, class_2487> trimSetter) {

		// Evoker cosplay, with higher likelihood of holding a totem
		tables.put(BotaniaLootTables.LOONIUM_ARMORSET_COSTUME_EVOKER, fixedDyedSetFactory.apply(
				trimFactory.apply(class_8057.field_42022, class_8055.field_42009), COLOR_EVOKER_COAT,
				new class_1792[] { class_1802.field_8577, class_1802.field_8570 })
				.method_336(class_55.method_347()
						.method_356(class_219.method_932(0.2f))
						.method_351(class_77.method_411(class_1802.field_8288))
				)
		);

		// Vindicator cosplay, usually including axe (even for ranged mobs)
		var vindicatorChestTag = new class_2487();
		trimSetter.accept(trimFactory.apply(class_8057.field_42022, class_8055.field_42006), vindicatorChestTag);
		addDyedColorToTag(COLOR_VINDICATOR_JACKET).accept(vindicatorChestTag);
		var vindicatorLegsTag = new class_2487();
		addDyedColorToTag(COLOR_VINDICATOR_LEGWEAR).accept(vindicatorLegsTag);
		var vindicatorBootsTag = new class_2487();
		addDyedColorToTag(COLOR_VINDICATOR_BOOTS).accept(vindicatorBootsTag);
		tables.put(BotaniaLootTables.LOONIUM_ARMORSET_COSTUME_VINDICATOR, class_52.method_324()
				.method_336(class_55.method_347().method_351(class_77.method_411(class_1802.field_8577)
						.method_438(class_159.method_677(vindicatorChestTag))))
				.method_336(class_55.method_347().method_351(class_77.method_411(class_1802.field_8570)
						.method_438(class_159.method_677(vindicatorLegsTag))))
				.method_336(class_55.method_347().method_351(class_77.method_411(class_1802.field_8370)
						.method_438(class_159.method_677(vindicatorBootsTag))))
				.method_336(class_55.method_347()
						.method_356(class_219.method_932(0.9f))
						.method_351(class_77.method_411(class_1802.field_8475)
								.method_438(class_109.method_489()
										.method_524(class_219.method_932(0.3f)))))
		);

		// Illusioner cosplay, including bow and blindness arrows, even for mobs that don't know how to use bows
		class_2487 blindnessEffectTag = getPotionEffectTag(class_1294.field_5919, 100);
		tables.put(BotaniaLootTables.LOONIUM_ARMORSET_COSTUME_ILLUSIONER, fixedDyedSetFactory.apply(
				trimFactory.apply(class_8057.field_42022, class_8055.field_42012), COLOR_ILLUSIONER_COAT,
				new class_1792[] { class_1802.field_8267, class_1802.field_8577, class_1802.field_8570 })
				.method_336(class_55.method_347()
						.method_356(class_219.method_932(0.9f))
						.method_351(class_77.method_411(class_1802.field_8102)
								.method_438(class_109.method_489()
										.method_524(class_219.method_932(0.3f)))))
				.method_336(class_55.method_347()
						.method_356(class_215.method_917(class_47.class_50.field_935,
								class_2048.class_2049.method_8916()
										.method_8917(class_2050.method_8929(class_1299.field_6137))))
						.method_356(class_219.method_932(0.9f))
						.method_351(class_77.method_411(class_1802.field_8087)
								.method_438(class_159.method_677(blindnessEffectTag))))
		);

		// Vex cosplay, including sword (even for ranged mobs)
		var vexHeadTag = new class_2487();
		trimSetter.accept(trimFactory.apply(class_8057.field_42022, class_8055.field_42013), vexHeadTag);
		tables.put(BotaniaLootTables.LOONIUM_ARMORSET_COSTUME_VEX, class_52.method_324()
				.method_336(class_55.method_347().method_351(class_77.method_411(class_1802.field_8805)
						.method_438(class_159.method_677(vexHeadTag))))
				.method_336(class_55.method_347().method_351(class_77.method_411(class_1802.field_8058)))
				.method_336(class_55.method_347().method_351(class_77.method_411(class_1802.field_8348)))
				.method_336(class_55.method_347()
						.method_356(class_219.method_932(0.9f))
						.method_351(class_77.method_411(class_1802.field_8371)
								.method_438(class_109.method_489()
										.method_524(class_219.method_932(0.3f)))))
		);

		tables.put(BotaniaLootTables.LOONIUM_ARMOR_MANSION,
				class_52.method_324().method_336(class_55.method_347()
						// it's cosplays all the way down
						.method_351(class_83.method_428(BotaniaLootTables.LOONIUM_ARMORSET_COSTUME_EVOKER).method_437(2))
						.method_351(class_83.method_428(BotaniaLootTables.LOONIUM_ARMORSET_COSTUME_VINDICATOR).method_437(2))
						.method_351(class_83.method_428(BotaniaLootTables.LOONIUM_ARMORSET_COSTUME_ILLUSIONER).method_437(1))
						.method_351(class_83.method_428(BotaniaLootTables.LOONIUM_ARMORSET_COSTUME_VEX).method_437(45)
								.method_421(class_8551.method_51727(
										// focus Vex cosplay on baby mobs, reduce chance for everyone else
										class_219.method_932(0.005f),
										class_215.method_917(class_47.class_50.field_935,
												class_2048.class_2049.method_8916()
														.method_8919(class_2040.class_2041.method_8897().method_29935(true).method_8899()))
								)))
				).method_336(class_55.method_347()
						.method_356(class_219.method_932(0.05f))
						.method_351(class_77.method_411(class_1802.field_8288))
				)
		);
	}

	private static class_8053 getTrim(class_7225.class_7226<class_8056> patternRegistry,
			class_7225.class_7226<class_8054> materialRegistry,
			class_5321<class_8056> pattern, class_5321<class_8054> material) {
		class_6880.class_6883<class_8056> tidePattern = patternRegistry.method_46746(pattern).orElseThrow();
		class_6880.class_6883<class_8054> goldMaterial = materialRegistry.method_46746(material).orElseThrow();
		return new class_8053(goldMaterial, tidePattern);
	}

	private static Consumer<class_2487> addTrimToTag(class_7225.class_7874 registryLookup, class_8053 trim) {
		// [VanillaCopy] from ArmorTrim::setTrim, because no access to item tags here
		return tag -> tag.method_10566(class_8053.field_41995,
				class_8053.field_41994.encodeStart(class_6903.method_46632(class_2509.field_11560, registryLookup), trim)
						.result().orElseThrow());
	}

	private static Consumer<class_2487> addDyedColorToTag(int color) {
		// [VanillaCopy] implementation based on DyeableLeatherItem::setColor
		class_2487 displayTag = new class_2487();
		displayTag.method_10569("color", color);
		return tag -> tag.method_10566("display", displayTag);
	}

	private class_52.class_53 createArmorSet(Consumer<class_2487> tagModifier, boolean randomized, class_1792... armorItems) {
		class_2487 tag = new class_2487();
		tagModifier.accept(tag);
		class_52.class_53 lootTable = class_52.method_324();
		for (class_1792 armorItem : armorItems) {
			lootTable.method_336(class_55.method_347()
					.method_352(randomized ? class_5662.method_32462(0, 1) : class_44.method_32448(1))
					.method_351(class_77.method_411(armorItem).method_438(class_159.method_677(tag))));
		}
		return lootTable;
	}

	@NotNull
	@Override
	public String method_10321() {
		return "Equipment tables for Loonium-spawned mobs";
	}
}
