/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block.flower.functional;

import com.mojang.datafixers.util.Pair;
import vazkii.botania.api.block_entity.RadiusDescriptor;
import vazkii.botania.api.block_entity.SpecialFlowerBlockEntity;
import vazkii.botania.client.fx.SparkleParticleData;
import vazkii.botania.common.block.BotaniaFlowerBlocks;
import vazkii.botania.common.block.block_entity.mana.ManaPoolBlockEntity;

import java.util.*;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3532;

public class BergamuteBlockEntity extends SpecialFlowerBlockEntity {
	private static final int RANGE = 4;
	private static final Set<BergamuteBlockEntity> clientFlowers = Collections.newSetFromMap(new WeakHashMap<>());
	private static final Set<BergamuteBlockEntity> serverFlowers = Collections.newSetFromMap(new WeakHashMap<>());
	private boolean disabled = false;

	public BergamuteBlockEntity(class_2338 pos, class_2680 state) {
		super(BotaniaFlowerBlocks.BERGAMUTE, pos, state);
	}

	@Override
	public void tickFlower() {
		super.tickFlower();

		disabled = method_10997().method_49803(method_11016());
		if (method_10997().field_9236) {
			clientFlowers.add(this);
		} else {
			serverFlowers.add(this);
		}
	}

	@Override
	public void method_11012() {
		super.method_11012();
		if (method_10997().field_9236) {
			clientFlowers.remove(this);
		} else {
			serverFlowers.remove(this);
		}
	}

	public static Pair<Integer, BergamuteBlockEntity> getBergamutesNearby(class_1937 level, double x, double y, double z, int maxCount) {
		int count = 0;
		BergamuteBlockEntity tile = null;

		for (BergamuteBlockEntity f : level.field_9236 ? clientFlowers : serverFlowers) {
			if (!f.disabled
					&& level == f.field_11863
					&& f.getEffectivePos().method_10268(x, y, z) <= RANGE * RANGE) {
				count++;
				if (count == 1) {
					tile = f;
				}
				if (count >= maxCount) {
					break;
				}
			}
		}
		return Pair.of(count, tile);
	}

	public static boolean isBergamuteNearby(class_1937 level, double x, double y, double z) {
		return getBergamutesNearby(level, x, y, z, 1).getFirst() > 0;
	}

	public static boolean isBergamuteOccludingVibration(class_1937 level, class_243 sourcePos, class_243 destPos) {
		class_2338 sourceBlockPos = class_2338.method_49638(sourcePos);
		class_2338 destBlockPos = class_2338.method_49638(destPos);

		// vibration occlusions assume block centers as source and target positions, so do that here as well
		class_243 sourceCenterPos = sourceBlockPos.method_46558();
		if (sourceBlockPos.equals(destBlockPos)) {
			// trivial case: source and dest are in the same block, check Bergamute proximity to that block's center
			return isBergamuteNearby(level, sourceCenterPos.field_1352, sourceCenterPos.field_1351, sourceCenterPos.field_1350);
		}

		// find the point on the line between source and destination that is closest to each Bergamute,
		// and check whether it's actually in range of that Bergamute
		// (based on https://stackoverflow.com/questions/51905268/how-to-find-closest-point-on-line)
		class_243 destCenterPos = destBlockPos.method_46558();
		class_243 vibrationTravelVector = sourceCenterPos.method_1035(destCenterPos);
		double vibrationTravelDist = vibrationTravelVector.method_1033();
		class_243 vibrationTravelDir = vibrationTravelVector.method_1029();

		for (BergamuteBlockEntity f : level.field_9236 ? clientFlowers : serverFlowers) {
			if (f.disabled || f.field_11863 != level) {
				continue;
			}

			class_243 flowerPos = f.getEffectivePos().method_46558();
			class_243 vecSourceToFlower = sourceCenterPos.method_1035(flowerPos);
			double travelPosition = class_3532.method_15350(vibrationTravelDir.method_1026(vecSourceToFlower), 0, vibrationTravelDist);
			class_243 closestPos = sourceCenterPos.method_1019(vibrationTravelDir.method_1021(travelPosition));
			if (flowerPos.method_1025(closestPos) <= RANGE * RANGE) {
				return true;
			}
		}

		return false;
	}

	public static void particle(BergamuteBlockEntity berg) {
		int color = ManaPoolBlockEntity.PARTICLE_COLOR;
		float red = (color >> 16 & 0xFF) / 255F;
		float green = (color >> 8 & 0xFF) / 255F;
		float blue = (color & 0xFF) / 255F;
		SparkleParticleData data = SparkleParticleData.sparkle((float) Math.random(), red, green, blue, 5);
		berg.emitParticle(data, 0.3 + Math.random() * 0.5, 0.5 + Math.random() * 0.5, 0.3 + Math.random() * 0.5, 0, 0, 0);
	}

	@Override
	public RadiusDescriptor getRadius() {
		return new RadiusDescriptor.Circle(getEffectivePos(), RANGE);
	}

}
