/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.network.serverbound;

import net.minecraft.class_1799;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import vazkii.botania.common.handler.EquipmentHandler;
import vazkii.botania.common.item.equipment.bauble.CirrusAmuletItem;
import vazkii.botania.network.BotaniaPacket;

import static vazkii.botania.common.lib.ResourceLocationHelper.prefix;

public class JumpPacket implements BotaniaPacket {
	public static final JumpPacket INSTANCE = new JumpPacket();
	public static final class_2960 ID = prefix("jmp");

	@Override
	public void encode(class_2540 buf) {

	}

	@Override
	public class_2960 getFabricId() {
		return ID;
	}

	public static JumpPacket decode(class_2540 buf) {
		return INSTANCE;
	}

	public void handle(MinecraftServer server, class_3222 player) {
		server.execute(() -> {
			class_1799 amuletStack = EquipmentHandler.findOrEmpty(s -> s.method_7909() instanceof CirrusAmuletItem, player);
			if (!amuletStack.method_7960()) {
				player.method_7322(0.3F);
				player.field_6017 = 0;

				CirrusAmuletItem.setJumping(player);
			}
		});
	}
}
