/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.data;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mojang.datafixers.util.Pair;
import org.jetbrains.annotations.NotNull;

import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.common.block.*;
import vazkii.botania.common.block.decor.BotaniaMushroomBlock;
import vazkii.botania.common.block.decor.FloatingFlowerBlock;
import vazkii.botania.common.block.decor.FlowerMotifBlock;
import vazkii.botania.common.block.decor.PetalBlock;
import vazkii.botania.common.block.mana.ManaPoolBlock;
import vazkii.botania.common.block.mana.ManaSpreaderBlock;
import vazkii.botania.common.item.BottledManaItem;
import vazkii.botania.common.item.brew.BaseBrewItem;
import vazkii.botania.common.item.lens.LensItem;
import vazkii.botania.common.item.material.MysticalPetalItem;
import vazkii.botania.common.lib.LibMisc;
import vazkii.botania.data.util.ModelWithOverrides;
import vazkii.botania.data.util.OverrideHolder;
import vazkii.botania.data.util.SimpleModelSupplierWithOverrides;
import vazkii.botania.mixin.TextureSlotAccessor;
import vazkii.botania.xplat.XplatAbstractions;

import java.util.*;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2389;
import net.minecraft.class_2405;
import net.minecraft.class_2544;
import net.minecraft.class_2960;
import net.minecraft.class_4940;
import net.minecraft.class_4941;
import net.minecraft.class_4942;
import net.minecraft.class_4943;
import net.minecraft.class_4944;
import net.minecraft.class_4945;
import net.minecraft.class_7403;
import net.minecraft.class_7784;
import net.minecraft.class_7923;

import static vazkii.botania.common.item.BotaniaItems.*;
import static vazkii.botania.common.lib.ResourceLocationHelper.prefix;

public class ItemModelProvider implements class_2405 {
	private static final class_4945 LAYER1 = TextureSlotAccessor.make("layer1");
	private static final class_4945 LAYER2 = TextureSlotAccessor.make("layer2");
	private static final class_4945 LAYER3 = TextureSlotAccessor.make("layer3");
	private static final class_4942 GENERATED_1 = new class_4942(Optional.of(new class_2960("item/generated")), Optional.empty(), class_4945.field_23006, LAYER1);
	private static final class_4942 GENERATED_2 = new class_4942(Optional.of(new class_2960("item/generated")), Optional.empty(), class_4945.field_23006, LAYER1, LAYER2);
	private static final class_4942 HANDHELD_1 = new class_4942(Optional.of(new class_2960("item/handheld")), Optional.empty(), class_4945.field_23006, LAYER1);
	private static final class_4942 HANDHELD_3 = new class_4942(Optional.of(new class_2960("item/handheld")), Optional.empty(), class_4945.field_23006, LAYER1, LAYER2, LAYER3);
	private static final class_4942 WALL_INVENTORY = new class_4942(Optional.of(prefix("block/shapes/wall_inventory")), Optional.empty(), class_4945.field_23015, class_4945.field_23014, class_4945.field_23027);
	private static final class_4942 WALL_INVENTORY_CHECKERED = new class_4942(Optional.of(prefix("block/shapes/wall_inventory_checkered")), Optional.empty(), class_4945.field_23019, class_4945.field_23018);
	private static final class_4945 OUTSIDE = TextureSlotAccessor.make("outside");
	private static final class_4945 CORE = TextureSlotAccessor.make("core");
	private static final class_4942 SPREADER = new class_4942(Optional.of(prefix("block/shapes/spreader_item")), Optional.empty(), class_4945.field_23018, class_4945.field_23017, class_4945.field_27791, OUTSIDE, CORE);
	private static final ModelWithOverrides GENERATED_OVERRIDES = new ModelWithOverrides(new class_2960("item/generated"), class_4945.field_23006);
	private static final ModelWithOverrides GENERATED_OVERRIDES_1 = new ModelWithOverrides(new class_2960("item/generated"), class_4945.field_23006, LAYER1);
	private static final ModelWithOverrides HANDHELD_OVERRIDES = new ModelWithOverrides(new class_2960("item/handheld"), class_4945.field_23006);
	private static final ModelWithOverrides HANDHELD_OVERRIDES_2 = new ModelWithOverrides(new class_2960("item/handheld"), class_4945.field_23006, LAYER1, LAYER2);

	private final class_7784 packOutput;

	public ItemModelProvider(class_7784 packOutput) {
		this.packOutput = packOutput;
	}

	@Override
	public CompletableFuture<?> method_10319(class_7403 cache) {
		Set<class_1792> items = class_7923.field_41178.method_10220().filter(i -> LibMisc.MOD_ID.equals(class_7923.field_41178.method_10221(i).method_12836()))
				.collect(Collectors.toSet());
		Map<class_2960, Supplier<JsonElement>> map = new HashMap<>();
		registerItemBlocks(takeAll(items, i -> i instanceof class_1747).stream().map(i -> (class_1747) i).collect(Collectors.toSet()), map::put);
		registerItemOverrides(items, map::put);
		registerItems(items, map::put);

		class_7784.class_7489 modelPathProvider = packOutput.method_45973(class_7784.class_7490.field_39368, "models");
		List<CompletableFuture<?>> output = new ArrayList<>();

		for (Map.Entry<class_2960, Supplier<JsonElement>> e : map.entrySet()) {
			class_2960 id = e.getKey();
			output.add(class_2405.method_10320(cache, e.getValue().get(), modelPathProvider.method_44107(id)));
		}

		return CompletableFuture.allOf(output.toArray(CompletableFuture[]::new));
	}

	private static void registerItems(Set<class_1792> items, BiConsumer<class_2960, Supplier<JsonElement>> consumer) {
		// Written manually
		items.remove(manaGun);

		takeAll(items, i -> i instanceof LensItem).forEach(i -> {
			class_2960 lens;
			if (i == lensTime || i == lensWarp || i == lensFire || i == lensTripwire) {
				// To avoid z-fighting
				lens = prefix("item/lens_small");
			} else {
				lens = prefix("item/lens");
			}
			GENERATED_1.method_25852(class_4941.method_25840(i),
					class_4944.method_25895(lens).method_25868(LAYER1, class_4944.method_25876(i)), consumer);
		});

		GENERATED_1.method_25852(class_4941.method_25840(bloodPendant),
				class_4944.method_25895(class_4944.method_25876(bloodPendant))
						.method_25868(LAYER1, class_4944.method_25863(bloodPendant, "_overlay")),
				consumer);
		items.remove(bloodPendant);

		HANDHELD_1.method_25852(class_4941.method_25840(enderDagger),
				class_4944.method_25895(class_4944.method_25876(enderDagger))
						.method_25868(LAYER1, class_4944.method_25863(enderDagger, "_overlay")),
				consumer);
		items.remove(enderDagger);

		GENERATED_1.method_25852(class_4941.method_25840(incenseStick),
				class_4944.method_25895(class_4944.method_25876(incenseStick))
						.method_25868(LAYER1, class_4944.method_25863(incenseStick, "_overlay")),
				consumer);
		items.remove(incenseStick);

		GENERATED_1.method_25852(class_4941.method_25840(manaMirror),
				class_4944.method_25895(class_4944.method_25876(manaMirror))
						.method_25868(LAYER1, class_4944.method_25863(manaMirror, "_overlay")),
				consumer);
		items.remove(manaMirror);

		GENERATED_1.method_25852(class_4941.method_25840(manaTablet),
				class_4944.method_25895(class_4944.method_25876(manaTablet))
						.method_25868(LAYER1, class_4944.method_25863(manaTablet, "_overlay")),
				consumer);
		items.remove(manaTablet);

		GENERATED_2.method_25852(class_4941.method_25840(thirdEye),
				new class_4944().method_25868(class_4945.field_23006, class_4944.method_25863(thirdEye, "_0"))
						.method_25868(LAYER1, class_4944.method_25863(thirdEye, "_1"))
						.method_25868(LAYER2, class_4944.method_25863(thirdEye, "_2")),
				consumer);
		items.remove(thirdEye);

		takeAll(items, cobbleRod, dirtRod, diviningRod, elementiumAxe, elementiumPick, elementiumShovel, elementiumHoe, elementiumSword,
				exchangeRod, fireRod, glassPick, gravityRod, manasteelAxe, manasteelPick, manasteelShears, manasteelShovel, manasteelHoe,
				missileRod, obedienceStick, rainbowRod, smeltRod, starSword, terraSword, terraformRod, thunderSword, waterRod,
				kingKey, skyDirtRod).forEach(i -> class_4943.field_22939.method_25852(class_4941.method_25840(i), class_4944.method_25871(i), consumer));

		takeAll(items, i -> true).forEach(i -> class_4943.field_22938.method_25852(class_4941.method_25840(i), class_4944.method_25871(i), consumer));
	}

	private static void singleGeneratedOverride(class_1792 item, class_2960 overrideModel, class_2960 predicate, double value, BiConsumer<class_2960, Supplier<JsonElement>> consumer) {
		class_4943.field_22938.method_25852(overrideModel, class_4944.method_25895(overrideModel), consumer);
		GENERATED_OVERRIDES.create(class_4941.method_25840(item),
				class_4944.method_25871(item),
				new OverrideHolder()
						.add(overrideModel, Pair.of(predicate, value)),
				consumer);
	}

	private static void singleGeneratedSuffixOverride(class_1792 item, String suffix, class_2960 predicate, double value, BiConsumer<class_2960, Supplier<JsonElement>> consumer) {
		singleGeneratedOverride(item, class_4941.method_25841(item, suffix), predicate, value, consumer);
	}

	private static void singleHandheldOverride(class_1792 item, class_2960 overrideModel, class_2960 predicate, double value, BiConsumer<class_2960, Supplier<JsonElement>> consumer) {
		class_4943.field_22939.method_25852(overrideModel, class_4944.method_25895(overrideModel), consumer);
		HANDHELD_OVERRIDES.create(class_4941.method_25840(item),
				class_4944.method_25871(item),
				new OverrideHolder()
						.add(overrideModel, Pair.of(predicate, value)),
				consumer);
	}

	private static void singleHandheldSuffixOverride(class_1792 item, String suffix, class_2960 predicate, double value, BiConsumer<class_2960, Supplier<JsonElement>> consumer) {
		singleHandheldOverride(item, class_4941.method_25841(item, suffix), predicate, value, consumer);
	}

	private static void registerItemOverrides(Set<class_1792> items, BiConsumer<class_2960, Supplier<JsonElement>> consumer) {
		// Written manually
		items.remove(livingwoodBow);
		items.remove(crystalBow);

		singleGeneratedSuffixOverride(baubleBox, "_open", prefix("open"), 1.0, consumer);
		items.remove(baubleBox);

		singleGeneratedSuffixOverride(blackHoleTalisman, "_active", prefix("active"), 1.0, consumer);
		items.remove(blackHoleTalisman);

		registerBrewContainerOverrides(brewFlask, flask, consumer);
		items.remove(brewFlask);

		registerBrewContainerOverrides(brewVial, vial, consumer);
		items.remove(brewVial);

		singleHandheldOverride(elementiumShears, prefix("item/dammitreddit"), prefix("reddit"), 1, consumer);
		items.remove(elementiumShears);

		class_2960 vuvuzela = prefix("item/vuvuzela");
		class_4943.field_22939.method_25852(vuvuzela, class_4944.method_25895(vuvuzela), consumer);
		for (class_1792 i : new class_1792[] { grassHorn, leavesHorn, snowHorn }) {
			GENERATED_OVERRIDES.create(class_4941.method_25840(i),
					class_4944.method_25871(i),
					new OverrideHolder()
							.add(vuvuzela, Pair.of(prefix("vuvuzela"), 1.0)),
					consumer
			);
		}
		items.remove(grassHorn);
		items.remove(leavesHorn);
		items.remove(snowHorn);

		singleGeneratedOverride(infiniteFruit, prefix("item/dasboot"), prefix("boot"), 1, consumer);
		items.remove(infiniteFruit);

		singleGeneratedSuffixOverride(lexicon, "_elven", prefix("elven"), 1.0, consumer);
		items.remove(lexicon);

		singleGeneratedSuffixOverride(magnetRing, "_active", prefix("active"), 1.0, consumer);
		items.remove(magnetRing);

		singleGeneratedSuffixOverride(magnetRingGreater, "_active", prefix("active"), 1.0, consumer);
		items.remove(magnetRingGreater);

		OverrideHolder bottleOverrides = new OverrideHolder();
		for (int i = 1; i < BottledManaItem.SWIGS; i++) {
			class_2960 overrideModel = class_4941.method_25841(manaBottle, "_" + i);
			class_4943.field_22938.method_25852(overrideModel, class_4944.method_25895(overrideModel), consumer);
			bottleOverrides.add(overrideModel, Pair.of(prefix("swigs_taken"), (double) i / (BottledManaItem.SWIGS - 1)));
		}
		GENERATED_OVERRIDES.create(class_4941.method_25840(manaBottle),
				class_4944.method_25871(manaBottle),
				bottleOverrides,
				consumer);
		items.remove(manaBottle);

		singleGeneratedOverride(manaCookie, prefix("item/totalbiscuit"), prefix("totalbiscuit"), 1.0, consumer);
		items.remove(manaCookie);

		singleHandheldOverride(manasteelSword, prefix("item/elucidator"), prefix("elucidator"), 1.0, consumer);
		items.remove(manasteelSword);

		singleGeneratedSuffixOverride(manaweaveHelm, "_holiday", prefix("holiday"), 1.0, consumer);
		items.remove(manaweaveHelm);

		singleGeneratedSuffixOverride(manaweaveChest, "_holiday", prefix("holiday"), 1.0, consumer);
		items.remove(manaweaveChest);

		singleGeneratedSuffixOverride(manaweaveLegs, "_holiday", prefix("holiday"), 1.0, consumer);
		items.remove(manaweaveLegs);

		singleGeneratedSuffixOverride(manaweaveBoots, "_holiday", prefix("holiday"), 1.0, consumer);
		items.remove(manaweaveBoots);

		singleGeneratedSuffixOverride(slimeBottle, "_active", prefix("active"), 1.0, consumer);
		items.remove(slimeBottle);

		singleGeneratedSuffixOverride(spawnerMover, "_full", prefix("full"), 1.0, consumer);
		items.remove(spawnerMover);

		singleGeneratedSuffixOverride(temperanceStone, "_active", prefix("active"), 1.0, consumer);
		items.remove(temperanceStone);

		singleHandheldSuffixOverride(terraAxe, "_active", prefix("active"), 1.0, consumer);
		items.remove(terraAxe);

		singleGeneratedSuffixOverride(autocraftingHalo, "_active", prefix("active"), 1.0, consumer);
		items.remove(autocraftingHalo);

		class_2960 enabledModel = class_4941.method_25841(terraPick, "_active");
		class_4943.field_22939.method_25852(enabledModel, class_4944.method_25895(enabledModel), consumer);

		class_2960 tippedModel = class_4941.method_25841(terraPick, "_tipped");
		class_4943.field_22939.method_25852(tippedModel, class_4944.method_25895(tippedModel), consumer);

		class_2960 tippedEnabledModel = class_4941.method_25841(terraPick, "_tipped_active");
		class_4943.field_22939.method_25852(tippedEnabledModel, class_4944.method_25895(tippedEnabledModel), consumer);

		HANDHELD_OVERRIDES.create(class_4941.method_25840(terraPick),
				class_4944.method_25871(terraPick),
				new OverrideHolder()
						.add(enabledModel, Pair.of(prefix("active"), 1.0))
						.add(tippedModel, Pair.of(prefix("tipped"), 1.0))
						.add(tippedEnabledModel, Pair.of(prefix("tipped"), 1.0), Pair.of(prefix("active"), 1.0)),
				consumer);
		items.remove(terraPick);

		singleHandheldSuffixOverride(tornadoRod, "_active", prefix("active"), 1.0, consumer);
		items.remove(tornadoRod);

		class_4944 twigWandTextures = class_4944.method_25871(twigWand)
				.method_25868(LAYER1, class_4944.method_25863(twigWand, "_top"))
				.method_25868(LAYER2, class_4944.method_25863(twigWand, "_bottom"));
		class_2960 twigWandBind = class_4941.method_25841(twigWand, "_bind");
		HANDHELD_3.method_25852(twigWandBind,
				twigWandTextures.method_25879(LAYER3, class_4944.method_25863(twigWand, "_bind")),
				consumer);
		HANDHELD_OVERRIDES_2.create(class_4941.method_25840(twigWand),
				twigWandTextures,
				new OverrideHolder()
						.add(twigWandBind, Pair.of(prefix("bindmode"), 1.0)),
				consumer);
		items.remove(twigWand);

		class_4944 dreamwoodWandTextures = class_4944.method_25871(dreamwoodWand)
				.method_25868(LAYER1, class_4944.method_25863(dreamwoodWand, "_top"))
				.method_25868(LAYER2, class_4944.method_25863(dreamwoodWand, "_bottom"));
		class_2960 dreamwoodWandBind = class_4941.method_25841(dreamwoodWand, "_bind");
		HANDHELD_3.method_25852(dreamwoodWandBind,
				dreamwoodWandTextures.method_25879(LAYER3, class_4944.method_25863(dreamwoodWand, "_bind")),
				consumer);
		HANDHELD_OVERRIDES_2.create(class_4941.method_25840(dreamwoodWand),
				dreamwoodWandTextures,
				new OverrideHolder()
						.add(dreamwoodWandBind, Pair.of(prefix("bindmode"), 1.0)),
				consumer);
		items.remove(dreamwoodWand);
	}

	private static void registerBrewContainerOverrides(BaseBrewItem brewItem, class_1792 emptyItem,
			BiConsumer<class_2960, Supplier<JsonElement>> consumer) {
		OverrideHolder flaskOverrides = new OverrideHolder();
		for (int i = 1; i < brewItem.getSwigs(); i++) {
			class_2960 overrideModel = class_4941.method_25841(brewItem, "_" + i);
			GENERATED_1.method_25852(overrideModel,
					class_4944.method_25871(emptyItem).method_25868(LAYER1, overrideModel),
					consumer);

			flaskOverrides.add(overrideModel, Pair.of(prefix("swigs_taken"), (double) i / (brewItem.getSwigs() - 1)));
		}
		GENERATED_OVERRIDES_1.create(class_4941.method_25840(brewItem),
				class_4944.method_25871(emptyItem).method_25868(LAYER1, class_4944.method_25863(brewItem, "_0")),
				flaskOverrides,
				consumer);
	}

	private void registerItemBlocks(Set<class_1747> itemBlocks, BiConsumer<class_2960, Supplier<JsonElement>> consumer) {
		// Manually written
		itemBlocks.remove(BotaniaBlocks.corporeaCrystalCube.method_8389());

		// Generated by FloatingFlowerModelProvider
		itemBlocks.removeIf(i -> {
			var id = class_7923.field_41175.method_10221(i.method_7711());
			return id.method_12836().equals(LibMisc.MOD_ID) && i.method_7711() instanceof FloatingFlowerBlock;
		});

		GENERATED_1.method_25852(class_4941.method_25840(BotaniaBlocks.animatedTorch.method_8389()),
				class_4944.method_25911(class_2246.field_10523).method_25868(LAYER1, prefix("block/animated_torch_glimmer")), consumer);
		itemBlocks.remove(BotaniaBlocks.animatedTorch.method_8389());

		class_4943.field_22945.method_25852(class_4941.method_25840(BotaniaBlocks.gaiaHead.method_8389()), new class_4944(), consumer);
		itemBlocks.remove(BotaniaBlocks.gaiaHead.method_8389());

		takeAll(itemBlocks, i -> i.method_7711() instanceof BotaniaDoubleFlowerBlock).forEach(i -> {
			class_4943.field_22938.method_25852(class_4941.method_25840(i), class_4944.method_25895(class_4944.method_25866(i.method_7711(), "_top")), consumer);
		});

		takeAll(itemBlocks, i -> i.method_7711() instanceof PetalBlock).forEach(i -> {
			consumer.accept(class_4941.method_25840(i), new class_4940(prefix("block/petal_block")));
		});

		takeAll(itemBlocks, BotaniaBlocks.livingwoodFramed.method_8389(), BotaniaBlocks.dreamwoodFramed.method_8389()).forEach(i -> {
			String name = i == BotaniaBlocks.livingwoodFramed.method_8389() ? "livingwood" : "dreamwood";
			consumer.accept(class_4941.method_25840(i), new class_4940(prefix("block/framed_" + name + "_horizontal_z")));
		});

		consumer.accept(class_4941.method_25840(BotaniaBlocks.livingwoodFramed.method_8389()), new class_4940(prefix("block/framed_livingwood_horizontal_z")));
		consumer.accept(class_4941.method_25840(BotaniaBlocks.dreamwoodFramed.method_8389()), new class_4940(prefix("block/framed_dreamwood_horizontal_z")));
		itemBlocks.remove(BotaniaBlocks.livingwoodFramed.method_8389());
		itemBlocks.remove(BotaniaBlocks.dreamwoodFramed.method_8389());

		takeAll(itemBlocks, i -> i.method_7711() instanceof class_2389).forEach(i -> {
			String name = class_7923.field_41178.method_10221(i).method_12832();
			String baseName = name.substring(0, name.length() - "_pane".length());
			class_4943.field_22938.method_25852(class_4941.method_25840(i), class_4944.method_25895(prefix("block/" + baseName)), consumer);
		});

		Predicate<class_1747> defaultGenerated = i -> {
			class_2248 b = i.method_7711();
			return XplatAbstractions.INSTANCE.isSpecialFlowerBlock(b)
					|| b instanceof BotaniaMushroomBlock
					|| b instanceof LuminizerBlock
					|| b instanceof BotaniaFlowerBlock
					|| b == BotaniaBlocks.ghostRail;
		};
		takeAll(itemBlocks, defaultGenerated).forEach(i -> {
			class_4943.field_22938.method_25852(class_4941.method_25840(i), class_4944.method_25911(i.method_7711()), consumer);
		});

		takeAll(itemBlocks, b -> b.method_7711() instanceof FlowerMotifBlock).forEach(i -> {
			String name = class_7923.field_41178.method_10221(i).method_12832();
			class_2960 texName = prefix("block/" + name.replace("_motif", ""));
			class_4943.field_22938.method_25852(class_4941.method_25840(i), class_4944.method_25895(texName), consumer);
		});

		takeAll(itemBlocks, i -> i.method_7711() instanceof ManaPoolBlock).forEach(i -> {
			class_2960 fullModel = class_4941.method_25843(i.method_7711(), "_full");
			OverrideHolder overrides = new OverrideHolder().add(fullModel, Pair.of(prefix("full"), 1.0));
			consumer.accept(class_4941.method_25840(i),
					new SimpleModelSupplierWithOverrides(class_4941.method_25842(i.method_7711()), overrides));
		});
		takeAll(itemBlocks, Stream.of(BotaniaBlocks.livingwoodWall, BotaniaBlocks.livingwoodStrippedWall,
				BotaniaBlocks.dreamwoodWall, BotaniaBlocks.dreamwoodStrippedWall)
				.map(b -> (class_1747) b.method_8389())
				.toArray(class_1747[]::new)).forEach(i -> {

					String name = class_7923.field_41178.method_10221(i).method_12832();
					String baseName = name.substring(0, name.length() - "_wall".length()) + "_log";
					class_4943.field_22994.method_25852(class_4941.method_25840(i),
							new class_4944().method_25868(class_4945.field_23027, prefix("block/" + baseName)), consumer);
				});

		takeAll(itemBlocks, i -> i.method_7711() instanceof class_2544).forEach(i -> {
			String name = class_7923.field_41178.method_10221(i).method_12832();
			String baseName = name.substring(0, name.length() - "_wall".length());
			class_4943.field_22994.method_25852(class_4941.method_25840(i),
					new class_4944().method_25868(class_4945.field_23027, prefix("block/" + baseName)), consumer);
		});

		takeAll(itemBlocks, i -> i.method_7711() instanceof ManaSpreaderBlock).forEach(i -> {
			String name = class_7923.field_41178.method_10221(i).method_12832();
			String outside;
			if (i.method_7711() == BotaniaBlocks.elvenSpreader) {
				outside = "dreamwood_log_3";
			} else if (i.method_7711() == BotaniaBlocks.gaiaSpreader) {
				outside = name + "_outside";
			} else {
				outside = "livingwood_log";
			}
			String inside;
			if (i.method_7711() == BotaniaBlocks.elvenSpreader) {
				inside = "stripped_dreamwood_log_3";
			} else if (i.method_7711() == BotaniaBlocks.gaiaSpreader) {
				inside = name + "_inside";
			} else {
				inside = "stripped_livingwood_log";
			}
			SPREADER.method_25852(class_4941.method_25840(i),
					new class_4944()
							.method_25868(class_4945.field_23018, class_4944.method_25866(i.method_7711(), "_side"))
							.method_25868(OUTSIDE, prefix("block/" + outside))
							.method_25868(class_4945.field_23017, class_4944.method_25866(i.method_7711(), "_back"))
							.method_25868(class_4945.field_27791, prefix("block/" + inside))
							.method_25868(CORE, class_4944.method_25866(i.method_7711(), "_core")),
					consumer);
		});

		takeAll(itemBlocks, BotaniaBlocks.avatar.method_8389(), BotaniaBlocks.bellows.method_8389(),
				BotaniaBlocks.brewery.method_8389(), BotaniaBlocks.corporeaIndex.method_8389(), BotaniaBlocks.gaiaPylon.method_8389(),
				BotaniaBlocks.hourglass.method_8389(), BotaniaBlocks.manaPylon.method_8389(), BotaniaBlocks.naturaPylon.method_8389())
						.forEach(i -> builtinEntity(i, consumer));

		takeAll(itemBlocks, BotaniaBlocks.teruTeruBozu.method_8389())
				.forEach(i -> builtinEntity(i, consumer, 2.5));

		takeAll(itemBlocks, i -> i instanceof MysticalPetalItem).forEach(i -> {
			class_4943.field_22938.method_25852(class_4941.method_25840(i), class_4944.method_25895(class_4944.method_25876(i)), consumer);
		});

		class_4943.field_22990.method_25852(class_4941.method_25840(BotaniaBlocks.dreamwoodFence.method_8389()),
				class_4944.method_25872(BotaniaBlocks.dreamwoodPlanks), consumer);
		itemBlocks.remove(BotaniaBlocks.dreamwoodFence.method_8389());

		class_4943.field_22990.method_25852(class_4941.method_25840(BotaniaBlocks.livingwoodFence.method_8389()),
				class_4944.method_25872(BotaniaBlocks.livingwoodPlanks), consumer);
		itemBlocks.remove(BotaniaBlocks.livingwoodFence.method_8389());

		consumer.accept(class_4941.method_25840(BotaniaBlocks.elfGlass.method_8389()), new class_4940(prefix("block/elf_glass_0")));
		itemBlocks.remove(BotaniaBlocks.elfGlass.method_8389());

		WALL_INVENTORY.method_25852(class_4941.method_25840(BotaniaBlocks.biomeBrickPlainsWall.method_8389()),
				new class_4944()
						.method_25868(class_4945.field_23015, class_4944.method_25866(BotaniaBlocks.biomeBrickPlains, "_top"))
						.method_25868(class_4945.field_23014, class_4944.method_25866(BotaniaBlocks.biomeBrickPlains, "_top"))
						.method_25868(class_4945.field_23027, class_4944.method_25860(BotaniaBlocks.biomeBrickPlains)),
				consumer);
		itemBlocks.remove(BotaniaBlocks.biomeBrickPlainsWall.method_8389());

		WALL_INVENTORY_CHECKERED.method_25852(class_4941.method_25840(BotaniaBlocks.biomeBrickMesaWall.method_8389()),
				new class_4944()
						.method_25868(class_4945.field_23018, class_4944.method_25860(BotaniaBlocks.biomeBrickMesa))
						.method_25868(class_4945.field_23019, class_4944.method_25866(BotaniaBlocks.biomeBrickMesa, "_mirrored")),
				consumer);
		itemBlocks.remove(BotaniaBlocks.biomeBrickMesaWall.method_8389());

		itemBlocks.forEach(i -> {
			consumer.accept(class_4941.method_25840(i), new class_4940(class_4941.method_25842(i.method_7711())));
		});
	}

	// [VanillaCopy] item/chest.json
	// Scuffed af.....but it works :wacko:
	private static final String BUILTIN_ENTITY_DISPLAY_STR =
			"""
					{
						"gui": {
							"rotation": [30, 45, 0],
							"translation": [0, 0, 0],
							"scale": [0.625, 0.625, 0.625]
						},
						"ground": {
							"rotation": [0, 0, 0],
							"translation": [0, 3, 0],
							"scale": [0.25, 0.25, 0.25]
						},
						"head": {
							"rotation": [0, 180, 0],
							"translation": [0, 0, 0],
							"scale": [1, 1, 1]
						},
						"fixed": {
							"rotation": [0, 180, 0],
							"translation": [0, 0, 0],
							"scale": [0.5, 0.5, 0.5]
						},
						"thirdperson_righthand": {
							"rotation": [75, 315, 0],
							"translation": [0, 2.5, 0],
							"scale": [0.375, 0.375, 0.375]
						},
						"firstperson_righthand": {
							"rotation": [0, 315, 0],
							"translation": [0, 0, 0],
							"scale": [0.4, 0.4, 0.4]
						}
					}""";
	private static final JsonElement BUILTIN_ENTITY_DISPLAY = new Gson().fromJson(BUILTIN_ENTITY_DISPLAY_STR, JsonElement.class);

	protected void builtinEntity(class_1792 i, BiConsumer<class_2960, Supplier<JsonElement>> consumer) {
		builtinEntity(i, consumer, 0.0);
	}

	protected void builtinEntity(class_1792 i, BiConsumer<class_2960, Supplier<JsonElement>> consumer, double handYOffset) {
		final JsonElement display;
		if (handYOffset == 0.0) {
			display = BUILTIN_ENTITY_DISPLAY;
		} else {
			display = BUILTIN_ENTITY_DISPLAY.deepCopy();
			display.getAsJsonObject().getAsJsonObject("firstperson_righthand")
					.getAsJsonArray("translation").set(1, new JsonPrimitive(handYOffset));
		}
		consumer.accept(class_4941.method_25840(i), () -> {
			JsonObject json = new JsonObject();
			json.addProperty("parent", "minecraft:builtin/entity");
			json.add("display", display);
			return json;
		});
	}

	@SafeVarargs
	@SuppressWarnings("varargs")
	public static <T> Collection<T> takeAll(Set<? extends T> src, T... items) {
		List<T> ret = Arrays.asList(items);
		for (T item : items) {
			if (!src.contains(item)) {
				BotaniaAPI.LOGGER.warn("Item {} not found in set", item);
			}
		}
		if (!src.removeAll(ret)) {
			BotaniaAPI.LOGGER.warn("takeAll array didn't yield anything ({})", Arrays.toString(items));
		}
		return ret;
	}

	public static <T> Collection<T> takeAll(Set<T> src, Predicate<T> pred) {
		List<T> ret = new ArrayList<>();

		Iterator<T> iter = src.iterator();
		while (iter.hasNext()) {
			T item = iter.next();
			if (pred.test(item)) {
				iter.remove();
				ret.add(item);
			}
		}

		if (ret.isEmpty()) {
			BotaniaAPI.LOGGER.warn("takeAll predicate yielded nothing", new Throwable());
		}
		return ret;
	}

	@NotNull
	@Override
	public String method_10321() {
		return "Botania item models";
	}
}
