/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.item;

import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2582;
import net.minecraft.class_6862;
import vazkii.botania.api.mana.spark.SparkUpgradeType;
import vazkii.botania.common.lib.BotaniaTags;

public class SparkAugmentItem extends class_1792 implements ItemWithBannerPattern {
	public final SparkUpgradeType type;

	public SparkAugmentItem(class_1793 builder, SparkUpgradeType type) {
		super(builder);
		this.type = type;
	}

	@Override
	public class_6862<class_2582> getBannerPattern() {
		return switch (this.type) {
			case DOMINANT -> BotaniaTags.BannerPatterns.PATTERN_ITEM_SPARK_DOMINANT;
			case RECESSIVE -> BotaniaTags.BannerPatterns.PATTERN_ITEM_SPARK_RECESSIVE;
			case DISPERSIVE -> BotaniaTags.BannerPatterns.PATTERN_ITEM_SPARK_DISPERSIVE;
			case ISOLATED -> BotaniaTags.BannerPatterns.PATTERN_ITEM_SPARK_ISOLATED;
			case NONE -> throw new IllegalArgumentException("SparkAugmentItem with none type");
		};
	}

	public static class_1799 getByType(SparkUpgradeType type) {
		return switch (type) {
			case DOMINANT -> new class_1799(BotaniaItems.sparkUpgradeDominant);
			case RECESSIVE -> new class_1799(BotaniaItems.sparkUpgradeRecessive);
			case DISPERSIVE -> new class_1799(BotaniaItems.sparkUpgradeDispersive);
			case ISOLATED -> new class_1799(BotaniaItems.sparkUpgradeIsolated);
			default -> class_1799.field_8037;
		};
	}

}
