/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.client.model;

import net.minecraft.class_1921;
import net.minecraft.class_3879;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_5603;
import net.minecraft.class_5606;
import net.minecraft.class_5609;
import net.minecraft.class_5610;
import net.minecraft.class_630;
import vazkii.botania.common.helper.VecHelper;

public class BellowsModel extends class_3879 {

	private final class_630 top;
	private final class_630 base;
	private final class_630 pipe;
	private final class_630 funnel;

	public BellowsModel(class_630 root) {
		super(class_1921::method_23576);

		top = root.method_32086("top");
		base = root.method_32086("base");
		pipe = root.method_32086("pipe");
		funnel = root.method_32086("funnel");
	}

	public static class_5609 createMesh() {
		var mesh = new class_5609();
		var root = mesh.method_32111();
		root.method_32117("top", class_5606.method_32108()
				.method_32097(-4.0F, -2.0F, -4.0F, 8, 1, 8),
				class_5603.method_32090(0.0F, 16.0F, 0.0F));
		root.method_32117("base", class_5606.method_32108().method_32101(0, 9)
				.method_32097(-5.0F, 6.0F, -5.0F, 10, 2, 10),
				class_5603.method_32090(0.0F, 16.0F, 0.0F));
		root.method_32117("pipe", class_5606.method_32108().method_32101(0, 21)
				.method_32097(-1.0F, 6.0F, -8.0F, 2, 2, 3),
				class_5603.method_32090(0.0F, 16.0F, 0.0F));
		root.method_32117("funnel", class_5606.method_32108().method_32101(40, 0)
				.method_32097(0.0F, 0.0F, 0.0F, 6, 7, 6),
				class_5603.field_27701);
		return mesh;
	}

	@Override
	public void method_2828(class_4587 ms, class_4588 buffer, int light, int overlay, float r, float g, float b, float a) {
		render(ms, buffer, light, overlay, r, g, b, a, 1);
	}

	public void render(class_4587 ms, class_4588 buffer, int light, int overlay, float r, float g, float b, float alpha, float fract) {
		base.method_22699(ms, buffer, light, overlay, r, g, b, alpha);
		pipe.method_22699(ms, buffer, light, overlay, r, g, b, alpha);

		float mov = (1F - fract) * 0.5F;

		ms.method_46416(0F, mov, 0F);
		top.method_22699(ms, buffer, light, overlay, r, g, b, alpha);
		ms.method_46416(0F, -mov, 0F);

		ms.method_22907(VecHelper.rotateX(180F));
		ms.method_46416(-0.19F, -1.375F, -0.19F);
		ms.method_22905(1F, fract, 1F);
		funnel.method_22699(ms, buffer, light, overlay, r, g, b, alpha);
		ms.method_22905(1F, 1F / fract, 1F);
	}

}
