/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.fabric.mixin;

import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2580;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyVariable;

import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.block.PermanentBifrostBlock;

@Mixin(class_2580.class)
public class BeaconBlockEntityFabricMixin {
	@Unique
	private static boolean bifrost = false;

	@ModifyVariable(method = "tick", at = @At(value = "INVOKE_ASSIGN", target = "Lnet/minecraft/world/level/block/state/BlockState;getBlock()Lnet/minecraft/world/level/block/Block;"))
	private static class_2248 captureBifrost(class_2248 obj) {
		bifrost = obj == BotaniaBlocks.bifrostPerm;
		return obj;
	}

	@ModifyVariable(method = "tick", at = @At(value = "INVOKE_ASSIGN", target = "Lnet/minecraft/world/item/DyeColor;getTextureDiffuseColors()[F"))
	private static float[] bifrostColor(float[] obj, class_1937 level) {
		if (bifrost) {
			return ((PermanentBifrostBlock) BotaniaBlocks.bifrostPerm).getBeaconColorMultiplier(
					BotaniaBlocks.bifrostPerm.method_9564(),
					level, class_2338.field_10980, class_2338.field_10980);
		}
		return obj;
	}
}
