/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.item.block;

import org.jetbrains.annotations.NotNull;

import vazkii.botania.common.block.flower.generating.HydroangeasBlockEntity;
import vazkii.botania.common.lib.BotaniaTags;
import vazkii.botania.xplat.BotaniaConfig;

import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_3532;
import net.minecraft.class_5250;
import net.minecraft.class_6862;

public class SpecialFlowerBlockItem extends class_1747 {
	private static final class_6862<class_1792> GENERATING = BotaniaTags.Items.GENERATING_SPECIAL_FLOWERS;
	private static final class_6862<class_1792> FUNCTIONAL = BotaniaTags.Items.FUNCTIONAL_SPECIAL_FLOWERS;
	private static final class_6862<class_1792> MISC = BotaniaTags.Items.MISC_SPECIAL_FLOWERS;

	public SpecialFlowerBlockItem(class_2248 block1, class_1793 props) {
		super(block1, props);
	}

	@Override
	public void method_7851(@NotNull class_1799 stack, class_1937 world, @NotNull List<class_2561> tooltip, @NotNull class_1836 flag) {
		// Prevent crash when tooltips queried before configs load
		if (BotaniaConfig.client() != null) {
			if (world != null) {
				if (stack.method_31573(GENERATING)) {
					tooltip.add(class_2561.method_43471("botania.flowerType.generating").method_27695(class_124.field_1056, class_124.field_1078));
				} else if (stack.method_31573(FUNCTIONAL)) {
					tooltip.add(class_2561.method_43471("botania.flowerType.functional").method_27695(class_124.field_1056, class_124.field_1078));
				} else if (stack.method_31573(MISC)) {
					tooltip.add(class_2561.method_43471("botania.flowerType.misc").method_27695(class_124.field_1056, class_124.field_1078));
				}
			}

			if (BotaniaConfig.client().referencesEnabled()) {
				String key = method_7876() + ".reference";
				class_5250 lore = class_2561.method_43471(key);
				if (!lore.getString().equals(key)) {
					tooltip.add(lore.method_27695(class_124.field_1056, class_124.field_1080));
				}
			}
		}
	}

	@Override
	public boolean method_31567(class_1799 stack) {
		class_2487 tag = stack.method_7941("BlockEntityTag");
		return tag != null && tag.method_10545(HydroangeasBlockEntity.TAG_PASSIVE_DECAY_TICKS);
	}

	@Override
	public int method_31569(class_1799 stack) {
		class_2487 tag = stack.method_7941("BlockEntityTag");
		if (tag != null) {
			float frac = 1 - tag.method_10550(HydroangeasBlockEntity.TAG_PASSIVE_DECAY_TICKS) / (float) HydroangeasBlockEntity.DECAY_TIME;
			return Math.round(13F * frac);
		}
		return 0;
	}

	@Override
	public int method_31571(class_1799 stack) {
		class_2487 tag = stack.method_7941("BlockEntityTag");
		if (tag != null) {
			float frac = 1 - tag.method_10550(HydroangeasBlockEntity.TAG_PASSIVE_DECAY_TICKS) / (float) HydroangeasBlockEntity.DECAY_TIME;
			return class_3532.method_15369(frac / 3.0F, 1.0F, 1.0F);
		}
		return 0;
	}
}
