/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.client.render.world;

import org.jetbrains.annotations.NotNull;

import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.common.item.AstrolabeItem;

import java.util.List;
import net.minecraft.class_1087;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3965;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4599;
import net.minecraft.class_4608;
import net.minecraft.class_776;
import net.minecraft.class_7924;

public final class AstrolabePreviewHandler {
	public static void onWorldRenderLast(class_4587 ms, class_4599 buffers, class_1937 level) {
		class_4597.class_4598 bufferSource = buffers.method_23000();
		class_4588 buffer = bufferSource.getBuffer(RenderHelper.ASTROLABE_PREVIEW);

		for (class_1657 player : level.method_18456()) {
			class_1799 currentStack = player.method_6047();
			class_1268 hand = class_1268.field_5808;
			if (currentStack.method_7960() || !(currentStack.method_7909() instanceof AstrolabeItem)) {
				currentStack = player.method_6079();
				hand = class_1268.field_5810;
			}

			if (!currentStack.method_7960() && currentStack.method_7909() instanceof AstrolabeItem) {
				class_2248 block = AstrolabeItem.getBlock(currentStack, level.method_45448(class_7924.field_41254));
				if (block != class_2246.field_10124) {
					renderPlayerLook(ms, buffer, player, currentStack, hand);
				}
			}
		}

		bufferSource.method_22994(RenderHelper.ASTROLABE_PREVIEW);
	}

	private static void renderPlayerLook(class_4587 ms, class_4588 buffer, class_1657 player, class_1799 stack, class_1268 hand) {
		class_2248 blockToPlace = AstrolabeItem.getBlock(stack, player.method_37908().method_45448(class_7924.field_41254));
		int size = AstrolabeItem.getSize(stack);
		class_1750 ctx = AstrolabeItem.getBlockPlaceContext(player, hand, blockToPlace);
		List<class_2338> placePositions = AstrolabeItem.getPlacePositions(ctx, size);
		if (ctx != null && AstrolabeItem.hasBlocks(stack, player, placePositions.size(), blockToPlace)) {
			for (class_2338 pos : placePositions) {
				class_1750 placeContext = getPlaceContext(player, ctx, pos);
				class_2680 state = blockToPlace.method_9605(placeContext);
				if (state != null && placeContext.method_7716() && state.method_26184(player.method_37908(), pos)) {
					renderBlockAt(ms, buffer, state, pos);
				}
			}
		}
	}

	@NotNull
	private static class_1750 getPlaceContext(class_1657 player, class_1750 ctx, class_2338 pos) {
		class_243 newHitVec = new class_243(pos.method_10263() + class_3532.method_15385(ctx.method_17698().method_10216()),
				pos.method_10264() + class_3532.method_15385(ctx.method_17698().method_10214()),
				pos.method_10260() + class_3532.method_15385(ctx.method_17698().method_10215()));
		class_3965 newHit = new class_3965(newHitVec, ctx.method_8038(), pos, false);
		return new class_1750(player, ctx.method_20287(), ctx.method_8041(), newHit);
	}

	private static void renderBlockAt(class_4587 ms, class_4588 buffer, class_2680 state, class_2338 pos) {
		double renderPosX = class_310.method_1551().method_1561().field_4686.method_19326().method_10216();
		double renderPosY = class_310.method_1551().method_1561().field_4686.method_19326().method_10214();
		double renderPosZ = class_310.method_1551().method_1561().field_4686.method_19326().method_10215();

		ms.method_22903();
		ms.method_22904(-renderPosX, -renderPosY, -renderPosZ);

		class_776 brd = class_310.method_1551().method_1541();
		ms.method_46416(pos.method_10263(), pos.method_10264(), pos.method_10260());
		class_1087 model = brd.method_3349(state);
		int color = class_310.method_1551().method_1505().method_1697(state, null, null, 0);
		float r = (float) (color >> 16 & 255) / 255.0F;
		float g = (float) (color >> 8 & 255) / 255.0F;
		float b = (float) (color & 255) / 255.0F;
		// always use entity translucent layer so blending is turned on
		brd.method_3350().method_3367(ms.method_23760(), buffer, state, model, r, g, b, 0xF000F0, class_4608.field_21444);

		ms.method_22909();
	}

}
