/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.client.model;

import vazkii.botania.client.model.armor.ElementiumArmorModel;
import vazkii.botania.client.model.armor.ManasteelArmorModel;
import vazkii.botania.client.model.armor.ManaweaveRobeModel;
import vazkii.botania.client.model.armor.TerrasteelArmorModel;
import vazkii.botania.client.render.block_entity.CorporeaIndexBlockEntityRenderer;

import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.class_5601;
import net.minecraft.class_5607;

public class BotaniaLayerDefinitions {
	public static void init(BiConsumer<class_5601, Supplier<class_5607>> consumer) {
		consumer.accept(BotaniaModelLayers.AVATAR, () -> class_5607.method_32110(AvatarModel.createMesh(), 32, 32));
		consumer.accept(BotaniaModelLayers.BELLOWS, () -> class_5607.method_32110(BellowsModel.createMesh(), 64, 32));
		consumer.accept(BotaniaModelLayers.BREWERY, () -> class_5607.method_32110(BotanicalBreweryModel.createMesh(), 32, 16));
		consumer.accept(BotaniaModelLayers.CLOAK, () -> class_5607.method_32110(CloakModel.createMesh(), 64, 64));
		consumer.accept(BotaniaModelLayers.CORPOREA_INDEX, () -> class_5607.method_32110(CorporeaIndexBlockEntityRenderer.createMesh(), 64, 32));
		consumer.accept(BotaniaModelLayers.HOURGLASS, () -> class_5607.method_32110(HourglassModel.createMesh(), 64, 32));
		consumer.accept(BotaniaModelLayers.ELEMENTIUM_INNER_ARMOR, () -> class_5607.method_32110(ElementiumArmorModel.createInsideMesh(), 64, 128));
		consumer.accept(BotaniaModelLayers.ELEMENTIUM_OUTER_ARMOR, () -> class_5607.method_32110(ElementiumArmorModel.createOutsideMesh(), 64, 128));
		consumer.accept(BotaniaModelLayers.MANASTEEL_INNER_ARMOR, () -> class_5607.method_32110(ManasteelArmorModel.createInsideMesh(), 64, 128));
		consumer.accept(BotaniaModelLayers.MANASTEEL_OUTER_ARMOR, () -> class_5607.method_32110(ManasteelArmorModel.createOutsideMesh(), 64, 128));
		consumer.accept(BotaniaModelLayers.MANAWEAVE_INNER_ARMOR, () -> class_5607.method_32110(ManaweaveRobeModel.createInsideMesh(), 64, 128));
		consumer.accept(BotaniaModelLayers.MANAWEAVE_OUTER_ARMOR, () -> class_5607.method_32110(ManaweaveRobeModel.createOutsideMesh(), 64, 128));
		consumer.accept(BotaniaModelLayers.PIXIE, () -> class_5607.method_32110(PixieModel.createMesh(), 32, 32));
		consumer.accept(BotaniaModelLayers.PYLON_GAIA, () -> class_5607.method_32110(GaiaPylonModel.createMesh(), 64, 64));
		consumer.accept(BotaniaModelLayers.PYLON_MANA, () -> class_5607.method_32110(ManaPylonModel.createMesh(), 64, 64));
		consumer.accept(BotaniaModelLayers.PYLON_NATURA, () -> class_5607.method_32110(NaturaPylonModel.createMesh(), 64, 64));
		consumer.accept(BotaniaModelLayers.TERRASTEEL_INNER_ARMOR, () -> class_5607.method_32110(TerrasteelArmorModel.createInsideMesh(), 64, 128));
		consumer.accept(BotaniaModelLayers.TERRASTEEL_OUTER_ARMOR, () -> class_5607.method_32110(TerrasteelArmorModel.createOutsideMesh(), 64, 128));
		consumer.accept(BotaniaModelLayers.TERU_TERU_BOZU, () -> class_5607.method_32110(TeruTeruBozuModel.createMesh(), 64, 32));
	}
}
