/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.block_entity;

import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_5712;
import net.minecraft.class_7871;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.block.PhantomInkableBlock;
import vazkii.botania.api.block.Wandable;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.common.block.PlatformBlock;
import vazkii.botania.common.block.block_entity.BotaniaBlockEntities;
import vazkii.botania.common.block.block_entity.BotaniaBlockEntity;

public class PlatformBlockEntity
extends BotaniaBlockEntity
implements Wandable,
PhantomInkableBlock {
    private static final String TAG_CAMO = "camo";
    @Nullable
    private class_2680 camoState;

    public PlatformBlockEntity(class_2338 pos, class_2680 state) {
        super(BotaniaBlockEntities.PLATFORM, pos, state);
    }

    @Override
    public boolean onUsedByWand(@Nullable class_1657 player, class_1799 stack, class_2350 side) {
        if (player != null) {
            PlatformBlock.Variant variant = this.getVariant();
            if (variant.indestructible && !player.method_7337()) {
                return false;
            }
            if (this.getCamoState() == null || player.method_5715()) {
                this.swapSelfAndPass(this, true, variant);
            } else {
                this.swapSurroudings(this, false, variant);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean onPhantomInked(@Nullable class_1657 player, class_1799 stack, class_2350 side) {
        if (this.camoState == class_2246.field_10499.method_9564()) {
            return false;
        }
        if (!this.field_11863.field_9236) {
            if (player == null || !player.method_31549().field_7477) {
                stack.method_7934(1);
            }
            this.setCamoState(class_2246.field_10499.method_9564());
            this.field_11863.method_33596(null, class_5712.field_28733, this.method_11016());
            VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this);
        }
        return true;
    }

    @Nullable
    public class_2680 getCamoState() {
        return this.camoState;
    }

    public void setCamoState(@Nullable class_2680 state) {
        this.camoState = state;
        if (this.field_11863 != null) {
            this.field_11863.method_8413(this.method_11016(), this.method_11010(), this.method_11010(), 3);
            if (!this.field_11863.field_9236) {
                this.field_11863.method_8408(this.field_11867, this.method_11010().method_26204());
                this.method_5431();
            }
        }
    }

    private PlatformBlock.Variant getVariant() {
        return ((PlatformBlock)this.method_11010().method_26204()).getVariant();
    }

    private void swapSelfAndPass(PlatformBlockEntity tile, boolean empty, PlatformBlock.Variant variant) {
        this.swap(tile, empty);
        this.swapSurroudings(tile, empty, variant);
    }

    private void swapSurroudings(PlatformBlockEntity tile, boolean empty, PlatformBlock.Variant variant) {
        for (class_2350 dir : class_2350.values()) {
            class_2338 pos = tile.method_11016().method_10093(dir);
            class_2586 tileAt = this.field_11863.method_8321(pos);
            if (!(tileAt instanceof PlatformBlockEntity)) continue;
            PlatformBlockEntity platform = (PlatformBlockEntity)tileAt;
            if (tile.getVariant() != platform.getVariant() || empty != (platform.getCamoState() != null)) continue;
            this.swapSelfAndPass(platform, empty, variant);
        }
    }

    private void swap(PlatformBlockEntity tile, boolean empty) {
        tile.setCamoState(empty ? null : this.getCamoState());
    }

    @Override
    public void writePacketNBT(class_2487 cmp) {
        if (this.getCamoState() != null) {
            cmp.method_10566(TAG_CAMO, (class_2520)class_2512.method_10686((class_2680)this.getCamoState()));
        }
    }

    @Override
    public void readPacketNBT(class_2487 cmp) {
        Object holderGetter = this.field_11863 != null ? this.field_11863.method_45448(class_7924.field_41254) : class_7923.field_41175.method_46771();
        class_2680 state = class_2512.method_10681((class_7871)holderGetter, (class_2487)cmp.method_10562(TAG_CAMO));
        if (state.method_26215()) {
            state = null;
        }
        this.setCamoState(state);
        if (this.field_11863 != null && this.field_11863.field_9236) {
            this.field_11863.method_8413(this.method_11016(), this.method_11010(), this.method_11010(), 0);
        }
    }

    public Object getRenderData() {
        return new PlatformData(this);
    }

    public record PlatformData(class_2338 pos, @Nullable class_2680 state) {
        public PlatformData(PlatformBlockEntity tile) {
            this(tile.method_11016().method_10062(), tile.camoState);
        }
    }
}

