/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block.mana;

import vazkii.botania.api.mana.ManaReceiver;
import vazkii.botania.api.mana.PoolOverlayProvider;
import vazkii.botania.client.fx.SparkleParticleData;
import vazkii.botania.common.block.BotaniaBlock;

import static vazkii.botania.common.lib.ResourceLocationHelper.prefix;

import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2960;

public class ManaVoidBlock extends BotaniaBlock implements PoolOverlayProvider {
	private static final int SPARKLE_EVENT = 0;
	private static final class_2960 OVERLAY_ICON = prefix("block/mana_void_overlay");

	public ManaVoidBlock(class_2251 builder) {
		super(builder);
	}

	@Override
	public class_2960 getIcon(class_1937 world, class_2338 pos) {
		return OVERLAY_ICON;
	}

	@Override
	public boolean method_9592(class_2680 state, class_1937 level, class_2338 pos, int id, int payload) {
		if (id == SPARKLE_EVENT) {
			if (level.field_9236) {
				for (int i = 0; i < 10; i++) {
					SparkleParticleData data = SparkleParticleData.sparkle(0.7F + 0.5F * (float) Math.random(), 0.2F, 0.2F, 0.2F, 5);
					level.method_8406(data, pos.method_10263() + Math.random(), pos.method_10264() + Math.random(), pos.method_10260() + Math.random(), 0, 0, 0);
				}
			}
			return true;
		}
		return super.method_9592(state, level, pos, id, payload);
	}

	public static class ManaReceiverImpl implements ManaReceiver {
		private final class_1937 level;
		private final class_2338 pos;
		private final class_2680 state;

		public ManaReceiverImpl(class_1937 level, class_2338 pos, class_2680 state) {
			this.level = level;
			this.pos = pos;
			this.state = state;
		}

		@Override
		public class_1937 getManaReceiverLevel() {
			return level;
		}

		@Override
		public class_2338 getManaReceiverPos() {
			return pos;
		}

		@Override
		public int getCurrentMana() {
			return 0;
		}

		@Override
		public boolean isFull() {
			return false;
		}

		@Override
		public void receiveMana(int mana) {
			if (mana > 0) {
				level.method_8427(pos, state.method_26204(), SPARKLE_EVENT, 0);
			}
		}

		@Override
		public boolean canReceiveManaFromBursts() {
			return true;
		}
	}

}
