/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.integration.jei;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_2371;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.api.recipe.BotanicalBreweryRecipe;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.lib.ResourceLocationHelper;

public class BreweryRecipeCategory
implements IRecipeCategory<BotanicalBreweryRecipe> {
    public static final RecipeType<BotanicalBreweryRecipe> TYPE = RecipeType.create((String)"botania", (String)"brewery", BotanicalBreweryRecipe.class);
    private final IDrawableStatic background;
    private final IDrawable icon;
    private final class_2561 localizedName;

    public BreweryRecipeCategory(IGuiHelper guiHelper) {
        class_2960 location = ResourceLocationHelper.prefix("textures/gui/nei_brewery.png");
        this.background = guiHelper.createDrawable(location, 28, 6, 131, 55);
        this.localizedName = class_2561.method_43471((String)"botania.nei.brewery");
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new class_1799((class_1935)BotaniaBlocks.brewery));
    }

    @NotNull
    public RecipeType<BotanicalBreweryRecipe> getRecipeType() {
        return TYPE;
    }

    @NotNull
    public class_2561 getTitle() {
        return this.localizedName;
    }

    @NotNull
    public IDrawable getBackground() {
        return this.background;
    }

    @NotNull
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(@NotNull IRecipeLayoutBuilder builder, @NotNull BotanicalBreweryRecipe recipe, @NotNull IFocusGroup focuses) {
        ArrayList<class_1799> outputs = new ArrayList<class_1799>();
        ArrayList<class_1799> containers = new ArrayList<class_1799>();
        for (class_1799 container : new class_1799[]{new class_1799((class_1935)BotaniaItems.vial), new class_1799((class_1935)BotaniaItems.flask), new class_1799((class_1935)BotaniaItems.incenseStick), new class_1799((class_1935)BotaniaItems.bloodPendant)}) {
            class_1799 brewed = recipe.getOutput(container);
            if (brewed.method_7960()) continue;
            containers.add(container);
            outputs.add(brewed);
        }
        IFocus outputFocus = focuses.getFocuses((IIngredientType)VanillaTypes.ITEM_STACK, RecipeIngredientRole.OUTPUT).findAny().orElse(null);
        IFocus inputFocus = focuses.getFocuses((IIngredientType)VanillaTypes.ITEM_STACK, RecipeIngredientRole.INPUT).findAny().orElse(null);
        builder.addSlot(RecipeIngredientRole.INPUT, 11, 36).addItemStacks(this.getItemMatchingFocus((IFocus<class_1799>)outputFocus, outputs, containers));
        class_2371 inputs = recipe.method_8117();
        int posX = 67 - inputs.size() * 9;
        for (class_1856 ingr : inputs) {
            builder.addSlot(RecipeIngredientRole.INPUT, posX, 0).addIngredients(ingr);
            posX += 18;
        }
        builder.addSlot(RecipeIngredientRole.OUTPUT, 59, 36).addItemStacks(this.getItemMatchingFocus((IFocus<class_1799>)inputFocus, containers, outputs));
    }

    private List<class_1799> getItemMatchingFocus(IFocus<class_1799> focus, List<class_1799> focused, List<class_1799> other) {
        if (focus != null) {
            class_1799 focusStack = (class_1799)focus.getTypedValue().getIngredient();
            for (int i = 0; i < focused.size(); ++i) {
                if (!class_1799.method_7984((class_1799)focusStack, (class_1799)focused.get(i))) continue;
                return Collections.singletonList(other.get(i));
            }
        }
        return other;
    }
}

