/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.fx;

import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4599;
import org.apache.commons.lang3.tuple.Pair;
import org.joml.Matrix4f;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.client.fx.BoltParticleOptions;

public class BoltRenderer {
    public static final BoltRenderer INSTANCE = new BoltRenderer();
    private static final float REFRESH_TIME = 3.0f;
    private static final double LIFETIME_AFTER_LAST_BOLT = 100.0;
    private Timestamp refreshTimestamp = Timestamp.ZERO;
    private final Random random = new Random();
    private final List<BoltEmitter> boltEmitters = new LinkedList<BoltEmitter>();

    public static void onWorldRenderLast(class_4184 camera, float partialTicks, class_4587 ps, class_4599 buffers) {
        ps.method_22903();
        class_243 camVec = camera.method_19326();
        ps.method_22904(-camVec.field_1352, -camVec.field_1351, -camVec.field_1350);
        class_4597.class_4598 bufferSource = buffers.method_23000();
        INSTANCE.render(partialTicks, ps, (class_4597)bufferSource);
        bufferSource.method_22994(RenderHelper.LIGHTNING);
        ps.method_22909();
    }

    public void render(float partialTicks, class_4587 matrixStack, class_4597 buffers) {
        class_4588 buffer = buffers.getBuffer(RenderHelper.LIGHTNING);
        Matrix4f matrix = matrixStack.method_23760().method_23761();
        Timestamp timestamp = new Timestamp(class_310.method_1551().field_1687.method_8510(), partialTicks);
        boolean refresh = timestamp.isPassed(this.refreshTimestamp, 0.3333333432674408);
        if (refresh) {
            this.refreshTimestamp = timestamp;
        }
        Iterator<BoltEmitter> iter = this.boltEmitters.iterator();
        while (iter.hasNext()) {
            BoltEmitter emitter = iter.next();
            emitter.renderTick(timestamp, refresh, matrix, buffer);
            if (!emitter.shouldRemove(timestamp)) continue;
            iter.remove();
        }
    }

    public void add(class_1937 level, BoltParticleOptions options, float partialTicks) {
        if (!level.field_9236) {
            return;
        }
        BoltEmitter emitter = new BoltEmitter(options);
        Timestamp timestamp = new Timestamp(level.method_8510(), partialTicks);
        if ((!emitter.options.getSpawnFunction().isConsecutive() || emitter.bolts.isEmpty()) && timestamp.isPassed(emitter.lastBoltTimestamp, emitter.lastBoltDelay)) {
            emitter.addBolt(new BoltInstance(options, timestamp), timestamp);
        }
        emitter.lastUpdateTimestamp = timestamp;
        this.boltEmitters.add(emitter);
    }

    private static class Timestamp {
        public static final Timestamp ZERO = new Timestamp(0L, 0.0f);
        private final long ticks;
        private final float partial;

        public Timestamp(long ticks, float partial) {
            this.ticks = ticks;
            this.partial = partial;
        }

        public Timestamp subtract(Timestamp other) {
            long newTicks = this.ticks - other.ticks;
            float newPartial = this.partial - other.partial;
            if (newPartial < 0.0f) {
                newPartial += 1.0f;
                --newTicks;
            }
            return new Timestamp(newTicks, newPartial);
        }

        public float value() {
            return (float)this.ticks + this.partial;
        }

        public boolean isPassed(Timestamp prev, double duration) {
            long ticksPassed = this.ticks - prev.ticks;
            if ((double)ticksPassed > duration) {
                return true;
            }
            if ((duration -= (double)ticksPassed) >= 1.0) {
                return false;
            }
            return (double)(this.partial - prev.partial) >= duration;
        }
    }

    public class BoltEmitter {
        private final Set<BoltInstance> bolts = new ObjectOpenHashSet();
        private final BoltParticleOptions options;
        private Timestamp lastBoltTimestamp = Timestamp.ZERO;
        private Timestamp lastUpdateTimestamp = Timestamp.ZERO;
        private double lastBoltDelay;

        public BoltEmitter(BoltParticleOptions options) {
            this.options = options;
        }

        private void addBolt(BoltInstance instance, Timestamp timestamp) {
            this.bolts.add(instance);
            this.lastBoltDelay = instance.options.getSpawnFunction().getSpawnDelay(BoltRenderer.this.random);
            this.lastBoltTimestamp = timestamp;
        }

        public void renderTick(Timestamp timestamp, boolean refresh, Matrix4f matrix, class_4588 buffer) {
            if (refresh) {
                this.bolts.removeIf(bolt -> bolt.tick(timestamp));
            }
            if (this.bolts.isEmpty() && this.options != null && this.options.getSpawnFunction().isConsecutive()) {
                this.addBolt(new BoltInstance(this.options, timestamp), timestamp);
            }
            this.bolts.forEach(bolt -> bolt.render(matrix, buffer, timestamp));
        }

        public boolean shouldRemove(Timestamp timestamp) {
            return this.bolts.isEmpty() && timestamp.isPassed(this.lastUpdateTimestamp, 100.0);
        }
    }

    private static class BoltInstance {
        private final BoltParticleOptions options;
        private final List<BoltParticleOptions.BoltQuads> renderQuads;
        private final Timestamp createdTimestamp;

        public BoltInstance(BoltParticleOptions options, Timestamp timestamp) {
            this.options = options;
            this.renderQuads = options.generate();
            this.createdTimestamp = timestamp;
        }

        public void render(Matrix4f matrix, class_4588 buffer, Timestamp timestamp) {
            float lifeScale = timestamp.subtract(this.createdTimestamp).value() / (float)this.options.getLifespan();
            Pair<Integer, Integer> bounds = this.options.getFadeFunction().getRenderBounds(this.renderQuads.size(), lifeScale);
            for (int i = ((Integer)bounds.getLeft()).intValue(); i < (Integer)bounds.getRight(); ++i) {
                this.renderQuads.get(i).getVecs().forEach(v -> buffer.method_22918(matrix, (float)v.field_1352, (float)v.field_1351, (float)v.field_1350).method_22915(this.options.getColor().x(), this.options.getColor().y(), this.options.getColor().z(), this.options.getColor().w()).method_1344());
            }
        }

        public boolean tick(Timestamp timestamp) {
            return timestamp.isPassed(this.createdTimestamp, this.options.getLifespan());
        }
    }
}

