/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.entity;

import com.google.common.collect.ImmutableMap;
import org.jetbrains.annotations.NotNull;

import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.item.BotaniaItems;

import java.util.Map;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1682;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2392;
import net.minecraft.class_2398;
import net.minecraft.class_2541;
import net.minecraft.class_2680;
import net.minecraft.class_2746;
import net.minecraft.class_2940;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3856;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_6024;
import net.minecraft.class_6088;

public class VineBallEntity extends class_1682 implements class_3856 {
	private static final class_2940<Float> GRAVITY = class_2945.method_12791(VineBallEntity.class, class_2943.field_13320);
	private static final Map<class_2350, class_2746> propMap = ImmutableMap.of(class_2350.field_11043, class_2541.field_11706, class_2350.field_11035, class_2541.field_11699,
			class_2350.field_11039, class_2541.field_11696, class_2350.field_11034, class_2541.field_11702);

	public VineBallEntity(class_1299<VineBallEntity> type, class_1937 world) {
		super(type, world);
	}

	public VineBallEntity(class_1309 thrower, boolean gravity) {
		super(BotaniaEntities.VINE_BALL, thrower, thrower.method_37908());
		field_6011.method_12778(GRAVITY, gravity ? 0.03F : 0F);
	}

	public VineBallEntity(double x, double y, double z, class_1937 worldIn) {
		super(BotaniaEntities.VINE_BALL, x, y, z, worldIn);
		field_6011.method_12778(GRAVITY, 0.03F);
	}

	@Override
	protected void method_5693() {
		field_6011.method_12784(GRAVITY, 0F);
	}

	@Override
	public void method_5711(byte id) {
		if (id == class_6024.field_30028) {
			for (int j = 0; j < 16; j++) {
				method_37908().method_8406(new class_2392(class_2398.field_11218, new class_1799(BotaniaItems.vineBall)), method_23317(), method_23318(), method_23321(), Math.random() * 0.2 - 0.1, Math.random() * 0.25, Math.random() * 0.2 - 0.1);
			}
		}
	}

	private void effectAndDieWithDrop() {
		effectAndDie();
		class_1542 itemEntity = new class_1542(method_37908(), method_23317(), method_23318(), method_23321(), new class_1799(BotaniaItems.vineBall));
		itemEntity.method_6988();
		method_37908().method_8649(itemEntity);
	}

	private void effectAndDie() {
		this.method_37908().method_8421(this, class_6024.field_30028);
		method_31472();
	}

	@Override
	protected void method_7454(@NotNull class_3966 hit) {
		super.method_7454(hit);
		if (!method_37908().field_9236) {
			effectAndDieWithDrop();
		}
	}

	@Override
	protected void method_24920(@NotNull class_3965 hit) {
		if (!this.method_37908().field_9236) {
			class_2350 dir = hit.method_17780();

			class_2338 pos = hit.method_17777();
			class_2680 hitState = this.method_37908().method_8320(hit.method_17777());
			if (!hitState.method_27852(BotaniaBlocks.solidVines)) {
				pos = pos.method_10093(dir);
			}

			int vinesPlaced = 0;
			if (dir.method_10166() != class_2350.class_2351.field_11052) {
				while (pos.method_10264() > this.method_37908().method_8597().comp_651() && vinesPlaced < 9) {
					class_2680 state = this.method_37908().method_8320(pos);
					if (state.method_45474() && !state.method_27852(BotaniaBlocks.solidVines)) {
						class_2680 stateToPlace = BotaniaBlocks.solidVines.method_9564().method_11657(propMap.get(dir.method_10153()), true);

						if (!stateToPlace.method_26184(this.method_37908(), pos)) {
							break;
						}
						this.method_37908().method_8501(pos, stateToPlace);
						this.method_37908().method_20290(class_6088.field_31144, pos, class_2248.method_9507(stateToPlace));
						vinesPlaced++;
					}
					if (this.method_37908().method_8320(pos).method_27852(BotaniaBlocks.solidVines)) {
						pos = pos.method_10074();
					} else {
						break;
					}
				}
			}

			if (vinesPlaced == 0) {
				effectAndDieWithDrop();
			} else {
				effectAndDie();
			}
		}
	}

	@Override
	protected float method_7490() {
		return field_6011.method_12789(GRAVITY);
	}

	@NotNull
	@Override
	public class_1799 method_7495() {
		return new class_1799(BotaniaItems.vineBall);
	}
}
