package vazkii.botania.client.integration.ears;

import com.unascribed.ears.api.EarsFeatureType;
import com.unascribed.ears.api.OverrideResult;
import com.unascribed.ears.api.registry.EarsInhibitorRegistry;
import com.unascribed.ears.api.registry.EarsStateOverriderRegistry;
import net.minecraft.class_1263;
import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import vazkii.botania.api.item.PhantomInkable;
import vazkii.botania.common.handler.EquipmentHandler;
import vazkii.botania.common.item.equipment.bauble.FlugelTiaraItem;
import vazkii.botania.common.lib.LibMisc;

public class EarsIntegration {
	public static void register() {
		EarsStateOverriderRegistry.register(LibMisc.MOD_ID, (state, peer) -> {
			if (!(peer instanceof class_1657 player)) {
				return OverrideResult.DEFAULT;
			}

			class_1304 slot = null;
			switch (state) {
				case WEARING_HELMET -> slot = class_1304.field_6169;
				case WEARING_CHESTPLATE -> slot = class_1304.field_6174;
				case WEARING_LEGGINGS -> slot = class_1304.field_6172;
				case WEARING_BOOTS -> slot = class_1304.field_6166;
			}

			if (slot == null) {
				return OverrideResult.DEFAULT;
			}

			class_1799 stack = player.method_6118(slot);
			if (!(stack.method_7909() instanceof PhantomInkable item)) {
				return OverrideResult.DEFAULT;
			}

			if (!item.hasPhantomInk(stack)) {
				return OverrideResult.DEFAULT;
			}

			return OverrideResult.FALSE;
		});

		EarsInhibitorRegistry.register(LibMisc.MOD_ID, ((type, peer) -> {
			if (type != EarsFeatureType.WINGS) {
				return false;
			}

			if (!(peer instanceof class_1657 player)) {
				return false;
			}

			class_1263 equipment = EquipmentHandler.getAllWorn(player);

			for (int slot = 0; slot < equipment.method_5439(); slot++) {
				class_1799 item = equipment.method_5438(slot);
				if (item.method_7909() instanceof FlugelTiaraItem tiara &&
						tiara.hasRender(item, player) &&
						FlugelTiaraItem.getVariant(item) > 0) {
					return true;
				}
			}

			return false;
		}));
	};
}
