/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.fabric.integration.rei;

import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import net.minecraft.class_1799;
import org.jetbrains.annotations.NotNull;

import vazkii.botania.common.crafting.BotanicalBreweryRecipe;
import vazkii.botania.common.item.BotaniaItems;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class BreweryREIDisplay extends BotaniaRecipeDisplay<BotanicalBreweryRecipe> {
	private final EntryIngredient containers;

	public BreweryREIDisplay(BotanicalBreweryRecipe recipe) {
		super(recipe);
		List<class_1799> items = Arrays.asList(new class_1799(BotaniaItems.vial), new class_1799(BotaniaItems.flask), new class_1799(BotaniaItems.incenseStick), new class_1799(BotaniaItems.bloodPendant));
		this.containers = EntryIngredients.ofItemStacks(items);
		List<class_1799> outputs = new ArrayList<>();
		for (class_1799 stack : items) {
			class_1799 brewed = recipe.getOutput(stack);
			if (!brewed.method_7960()) {
				outputs.add(brewed);
			}
		}
		this.outputs = EntryIngredients.ofItemStacks(outputs);
	}

	public EntryIngredient getContainers() {
		return this.containers;
	}

	@Override
	public int getManaCost() {
		return recipe.getManaUsage();
	}

	@Override
	public @NotNull CategoryIdentifier<?> getCategoryIdentifier() {
		return BotaniaREICategoryIdentifiers.BREWERY;
	}
}
