/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.item;

import org.jetbrains.annotations.NotNull;

import vazkii.botania.common.handler.BotaniaSounds;
import vazkii.botania.common.helper.ItemNBTHelper;

import java.util.List;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1657;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_3419;
import net.minecraft.class_5536;
import net.minecraft.class_5630;

public class StoneOfTemperanceItem extends class_1792 {
	public static final String TAG_ACTIVE = "active";

	public StoneOfTemperanceItem(class_1793 builder) {
		super(builder);
	}

	@NotNull
	@Override
	public class_1271<class_1799> method_7836(class_1937 world, class_1657 player, @NotNull class_1268 hand) {
		class_1799 stack = player.method_5998(hand);
		toggleActive(stack, player, world);
		return class_1271.method_29237(stack, world.method_8608());
	}

	@Override
	public void method_7851(class_1799 stack, class_1937 world, List<class_2561> stacks, class_1836 flags) {
		if (ItemNBTHelper.getBoolean(stack, TAG_ACTIVE, false)) {
			stacks.add(class_2561.method_43471("botaniamisc.active"));
		} else {
			stacks.add(class_2561.method_43471("botaniamisc.inactive"));
		}
	}

	public static boolean hasTemperanceActive(class_1657 player) {
		class_1263 inv = player.method_31548();
		for (int i = 0; i < inv.method_5439(); i++) {
			class_1799 stack = inv.method_5438(i);
			if (!stack.method_7960() && stack.method_31574(BotaniaItems.temperanceStone) && ItemNBTHelper.getBoolean(stack, TAG_ACTIVE, false)) {
				return true;
			}
		}

		return false;
	}

	@Override
	public boolean method_31566(class_1799 stack, class_1799 cursor, class_1735 slot, class_5536 click, class_1657 player, class_5630 access) {
		class_1937 world = player.method_37908();
		if (click == class_5536.field_27014 && slot.method_32754(player) && cursor.method_7960()) {
			toggleActive(stack, player, world);
			access.method_32332(cursor);
			return true;
		}
		return false;
	}

	private void toggleActive(class_1799 stack, class_1657 player, class_1937 world) {
		ItemNBTHelper.setBoolean(stack, TAG_ACTIVE, !ItemNBTHelper.getBoolean(stack, TAG_ACTIVE, false));
		world.method_43128(player, player.method_23317(), player.method_23318(), player.method_23321(), BotaniaSounds.temperanceStoneConfigure, class_3419.field_15254, 1F, 1F);
	}

}
