/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.item;

import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import vazkii.botania.common.helper.ItemNBTHelper;

/**
 * An inventory that writes into the provided stack's NBT on save
 */
public class ItemBackedInventory extends class_1277 {
	private static final String TAG_ITEMS = "Items";
	private final class_1799 stack;

	public ItemBackedInventory(class_1799 stack, int expectedSize) {
		super(expectedSize);
		this.stack = stack;

		class_2499 lst = ItemNBTHelper.getList(stack, TAG_ITEMS, class_2520.field_33260, false);
		int i = 0;
		for (; i < expectedSize && i < lst.size(); i++) {
			method_5447(i, class_1799.method_7915(lst.method_10602(i)));
		}
	}

	@Override
	public boolean method_5443(class_1657 player) {
		return !stack.method_7960();
	}

	@Override
	public void method_5431() {
		super.method_5431();
		class_2499 list = new class_2499();
		for (int i = 0; i < method_5439(); i++) {
			list.add(method_5438(i).method_7953(new class_2487()));
		}
		ItemNBTHelper.setList(stack, TAG_ITEMS, list);
	}
}
