/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.crafting.recipe;

import com.google.gson.JsonObject;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1865;
import net.minecraft.class_1869;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_5455;
import net.minecraft.class_8566;
import org.jetbrains.annotations.NotNull;

import vazkii.botania.common.block.decor.BotaniaMushroomBlock;
import vazkii.botania.common.item.WandOfTheForestItem;
import vazkii.botania.common.item.material.MysticalPetalItem;

public class WandOfTheForestRecipe extends class_1869 {
	public static final class_1865<WandOfTheForestRecipe> SERIALIZER = new Serializer();

	public WandOfTheForestRecipe(class_1869 compose) {
		super(compose.method_8114(), compose.method_8112(), compose.method_45441(), compose.method_8150(), compose.method_8158(),
				compose.method_8117(),
				// XXX: Hacky, but compose should always be a vanilla shaped recipe which doesn't do anything with the
				// RegistryAccess
				compose.method_8110(class_5455.field_40585));
	}

	@NotNull
	@Override
	public class_1799 method_17727(class_8566 inv, @NotNull class_5455 registries) {
		int first = -1;
		for (int i = 0; i < inv.method_5439(); i++) {
			class_1799 stack = inv.method_5438(i);
			class_1792 item = stack.method_7909();

			int colorId;
			if (item instanceof MysticalPetalItem petal) {
				colorId = petal.color.method_7789();
			} else if (item instanceof class_1747 block && block.method_7711() instanceof BotaniaMushroomBlock mushroom) {
				colorId = mushroom.color.method_7789();
			} else {
				continue;
			}
			if (first == -1) {
				first = colorId;
			} else {
				return WandOfTheForestItem.setColors(method_8110(registries).method_7972(), first, colorId);
			}
		}
		return WandOfTheForestItem.setColors(method_8110(registries).method_7972(), first != -1 ? first : 0, 0);
	}

	@NotNull
	@Override
	public class_1865<?> method_8119() {
		return SERIALIZER;
	}

	private static class Serializer implements class_1865<WandOfTheForestRecipe> {
		@NotNull
		@Override
		public WandOfTheForestRecipe method_8121(@NotNull class_2960 recipeId, @NotNull JsonObject json) {
			return new WandOfTheForestRecipe(field_9035.method_8121(recipeId, json));
		}

		@NotNull
		@Override
		public WandOfTheForestRecipe method_8122(@NotNull class_2960 recipeId, @NotNull class_2540 buffer) {
			return new WandOfTheForestRecipe(field_9035.method_8122(recipeId, buffer));
		}

		@Override
		public void toNetwork(@NotNull class_2540 buffer, @NotNull WandOfTheForestRecipe recipe) {
			field_9035.method_8124(buffer, recipe);
		}
	}
}
