/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.item.relic;

import vazkii.botania.api.item.Relic;
import vazkii.botania.common.handler.EquipmentHandler;
import vazkii.botania.common.item.BotaniaItems;

import static vazkii.botania.common.lib.ResourceLocationHelper.prefix;

import net.minecraft.class_1657;
import net.minecraft.class_1799;

public class RingOfThorItem extends RelicBaubleItem {

	public RingOfThorItem(class_1793 props) {
		super(props);
	}

	public static Relic makeRelic(class_1799 stack) {
		return new RelicImpl(stack, prefix("challenge/thor_ring"));
	}

	public static class_1799 getThorRing(class_1657 player) {
		return EquipmentHandler.findOrEmpty(BotaniaItems.thorRing, player);
	}
}
