/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block;

import net.minecraft.class_1264;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1676;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_5558;
import net.minecraft.class_5712;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.common.block.block_entity.BotaniaBlockEntities;
import vazkii.botania.common.block.block_entity.IncensePlateBlockEntity;

public class IncensePlateBlock extends BotaniaWaterloggedBlock implements class_2343 {

	private static final class_265 X_SHAPE = method_9541(6, 0, 2, 10, 1, 14);
	private static final class_265 Z_SHAPE = method_9541(2, 0, 6, 14, 1, 10);

	protected IncensePlateBlock(class_2251 builder) {
		super(builder);
		method_9590(method_9564().method_11657(class_2741.field_12481, class_2350.field_11035));
	}

	@Override
	protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
		super.method_9515(builder);
		builder.method_11667(class_2741.field_12481);
	}

	@Override
	public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
		IncensePlateBlockEntity plate = (IncensePlateBlockEntity) world.method_8321(pos);
		class_1799 plateStack = plate.getItemHandler().method_5438(0);
		class_1799 stack = player.method_5998(hand);
		boolean did = false;

		if (plateStack.method_7960() && plate.acceptsItem(stack)) {
			plate.getItemHandler().method_5447(0, stack.method_7972());
			world.method_33596(null, class_5712.field_28733, pos);
			stack.method_7934(1);
			did = true;
		} else if (!plateStack.method_7960() && !plate.burning) {
			if (!stack.method_7960() && stack.method_31574(class_1802.field_8884)) {
				plate.ignite();
				stack.method_7956(1, player, e -> e.method_20236(hand));
			} else {
				player.method_31548().method_7398(plateStack);
				plate.getItemHandler().method_5447(0, class_1799.field_8037);
				world.method_33596(null, class_5712.field_28733, pos);
			}
			did = true;
		}

		if (did) {
			VanillaPacketDispatcher.dispatchTEToNearbyPlayers(plate);
		}

		return did
				? class_1269.method_29236(world.method_8608())
				: class_1269.field_5811;
	}

	@Override
	public class_2680 method_9605(class_1750 context) {
		return super.method_9605(context).method_11657(class_2741.field_12481, context.method_8042().method_10153());
	}

	@NotNull
	@Override
	public class_2680 method_9569(@NotNull class_2680 state, class_2415 mirror) {
		return state.method_11657(class_2741.field_12481, mirror.method_10343(state.method_11654(class_2741.field_12481)));
	}

	@NotNull
	@Override
	public class_2680 method_9598(@NotNull class_2680 state, class_2470 rot) {
		return state.method_11657(class_2741.field_12481, rot.method_10503(state.method_11654(class_2741.field_12481)));
	}

	@Override
	public boolean method_9498(class_2680 state) {
		return true;
	}

	@Override
	public int method_9572(class_2680 state, class_1937 world, class_2338 pos) {
		return ((IncensePlateBlockEntity) world.method_8321(pos)).comparatorOutput;
	}

	@NotNull
	@Override
	public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 ctx) {
		if (state.method_11654(class_2741.field_12481).method_10166() == class_2350.class_2351.field_11048) {
			return X_SHAPE;
		} else {
			return Z_SHAPE;
		}
	}

	@NotNull
	@Override
	public class_2586 method_10123(@NotNull class_2338 pos, @NotNull class_2680 state) {
		return new IncensePlateBlockEntity(pos, state);
	}

	@Nullable
	@Override
	public <T extends class_2586> class_5558<T> method_31645(class_1937 level, class_2680 state, class_2591<T> type) {
		return createTickerHelper(type, BotaniaBlockEntities.INCENSE_PLATE, IncensePlateBlockEntity::commonTick);
	}

	@Override
	public void method_9536(@NotNull class_2680 state, @NotNull class_1937 world, @NotNull class_2338 pos, @NotNull class_2680 newState, boolean isMoving) {
		if (!state.method_27852(newState.method_26204())) {
			class_2586 block = world.method_8321(pos);
			if (block instanceof IncensePlateBlockEntity plate && !plate.burning) {
				class_1264.method_5451(world, pos, plate.getItemHandler());
			}
		}
		super.method_9536(state, world, pos, newState, isMoving);
	}

	@Override
	public void method_19286(@NotNull class_1937 level, @NotNull class_2680 blockState,
			@NotNull class_3965 hit, @NotNull class_1676 projectile) {
		if (!level.field_9236 && projectile.method_36971(level, hit.method_17777())
				&& projectile.method_5809()) {
			if (level.method_8321(hit.method_17777()) instanceof IncensePlateBlockEntity plate) {
				plate.ignite();
				VanillaPacketDispatcher.dispatchTEToNearbyPlayers(plate);
			}
		}
	}
}
