/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.item.equipment.tool.bow;

import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.item.equipment.CustomDamageItem;
import vazkii.botania.common.item.equipment.tool.ToolCommons;

import java.util.function.Consumer;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1753;
import net.minecraft.class_1799;
import net.minecraft.class_1937;

public class LivingwoodBowItem extends class_1753 implements CustomDamageItem {
	public static final int MANA_PER_DAMAGE = 40;

	public LivingwoodBowItem(class_1793 builder) {
		super(builder);
	}

	public float chargeVelocityMultiplier() {
		return 1F;
	}

	@Override
	public void method_7888(class_1799 stack, class_1937 world, class_1297 entity, int slot, boolean selected) {
		if (!world.field_9236 && entity instanceof class_1657 player && stack.method_7919() > 0 && ManaItemHandler.instance().requestManaExactForTool(stack, player, MANA_PER_DAMAGE * 2, true)) {
			stack.method_7974(stack.method_7919() - 1);
		}
	}

	@Override
	public boolean method_7878(class_1799 bow, class_1799 material) {
		return material.method_31574(BotaniaItems.livingwoodTwig) || super.method_7878(bow, material);
	}

	@Override
	public <T extends class_1309> int damageItem(class_1799 stack, int amount, T entity, Consumer<T> onBroken) {
		return ToolCommons.damageItemIfPossible(stack, amount, entity, MANA_PER_DAMAGE);
	}
}
