/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.item;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import vazkii.botania.api.block.HornHarvestable;
import vazkii.botania.api.block.HornHarvestable.EnumHornType;
import vazkii.botania.common.block.flower.functional.BergamuteBlockEntity;
import vazkii.botania.common.handler.BotaniaSounds;
import vazkii.botania.common.lib.BotaniaTags;
import vazkii.botania.xplat.XplatAbstractions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1839;
import net.minecraft.class_1937;
import net.minecraft.class_2261;
import net.minecraft.class_2338;
import net.minecraft.class_2397;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3419;
import net.minecraft.class_5328;
import net.minecraft.class_5712;

public class HornItem extends class_1792 {
	public HornItem(class_1793 props) {
		super(props);
	}

	@NotNull
	@Override
	public class_1839 method_7853(class_1799 stack) {
		return class_1839.field_8953;
	}

	@Override
	public int method_7881(class_1799 stack) {
		return 72000;
	}

	@NotNull
	@Override
	public class_1271<class_1799> method_7836(class_1937 world, class_1657 player, @NotNull class_1268 hand) {
		return class_5328.method_29282(world, player, hand);
	}

	@Override
	public void method_7852(class_1937 world, @NotNull class_1309 living, @NotNull class_1799 stack, int time) {
		if (!world.field_9236) {
			if (time != method_7881(stack) && time % 5 == 0) {
				living.method_32876(class_5712.field_39415);
				breakGrass(world, stack, living.method_24515(), living);
			}
			world.method_43128(null, living.method_23317(), living.method_23318(), living.method_23321(), BotaniaSounds.hornDoot, class_3419.field_15245, 1F, 1F);
		}
	}

	private static boolean canHarvest(class_1937 level, class_1799 stack, class_2338 pos,
			@Nullable class_1309 user, EnumHornType type) {
		class_2680 state = level.method_8320(pos);
		class_2586 be = level.method_8321(pos);

		HornHarvestable harvestable = XplatAbstractions.INSTANCE.findHornHarvestable(level, pos, state, be);
		if (harvestable != null) {
			return harvestable.canHornHarvest(level, pos, stack, type, user);
		}
		return switch (type) {
			default -> state.method_26204() instanceof class_2261 && !state.method_26164(BotaniaTags.Blocks.SPECIAL_FLOWERS)
					|| state.method_26164(BotaniaTags.Blocks.HORN_OF_THE_WILD_BREAKABLE);
			case CANOPY -> state.method_26164(BotaniaTags.Blocks.HORN_OF_THE_CANOPY_BREAKABLE)
					&& !(state.method_26204() instanceof class_2397 && state.method_11654(class_2397.field_11200));
			case COVERING -> state.method_26164(BotaniaTags.Blocks.HORN_OF_THE_COVERING_BREAKABLE);
		};
	}

	public static void breakGrass(class_1937 world, class_1799 stack, class_2338 srcPos, @Nullable class_1309 user) {
		EnumHornType type = null;
		if (stack.method_31574(BotaniaItems.grassHorn)) {
			type = EnumHornType.WILD;
		} else if (stack.method_31574(BotaniaItems.leavesHorn)) {
			type = EnumHornType.CANOPY;
		} else if (stack.method_31574(BotaniaItems.snowHorn)) {
			type = EnumHornType.COVERING;
		}

		int range = 12 - type.ordinal() * 3;
		int rangeY = 3 + type.ordinal() * 4;
		List<class_2338> coords = new ArrayList<>();

		for (class_2338 pos : class_2338.method_10097(srcPos.method_10069(-range, -rangeY, -range),
				srcPos.method_10069(range, rangeY, range))) {
			if (BergamuteBlockEntity.isBergamuteNearby(world, pos.method_10263() + 0.5, pos.method_10264() + 0.5, pos.method_10260() + 0.5)) {
				continue;
			}

			if (HornItem.canHarvest(world, stack, pos, user, type)) {
				coords.add(pos.method_10062());
			}
		}

		Collections.shuffle(coords);

		int count = Math.min(coords.size(), 32 + type.ordinal() * 16);
		for (int i = 0; i < count; i++) {
			class_2338 currCoords = coords.get(i);
			class_2680 state = world.method_8320(currCoords);
			class_2586 be = world.method_8321(currCoords);
			HornHarvestable harvestable = XplatAbstractions.INSTANCE.findHornHarvestable(world, currCoords, state, be);

			if (harvestable != null && harvestable.hasSpecialHornHarvest(world, currCoords, stack, type, user)) {
				harvestable.harvestByHorn(world, currCoords, stack, type, user);
			} else {
				world.method_22352(currCoords, true);
			}
		}
	}

}
