package vazkii.botania.mixin;

import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2674;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.*;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import vazkii.botania.common.helper.ForcePushHelper;

@Mixin(value = class_2674.class)
public class PistonStructureResolverMixin {
	@Final
	@Mutable
	@Shadow
	private class_2338 pistonPos;

	/**
	 * Since the pushing piston block is handled separately via its position,
	 * replace it with the force relay's position when pushing blocks that way.
	 */
	@Inject(method = "<init>", at = @At(value = "RETURN"))
	private void modifyForcePushOrigin(class_1937 level, class_2338 pistonPos, class_2350 pistonDirection, boolean extending, CallbackInfo ci) {
		this.pistonPos = ForcePushHelper.isForcePush() ? ForcePushHelper.getForcePushOrigin() : pistonPos;
	}
}
