/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.data.recipes;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import org.jetbrains.annotations.Nullable;

import vazkii.botania.common.crafting.BotaniaRecipeTypes;
import vazkii.botania.common.helper.ItemNBTHelper;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.lib.BotaniaTags;

import java.util.function.Consumer;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_2246;
import net.minecraft.class_2960;
import net.minecraft.class_3489;
import net.minecraft.class_7784;

import static vazkii.botania.common.lib.ResourceLocationHelper.prefix;

public class RunicAltarProvider extends BotaniaRecipeProvider {
	public RunicAltarProvider(class_7784 packOutput) {
		super(packOutput);
	}

	@Override
	public String method_10321() {
		return "Botania runic altar recipes";
	}

	@Override
	public void buildRecipes(Consumer<net.minecraft.class_2444> consumer) {
		final int costTier1 = 5200;
		final int costTier2 = 8000;
		final int costTier3 = 12000;

		class_1856 manaSteel = class_1856.method_8106(BotaniaTags.Items.INGOTS_MANASTEEL);
		class_1856 manaDiamond = class_1856.method_8106(BotaniaTags.Items.GEMS_MANA_DIAMOND);
		class_1856 manaPowder = class_1856.method_8106(BotaniaTags.Items.DUSTS_MANA);
		consumer.accept(new FinishedRecipe(idFor("water"), new class_1799(BotaniaItems.runeWater, 2), costTier1, manaPowder, manaSteel, class_1856.method_8091(class_1802.field_8324), class_1856.method_8091(class_2246.field_10424), class_1856.method_8091(class_1802.field_8378)));
		consumer.accept(new FinishedRecipe(idFor("fire"), new class_1799(BotaniaItems.runeFire, 2), costTier1, manaPowder, manaSteel, class_1856.method_8091(class_1802.field_8729), class_1856.method_8091(class_1802.field_8054), class_1856.method_8091(class_1802.field_8790)));

		class_1856 stone = class_1856.method_8091(class_2246.field_10340);
		class_1856 coalBlock = class_1856.method_8091(class_2246.field_10381);
		consumer.accept(new FinishedRecipe(idFor("earth"), new class_1799(BotaniaItems.runeEarth, 2), costTier1, manaPowder, manaSteel, stone, coalBlock, class_1856.method_8091(class_2246.field_10251, class_2246.field_10559)));

		consumer.accept(new FinishedRecipe(idFor("air"), new class_1799(BotaniaItems.runeAir, 2), costTier1, manaPowder, manaSteel, class_1856.method_8106(class_3489.field_15542), class_1856.method_8091(class_1802.field_8153), class_1856.method_8091(class_1802.field_8276)));

		class_1856 fire = class_1856.method_8091(BotaniaItems.runeFire);
		class_1856 water = class_1856.method_8091(BotaniaItems.runeWater);
		class_1856 earth = class_1856.method_8091(BotaniaItems.runeEarth);
		class_1856 air = class_1856.method_8091(BotaniaItems.runeAir);

		class_1856 sapling = class_1856.method_8106(class_3489.field_15528);
		class_1856 leaves = class_1856.method_8106(class_3489.field_15558);
		class_1856 sand = class_1856.method_8106(class_3489.field_15532);
		consumer.accept(new FinishedRecipe(idFor("spring"), new class_1799(BotaniaItems.runeSpring), costTier2, water, fire, sapling, sapling, sapling, class_1856.method_8091(class_1802.field_8861)));
		consumer.accept(new FinishedRecipe(idFor("summer"), new class_1799(BotaniaItems.runeSummer), costTier2, earth, air, sand, sand, class_1856.method_8091(class_1802.field_8777), class_1856.method_8091(class_1802.field_8497)));
		consumer.accept(new FinishedRecipe(idFor("autumn"), new class_1799(BotaniaItems.runeAutumn), costTier2, fire, air, leaves, leaves, leaves, class_1856.method_8091(class_1802.field_8680)));

		consumer.accept(new FinishedRecipe(idFor("winter"), new class_1799(BotaniaItems.runeWinter), costTier2, water, earth, class_1856.method_8091(class_2246.field_10491), class_1856.method_8091(class_2246.field_10491), class_1856.method_8106(class_3489.field_15544), class_1856.method_8091(class_2246.field_10183)));

		class_1856 spring = class_1856.method_8091(BotaniaItems.runeSpring);
		class_1856 summer = class_1856.method_8091(BotaniaItems.runeSummer);
		class_1856 autumn = class_1856.method_8091(BotaniaItems.runeAutumn);
		class_1856 winter = class_1856.method_8091(BotaniaItems.runeWinter);

		consumer.accept(new FinishedRecipe(idFor("mana"), new class_1799(BotaniaItems.runeMana), costTier2, manaSteel, manaSteel, manaSteel, manaSteel, manaSteel, class_1856.method_8091(BotaniaItems.manaPearl)));

		consumer.accept(new FinishedRecipe(idFor("lust"), new class_1799(BotaniaItems.runeLust), costTier3, manaDiamond, manaDiamond, summer, air));
		consumer.accept(new FinishedRecipe(idFor("gluttony"), new class_1799(BotaniaItems.runeGluttony), costTier3, manaDiamond, manaDiamond, winter, fire));
		consumer.accept(new FinishedRecipe(idFor("greed"), new class_1799(BotaniaItems.runeGreed), costTier3, manaDiamond, manaDiamond, spring, water));
		consumer.accept(new FinishedRecipe(idFor("sloth"), new class_1799(BotaniaItems.runeSloth), costTier3, manaDiamond, manaDiamond, autumn, air));
		consumer.accept(new FinishedRecipe(idFor("wrath"), new class_1799(BotaniaItems.runeWrath), costTier3, manaDiamond, manaDiamond, winter, earth));
		consumer.accept(new FinishedRecipe(idFor("envy"), new class_1799(BotaniaItems.runeEnvy), costTier3, manaDiamond, manaDiamond, winter, water));
		consumer.accept(new FinishedRecipe(idFor("pride"), new class_1799(BotaniaItems.runePride), costTier3, manaDiamond, manaDiamond, summer, fire));

		consumer.accept(new FinishedHeadRecipe(idFor("head"), new class_1799(class_1802.field_8575), 22500, class_1856.method_8091(class_1802.field_8398), class_1856.method_8091(BotaniaItems.pixieDust), class_1856.method_8091(class_1802.field_8434), class_1856.method_8091(class_1802.field_8448), class_1856.method_8091(class_1802.field_8463)));
	}

	private static class_2960 idFor(String s) {
		return prefix("runic_altar/" + s);
	}

	protected static class FinishedRecipe implements net.minecraft.class_2444 {
		private final class_2960 id;
		private final class_1799 output;
		private final int mana;
		private final class_1856[] inputs;

		protected FinishedRecipe(class_2960 id, class_1799 output, int mana, class_1856... inputs) {
			this.id = id;
			this.output = output;
			this.mana = mana;
			this.inputs = inputs;
		}

		@Override
		public void method_10416(JsonObject json) {
			json.add("output", ItemNBTHelper.serializeStack(output));
			JsonArray ingredients = new JsonArray();
			for (class_1856 ingr : inputs) {
				ingredients.add(ingr.method_8089());
			}
			json.addProperty("mana", mana);
			json.add("ingredients", ingredients);
		}

		@Override
		public class_2960 method_10417() {
			return id;
		}

		@Override
		public class_1865<?> method_17800() {
			return BotaniaRecipeTypes.RUNE_SERIALIZER;
		}

		@Nullable
		@Override
		public JsonObject method_10415() {
			return null;
		}

		@Nullable
		@Override
		public class_2960 method_10418() {
			return null;
		}
	}

	private static class FinishedHeadRecipe extends FinishedRecipe {
		private FinishedHeadRecipe(class_2960 id, class_1799 output, int mana, class_1856... inputs) {
			super(id, output, mana, inputs);
		}

		@Override
		public class_1865<?> method_17800() {
			return BotaniaRecipeTypes.RUNE_HEAD_SERIALIZER;
		}
	}
}
