/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.integration.emi;

import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.TextWidget;
import dev.emi.emi.api.widget.Widget;
import dev.emi.emi.api.widget.WidgetHolder;
import it.unimi.dsi.fastutil.ints.IntIntPair;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_5684;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.recipe.OrechidRecipe;
import vazkii.botania.client.integration.emi.BotaniaEmiRecipe;
import vazkii.botania.client.integration.emi.PureDaisyEmiRecipe;
import vazkii.botania.client.integration.shared.OrechidUIHelper;

public class OrechidEmiRecipe
extends BotaniaEmiRecipe {
    private final EmiIngredient orechid;
    protected final OrechidRecipe recipe;

    public OrechidEmiRecipe(EmiRecipeCategory category, OrechidRecipe recipe, EmiIngredient orechid) {
        super(category, recipe);
        try {
            this.input = recipe.getInput().getDisplayed().stream().map(s -> EmiIngredient.of((class_1856)class_1856.method_8091((class_1935[])new class_1935[]{s.method_26204()}), (long)1L)).toList();
            this.output = recipe.getOutput().getDisplayed().stream().map(s -> EmiStack.of((class_1799)new class_1799((class_1935)s.method_26204()))).toList();
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
        this.orechid = orechid;
        this.recipe = recipe;
    }

    public int getDisplayHeight() {
        return 44;
    }

    public int getDisplayWidth() {
        return 96;
    }

    public boolean supportsRecipeTree() {
        return false;
    }

    public void addWidgets(WidgetHolder widgets) {
        PureDaisyEmiRecipe.addPureDaisyWidgets(widgets, this, (EmiIngredient)this.input.get(0), this.orechid, (EmiStack)this.output.get(0));
        final Double chance = this.getChance(this.recipe);
        if (chance != null) {
            class_2561 chanceComponent = OrechidUIHelper.getPercentageComponent(chance);
            widgets.add((Widget)new TextWidget(chanceComponent.method_30937(), 90, 3, 0x555555, false){

                public List<class_5684> getTooltip(int mouseX, int mouseY) {
                    return OrechidEmiRecipe.this.getChanceTooltipComponents(chance).map(class_2561::method_30937).map(class_5684::method_32662).toList();
                }
            }.horizontalAlign(TextWidget.Alignment.END));
        }
    }

    @NotNull
    protected Stream<class_2561> getChanceTooltipComponents(double chance) {
        IntIntPair ratio = OrechidUIHelper.getRatioForChance(chance);
        return Stream.of(OrechidUIHelper.getRatioTooltipComponent(ratio));
    }

    @Nullable
    protected Double getChance(@NotNull OrechidRecipe recipe) {
        return OrechidUIHelper.getChance(recipe, null);
    }

    public int getWeight() {
        return this.recipe.getWeight();
    }
}

